/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.virtio.AbstractVirtIODevice;
import li.cil.sedna.device.virtio.DescriptorChain;
import li.cil.sedna.device.virtio.VirtIODeviceException;
import li.cil.sedna.device.virtio.VirtIODeviceSpec;
import li.cil.sedna.device.virtio.VirtqueueIterator;
import li.cil.sedna.fs.DirectoryEntry;
import li.cil.sedna.fs.FileHandle;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.FileSystemStats;
import li.cil.sedna.fs.FileType;
import li.cil.sedna.fs.Path;

public final class VirtIOFileSystemDevice
extends AbstractVirtIODevice
implements Steppable {
    private static final int VIRTIO_9P_MAX_MESSAGE_SIZE = 8192;
    private static final String VIRTIO_9P_VERSION = "9P2000.L";
    private static final int BYTES_PER_THOUSAND_CYCLES = 32;
    private static final long VIRTIO_9P_F_MOUNT_TAG = 1L;
    private static final byte P9_MSG_TLERROR = 6;
    private static final byte P9_MSG_TSTATFS = 8;
    private static final byte P9_MSG_TLOPEN = 12;
    private static final byte P9_MSG_TLCREATE = 14;
    private static final byte P9_MSG_TSYMLINK = 16;
    private static final byte P9_MSG_TMKNOD = 18;
    private static final byte P9_MSG_TRENAME = 20;
    private static final byte P9_MSG_TREADLINK = 22;
    private static final byte P9_MSG_TGETATTR = 24;
    private static final byte P9_MSG_TSETATTR = 26;
    private static final byte P9_MSG_TXATTRWALK = 30;
    private static final byte P9_MSG_TXATTRCREATE = 32;
    private static final byte P9_MSG_TREADDIR = 40;
    private static final byte P9_MSG_TFSYNC = 50;
    private static final byte P9_MSG_TLOCK = 52;
    private static final byte P9_MSG_TGETLOCK = 54;
    private static final byte P9_MSG_TLINK = 70;
    private static final byte P9_MSG_TMKDIR = 72;
    private static final byte P9_MSG_TRENAMEAT = 74;
    private static final byte P9_MSG_TUNLINKAT = 76;
    private static final byte P9_MSG_TVERSION = 100;
    private static final byte P9_MSG_TAUTH = 102;
    private static final byte P9_MSG_TATTACH = 104;
    private static final byte P9_MSG_RERROR = 106;
    private static final byte P9_MSG_TFLUSH = 108;
    private static final byte P9_MSG_TWALK = 110;
    private static final byte P9_MSG_TOPEN = 112;
    private static final byte P9_MSG_TCREATE = 114;
    private static final byte P9_MSG_TREAD = 116;
    private static final byte P9_MSG_TWRITE = 118;
    private static final byte P9_MSG_TCLUNK = 120;
    private static final byte P9_MSG_TREMOVE = 122;
    private static final byte P9_MSG_TSTAT = 124;
    private static final byte P9_MSG_TWSTAT = 126;
    private static final int P9_S_IRWXUGO = 511;
    private static final int P9_S_ISVTX = 512;
    private static final int P9_S_ISGID = 1024;
    private static final int P9_S_ISUID = 2048;
    private static final int P9_S_IFMT = 61440;
    private static final int P9_S_IFIFO = 4096;
    private static final int P9_S_IFCHR = 8192;
    private static final int P9_S_IFDIR = 16384;
    private static final int P9_S_IFBLK = 24576;
    private static final int P9_S_IFREG = 32768;
    private static final int P9_S_IFLNK = 40960;
    private static final int P9_S_IFSOCK = 49152;
    private static final int P9_OPEN_RDONLY = 0;
    private static final int P9_OPEN_WRONLY = 1;
    private static final int P9_OPEN_RDWR = 2;
    private static final int P9_OPEN_NOACCESS = 3;
    private static final int P9_OPEN_CREAT = 64;
    private static final int P9_OPEN_EXCL = 128;
    private static final int P9_OPEN_NOCTTY = 256;
    private static final int P9_OPEN_TRUNC = 512;
    private static final int P9_OPEN_APPEND = 1024;
    private static final int P9_OPEN_NONBLOCK = 2048;
    private static final int P9_OPEN_DSYNC = 4096;
    private static final int P9_OPEN_FASYNC = 8192;
    private static final int P9_OPEN_DIRECT = 16384;
    private static final int P9_OPEN_LARGEFILE = 32768;
    private static final int P9_OPEN_DIRECTORY = 65536;
    private static final int P9_OPEN_NOFOLLOW = 131072;
    private static final int P9_OPEN_NOATIME = 262144;
    private static final int P9_OPEN_CLOEXEC = 524288;
    private static final int P9_OPEN_SYNC = 0x100000;
    private static final long P9_GETATTR_MODE = 1L;
    private static final long P9_GETATTR_NLINK = 2L;
    private static final long P9_GETATTR_UID = 4L;
    private static final long P9_GETATTR_GID = 8L;
    private static final long P9_GETATTR_RDEV = 16L;
    private static final long P9_GETATTR_ATIME = 32L;
    private static final long P9_GETATTR_MTIME = 64L;
    private static final long P9_GETATTR_CTIME = 128L;
    private static final long P9_GETATTR_INO = 256L;
    private static final long P9_GETATTR_SIZE = 512L;
    private static final long P9_GETATTR_BLOCKS = 1024L;
    private static final byte P9_QID_TYPE_DIR = -128;
    private static final byte P9_QID_TYPE_APPEND = 64;
    private static final byte P9_QID_TYPE_EXCL = 32;
    private static final byte P9_QID_TYPE_MOUNT = 16;
    private static final byte P9_QID_TYPE_AUTH = 8;
    private static final byte P9_QID_TYPE_TMP = 4;
    private static final byte P9_QID_TYPE_SYMLINK = 2;
    private static final byte P9_QID_TYPE_LINK = 1;
    private static final byte P9_QID_TYPE_FILE = 0;
    private static final byte DT_UNKNOWN = 0;
    private static final byte DT_FIFO = 1;
    private static final byte DT_CHR = 2;
    private static final byte DT_DIR = 4;
    private static final byte DT_BLK = 6;
    private static final byte DT_REG = 8;
    private static final byte DT_LNK = 10;
    private static final byte DT_SOCK = 12;
    private static final byte DT_WHT = 14;
    private static final int LINUX_ERRNO_EPERM = 1;
    private static final int LINUX_ERRNO_ENOENT = 2;
    private static final int LINUX_ERRNO_EIO = 5;
    private static final int LINUX_ERRNO_EEXIST = 17;
    private static final int LINUX_ERRNO_ENOTDIR = 20;
    private static final int LINUX_ERRNO_EINVAL = 22;
    private static final int LINUX_ERRNO_ENOSPC = 28;
    private static final int LINUX_ERRNO_ENOTEMPTY = 39;
    private static final int LINUX_ERRNO_EPROTO = 71;
    private static final int LINUX_ERRNO_ENOTSUPP = 524;
    private static final int VIRTQ_REQUEST = 0;
    private final String tag;
    private final FileSystem fileSystem;
    private int remainingByteProcessingQuota;
    @Serialized
    private final FileSystemFileMap files = new FileSystemFileMap();
    @Serialized
    private boolean hasPendingRequest;

    public VirtIOFileSystemDevice(MemoryMap memoryMap, String tag, FileSystem fileSystem) {
        super(memoryMap, VirtIODeviceSpec.builder(9).features(1L).queueCount(1).configSpaceSize(2 + Math.min(tag.length(), 65535)).build());
        this.tag = tag;
        this.fileSystem = fileSystem;
    }

    @Override
    public void reset() {
        super.reset();
        this.closeFilesAndClearFIDs();
    }

    @Override
    public void step(int cycles) {
        if (this.remainingByteProcessingQuota <= 0) {
            this.remainingByteProcessingQuota += Math.max(1, cycles * 32 / 1000);
        }
        if (!this.hasPendingRequest) {
            return;
        }
        if ((this.getStatus() & 0x80) != 0) {
            return;
        }
        try {
            int processedBytes;
            while (this.remainingByteProcessingQuota > 0 && (processedBytes = this.processRequest()) >= 0) {
                this.remainingByteProcessingQuota -= processedBytes;
            }
        }
        catch (Throwable e) {
            this.error();
        }
    }

    @Override
    protected void initializeConfig() {
        super.initializeConfig();
        ByteBuffer configuration = this.getConfiguration();
        configuration.clear();
        configuration.putShort((short)this.tag.length());
        configuration.put(this.tag.getBytes(StandardCharsets.US_ASCII));
        configuration.flip();
    }

    @Override
    protected void handleQueueNotification(int queueIndex) {
        this.hasPendingRequest = true;
    }

    private int processRequest() throws VirtIODeviceException, IOException {
        VirtqueueIterator queue = this.getQueueIterator(0);
        if (queue == null) {
            this.hasPendingRequest = false;
            return -1;
        }
        if (!queue.hasNext()) {
            this.hasPendingRequest = false;
            return -1;
        }
        DescriptorChain chain = queue.next();
        int processedBytes = chain.readableBytes() + chain.writableBytes();
        ByteBuffer request = ByteBuffer.allocate(chain.readableBytes()).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer reply = ByteBuffer.allocate(8192 - chain.readableBytes()).order(ByteOrder.LITTLE_ENDIAN);
        chain.get(request);
        request.flip();
        request.getInt();
        byte id = request.get();
        short tag = request.getShort();
        try {
            switch (id) {
                case 100: {
                    this.version(chain, request, id, tag, reply);
                    break;
                }
                case 108: {
                    this.flush(chain, id, tag);
                    break;
                }
                case 110: {
                    this.walk(chain, request, reply, id, tag);
                    break;
                }
                case 116: {
                    this.read(chain, request, id, tag, reply);
                    break;
                }
                case 118: {
                    this.write(chain, request, id, tag, reply);
                    break;
                }
                case 120: {
                    this.clunk(chain, request, id, tag);
                    break;
                }
                case 104: {
                    this.attach(chain, request, id, tag, reply);
                    break;
                }
                case 8: {
                    this.statfs(chain, reply, id, tag);
                    break;
                }
                case 12: {
                    this.open(chain, request, id, tag, reply);
                    break;
                }
                case 14: {
                    this.create(chain, request, id, tag, reply);
                    break;
                }
                case 24: {
                    this.getattr(chain, request, id, tag, reply);
                    break;
                }
                case 40: {
                    int fid = request.getInt();
                    long offset = request.getLong();
                    int count = request.getInt();
                    FileSystemFile dir = this.getFile(fid);
                    Path path = dir.getPath();
                    List<DirectoryEntry> entries = dir.readdir(this.fileSystem);
                    reply.putInt(0);
                    int dataStart = reply.position();
                    for (int i = (int)offset; i < entries.size(); ++i) {
                        DirectoryEntry entry = entries.get(i);
                        int length = 24 + entry.name.length();
                        if (reply.position() - dataStart + length > count) break;
                        byte d_type = switch (entry.type) {
                            case FileType.FILE -> 8;
                            case FileType.DIRECTORY -> 4;
                            default -> 0;
                        };
                        VirtIOFileSystemDevice.putQID(reply, this.getQID(path.resolve(entry.name)));
                        reply.putLong(i + 1);
                        reply.put(d_type);
                        this.putString(reply, entry.name);
                    }
                    reply.putInt(0, reply.position() - dataStart);
                    this.putReply(chain, id, tag, reply);
                    break;
                }
                case 50: {
                    this.fsync(chain, request, id, tag);
                    break;
                }
                case 72: {
                    this.mkdir(chain, request, id, tag, reply);
                    break;
                }
                case 74: {
                    this.renameat(chain, request, id, tag);
                    break;
                }
                case 76: {
                    this.unlinkat(chain, request, id, tag);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (MemoryAccessException e) {
            throw e;
        }
        catch (SecurityException e) {
            this.lerror(chain, tag, 1);
        }
        catch (NoSuchFileException e) {
            this.lerror(chain, tag, 2);
        }
        catch (FileAlreadyExistsException e) {
            this.lerror(chain, tag, 17);
        }
        catch (NotDirectoryException e) {
            this.lerror(chain, tag, 20);
        }
        catch (DirectoryNotEmptyException e) {
            this.lerror(chain, tag, 39);
        }
        catch (IOException e) {
            this.lerror(chain, tag, 5);
        }
        catch (UnsupportedOperationException e) {
            this.lerror(chain, tag, 524);
        }
        chain.use();
        return processedBytes;
    }

    private void version(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int msize = request.getInt();
        reply.putInt(Math.min(msize, 8192));
        this.putString(reply, VIRTIO_9P_VERSION);
        this.closeFilesAndClearFIDs();
        this.putReply(chain, id, tag, reply);
    }

    private void flush(DescriptorChain chain, byte id, short tag) throws MemoryAccessException, VirtIODeviceException {
        this.putReply(chain, id, tag);
    }

    private void walk(DescriptorChain chain, ByteBuffer request, ByteBuffer reply, byte id, short tag) throws VirtIODeviceException, IOException {
        int i;
        int fid = request.getInt();
        int newfid = request.getInt();
        int nwname = request.getShort() & 0xFFFF;
        FileSystemFile file = this.getFile(fid);
        if (file.isOpen()) {
            throw new IOException();
        }
        if (this.files.containsKey(newfid)) {
            throw new IOException();
        }
        QID[] qids = new QID[nwname];
        Path path = file.getPath();
        byte[] wname = new byte[256];
        for (i = 0; i < nwname; ++i) {
            if (!this.fileSystem.isDirectory(path)) {
                if (i != 0) break;
                throw new IOException();
            }
            int strlen = request.getShort() & 0xFFFF;
            if (strlen > wname.length) {
                throw new IOException();
            }
            request.get(wname, 0, strlen);
            path = path.resolve(new String(wname, 0, strlen, StandardCharsets.US_ASCII));
            if (!this.fileSystem.exists(path)) break;
            qids[i] = this.getQID(path);
        }
        if (i == nwname) {
            this.establishFID(newfid, path);
        }
        reply.putShort((short)i);
        for (int j = 0; j < i; ++j) {
            VirtIOFileSystemDevice.putQID(reply, qids[j]);
        }
        this.putReply(chain, id, tag, reply);
    }

    private void read(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        long offset = request.getLong();
        int count = request.getInt();
        FileSystemFile file = this.getFile(fid);
        reply.putInt(0);
        reply.limit(reply.position() + count);
        count = file.read(this.fileSystem, offset, reply);
        reply.putInt(0, count);
        this.putReply(chain, id, tag, reply);
    }

    private void write(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        long offset = request.getLong();
        int count = request.getInt();
        FileSystemFile file = this.getFile(fid);
        request.limit(request.position() + count);
        count = file.write(this.fileSystem, offset, request);
        reply.putInt(count);
        this.putReply(chain, id, tag, reply);
    }

    private void clunk(DescriptorChain chain, ByteBuffer request, byte id, short tag) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        this.clunk(fid);
        this.putReply(chain, id, tag);
    }

    private void attach(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        request.getInt();
        this.getString(request);
        this.getString(request);
        request.getInt();
        FileSystemFile file = this.establishFID(fid, this.fileSystem.getRoot());
        VirtIOFileSystemDevice.putQID(reply, this.getQID(file));
        this.putReply(chain, id, tag, reply);
    }

    private void statfs(DescriptorChain chain, ByteBuffer reply, byte id, short tag) throws IOException, VirtIODeviceException {
        FileSystemStats stats = this.fileSystem.statfs();
        reply.putInt(0);
        reply.putInt(stats.blockSize);
        reply.putLong(stats.blockCount);
        reply.putLong(stats.freeBlockCount);
        reply.putLong(stats.availableBlockCount);
        reply.putLong(stats.fileCount);
        reply.putLong(stats.freeFileCount);
        reply.putLong(0L);
        reply.putInt(stats.maxNameLength);
        this.putReply(chain, id, tag, reply);
    }

    private void open(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        int flags = request.getInt();
        FileSystemFile file = this.getFile(fid);
        file.close();
        Path path = file.getPath();
        int convertedFlags = VirtIOFileSystemDevice.convertFlags(flags);
        FileHandle handle = this.fileSystem.open(path, convertedFlags);
        file.setHandle(handle, convertedFlags);
        VirtIOFileSystemDevice.putQID(reply, this.getQID(file));
        int readWriteSumRequestResponseHeaderSize = 34;
        reply.putInt(8158);
        this.putReply(chain, id, tag, reply);
    }

    private void create(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        String name = this.getString(request);
        int flags = request.getInt();
        request.getInt();
        request.getInt();
        FileSystemFile file = this.getFile(fid);
        Path path = file.getPath().resolve(name);
        int convertedFlags = VirtIOFileSystemDevice.convertFlags(flags);
        FileHandle handle = this.fileSystem.create(path, convertedFlags);
        file.close();
        file.setPath(path);
        file.setHandle(handle, convertedFlags);
        VirtIOFileSystemDevice.putQID(reply, this.getQID(file));
        int readWriteSumRequestResponseHeaderSize = 34;
        reply.putInt(8158);
        this.putReply(chain, id, tag, reply);
    }

    private void getattr(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int mode;
        FileTime creationTime;
        FileTime lastModifiedTime;
        int fid = request.getInt();
        long request_mask = request.getLong();
        FileSystemFile file = this.getFile(fid);
        Path path = file.getPath();
        BasicFileAttributes attributes = this.fileSystem.getAttributes(path);
        long replyMask = request_mask & 0x201L;
        FileTime lastAccessTime = attributes.lastAccessTime();
        if (lastAccessTime != null) {
            replyMask |= 0x20L;
        }
        if ((lastModifiedTime = attributes.lastModifiedTime()) != null) {
            replyMask |= 0x40L;
        }
        if ((creationTime = attributes.creationTime()) != null) {
            replyMask |= 0x80L;
        }
        reply.putLong(replyMask);
        VirtIOFileSystemDevice.putQID(reply, this.getQID(file));
        int n = mode = this.fileSystem.isDirectory(path) ? 16384 : 32768;
        if (this.fileSystem.isExecutable(path)) {
            mode |= 0x49;
        }
        if (this.fileSystem.isWritable(path)) {
            mode |= 0x92;
        }
        if (this.fileSystem.isReadable(path)) {
            mode |= 0x124;
        }
        reply.putInt(mode);
        reply.putInt(0);
        reply.putInt(0);
        reply.putLong(0L);
        reply.putLong(0L);
        reply.putLong(attributes.size());
        reply.putLong(0L);
        reply.putLong(0L);
        if (lastAccessTime != null) {
            reply.putLong(lastAccessTime.toInstant().getEpochSecond());
        } else {
            reply.putLong(0L);
        }
        reply.putLong(0L);
        if (lastModifiedTime != null) {
            reply.putLong(lastModifiedTime.toInstant().getEpochSecond());
        } else {
            reply.putLong(0L);
        }
        reply.putLong(0L);
        if (creationTime != null) {
            reply.putLong(creationTime.toInstant().getEpochSecond());
        } else {
            reply.putLong(0L);
        }
        reply.putLong(0L);
        reply.putLong(0L);
        reply.putLong(0L);
        reply.putLong(0L);
        reply.putLong(0L);
        this.putReply(chain, id, tag, reply);
    }

    private void fsync(DescriptorChain chain, ByteBuffer request, byte id, short tag) throws IOException, VirtIODeviceException {
        int fid = request.getInt();
        this.getFile(fid);
        this.putReply(chain, id, tag);
    }

    private void mkdir(DescriptorChain chain, ByteBuffer request, byte id, short tag, ByteBuffer reply) throws IOException, VirtIODeviceException {
        int dfid = request.getInt();
        String name = this.getString(request);
        request.getInt();
        request.getInt();
        FileSystemFile dir = this.getFile(dfid);
        Path path = dir.getPath().resolve(name);
        this.fileSystem.mkdir(path);
        QID qid = this.getQID(path);
        VirtIOFileSystemDevice.putQID(reply, qid);
        this.putReply(chain, id, tag, reply);
    }

    private void renameat(DescriptorChain chain, ByteBuffer request, byte id, short tag) throws IOException, VirtIODeviceException {
        int olddirfid = request.getInt();
        String oldname = this.getString(request);
        int newdirfid = request.getInt();
        String newname = this.getString(request);
        FileSystemFile olddir = this.getFile(olddirfid);
        FileSystemFile newdir = this.getFile(newdirfid);
        Path oldpath = olddir.getPath().resolve(oldname);
        Path newpath = newdir.getPath().resolve(newname);
        this.fileSystem.rename(oldpath, newpath);
        this.putReply(chain, id, tag);
    }

    private void unlinkat(DescriptorChain chain, ByteBuffer request, byte id, short tag) throws IOException, VirtIODeviceException {
        int dirfd = request.getInt();
        String name = this.getString(request);
        request.getInt();
        FileSystemFile dir = this.getFile(dirfd);
        Path path = dir.getPath().resolve(name);
        this.fileSystem.unlink(path);
        this.putReply(chain, id, tag);
    }

    private static int convertFlags(int flags) {
        int result = 0;
        if ((flags & 1) != 0) {
            result |= 2;
        }
        if ((flags & 2) != 0) {
            result |= 3;
        }
        if (result == 0) {
            result = 1;
        }
        if ((flags & 0x200) != 0 && (result & 2) != 0) {
            result |= 4;
        }
        return result;
    }

    private QID getQID(FileSystemFile file) throws IOException {
        return this.getQID(file.getPath());
    }

    private QID getQID(Path path) throws IOException {
        if (!this.fileSystem.exists(path)) {
            throw new IOException();
        }
        QID qid = new QID();
        qid.type = this.fileSystem.isDirectory(path) ? (byte)-128 : (byte)0;
        qid.version = 0;
        qid.path = this.fileSystem.getUniqueId(path);
        return qid;
    }

    private String getString(ByteBuffer buffer) {
        int strlen = buffer.getShort() & 0xFFFF;
        byte[] bytes = new byte[strlen];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private void putString(ByteBuffer buffer, String value) throws IOException {
        if (value.length() > 65535) {
            throw new IOException();
        }
        buffer.putShort((short)value.length());
        buffer.put(value.getBytes(StandardCharsets.US_ASCII));
    }

    private static void putQID(ByteBuffer buffer, QID qid) {
        buffer.put(qid.type);
        buffer.putInt(qid.version);
        buffer.putLong(qid.path);
    }

    private void lerror(DescriptorChain chain, short tag, int error) throws MemoryAccessException, VirtIODeviceException {
        this.putReply(chain, (byte)6, tag, ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(error));
    }

    private void putReply(DescriptorChain chain, byte messageId, short tag) throws MemoryAccessException, VirtIODeviceException {
        this.putReply(chain, messageId, tag, null);
    }

    private void putReply(DescriptorChain chain, byte messageId, short tag, @Nullable ByteBuffer data) throws MemoryAccessException, VirtIODeviceException {
        if (data != null) {
            data.flip();
        }
        int dataLength = data != null ? data.remaining() : 0;
        ByteBuffer message = ByteBuffer.allocate(7 + dataLength).order(ByteOrder.LITTLE_ENDIAN);
        message.putInt(message.remaining());
        message.put((byte)(messageId + 1));
        message.putShort(tag);
        if (data != null) {
            message.put(data);
        }
        message.flip();
        chain.skip(chain.readableBytes());
        chain.put(message);
    }

    private FileSystemFile establishFID(int fid, Path path) throws IOException {
        if (this.files.containsKey(fid)) {
            throw new IOException();
        }
        FileSystemFile reference = new FileSystemFile(fid, path);
        this.files.put(fid, reference);
        return reference;
    }

    private FileSystemFile getFile(int fid) throws IOException {
        if (this.files.containsKey(fid)) {
            return (FileSystemFile)this.files.get(fid);
        }
        throw new IOException();
    }

    private void clunk(int fid) {
        FileSystemFile file = (FileSystemFile)this.files.remove(fid);
        if (file != null) {
            file.close();
        }
    }

    private void closeFilesAndClearFIDs() {
        for (FileSystemFile file : this.files.values()) {
            file.close();
        }
        this.files.clear();
    }

    public static final class FileSystemFileMap
    extends Int2ObjectArrayMap<FileSystemFile> {
    }

    public static final class FileSystemFile
    implements Closeable {
        @Serialized
        public int id;
        @Serialized
        public String[] pathParts;
        @Serialized
        public boolean isOpen;
        @Serialized
        public int openFlags;
        private Path path;
        private FileHandle handle;

        public FileSystemFile() {
        }

        public FileSystemFile(int id, Path path) {
            this.id = id;
            this.path = path;
            this.pathParts = path.getParts();
        }

        @Override
        public void close() {
            if (this.handle != null) {
                try {
                    this.handle.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.handle = null;
            this.isOpen = false;
            this.openFlags = 0;
        }

        public FileHandle getHandle(FileSystem fileSystem) throws IOException {
            if (this.isOpen && this.handle == null) {
                this.handle = fileSystem.open(this.getPath(), this.openFlags);
            }
            if (this.handle == null) {
                throw new IOException();
            }
            return this.handle;
        }

        public void setHandle(FileHandle handle, int flags) {
            this.close();
            this.isOpen = true;
            this.openFlags = flags & 0xFFFFFFFB;
            this.handle = handle;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public Path getPath() {
            if (this.path == null) {
                this.path = new Path(Arrays.asList(this.pathParts));
            }
            return this.path;
        }

        public void setPath(Path path) {
            this.close();
            this.path = path;
            this.pathParts = path.getParts();
        }

        public int read(FileSystem fileSystem, long offset, ByteBuffer buffer) throws IOException {
            return this.getHandle(fileSystem).read(offset, buffer);
        }

        public int write(FileSystem fileSystem, long offset, ByteBuffer buffer) throws IOException {
            return this.getHandle(fileSystem).write(offset, buffer);
        }

        public List<DirectoryEntry> readdir(FileSystem fileSystem) throws IOException {
            return this.getHandle(fileSystem).readdir();
        }
    }

    public static final class QID {
        public byte type;
        public int version;
        public long path;
    }
}

