/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.devicetree.DeviceTreeProperty;
import li.cil.sedna.devicetree.FlattenedDeviceTree;

final class DeviceTreeImpl
implements DeviceTree {
    @Nullable
    private final DeviceTreeImpl parent;
    private final DeviceTreeImpl root;
    private final Object2IntMap<Object> phandles;
    private final MemoryMap mmu;
    public final String name;
    public final String address;
    private final List<DeviceTreeProperty> properties = new ArrayList<DeviceTreeProperty>();
    public final List<DeviceTreeImpl> children = new ArrayList<DeviceTreeImpl>();

    public DeviceTreeImpl(@Nullable DeviceTreeImpl parent, MemoryMap mmu, String name, String address) {
        this.parent = parent;
        this.root = parent != null ? parent.root : this;
        this.phandles = parent != null ? parent.phandles : new Object2IntArrayMap();
        this.mmu = mmu;
        this.name = name == null ? "" : DeviceTreeImpl.validateName(name);
        this.address = address;
    }

    public DeviceTreeImpl(MemoryMap mmu) {
        this(null, mmu, null, null);
    }

    @Override
    public FlattenedDeviceTree flatten() {
        FlattenedDeviceTree fdt = new FlattenedDeviceTree();
        this.flatten(fdt);
        return fdt;
    }

    @Override
    public int getPHandle(Device device) {
        return this.phandles.computeIfAbsent(device.getIdentity(), d -> this.phandles.size() + 1);
    }

    @Override
    public DeviceTree find(String path) {
        if (path.isEmpty()) {
            return this;
        }
        int splitIndex = path.indexOf(47);
        if (splitIndex == 0) {
            return this.root.find(path.substring(1));
        }
        if (splitIndex > 0) {
            String childName = path.substring(0, splitIndex);
            String pathTail = path.substring(splitIndex + 1);
            return this.getChild(childName).find(pathTail);
        }
        return this.getChild(path);
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return this.fullName();
        }
        return this.parent.getPath() + "/" + this.fullName();
    }

    @Override
    public DeviceTree addProp(String name, Object ... values) {
        this.properties.add(new DeviceTreeProperty(name, values));
        return this;
    }

    @Override
    public DeviceTree putChild(String name, String address, Consumer<DeviceTree> builder) {
        builder.accept(this.getChild(name, address));
        return this;
    }

    @Override
    public DeviceTree getChild(String name, @Nullable String address) {
        String fullName = DeviceTreeImpl.fullName(name, address);
        for (DeviceTreeImpl child : this.children) {
            if (!fullName.equals(child.fullName())) continue;
            return child;
        }
        DeviceTreeImpl child = new DeviceTreeImpl(this, this.mmu, name, address);
        this.children.add(child);
        return child;
    }

    private void flatten(FlattenedDeviceTree fdt) {
        if (this.address == null) {
            fdt.beginNode(this.name);
        } else {
            fdt.beginNode(this.name + "@" + this.address);
        }
        for (DeviceTreeProperty property : this.properties) {
            property.flatten(fdt);
        }
        for (DeviceTreeImpl child : this.children) {
            child.flatten(fdt);
        }
        fdt.endNode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    private void toString(StringBuilder sb, int indent) {
        DeviceTreeImpl.appendIndent(sb, indent).append(this.name);
        if (this.address != null) {
            sb.append('@').append(this.address);
        }
        sb.append(" {\n");
        for (DeviceTreeProperty property : this.properties) {
            DeviceTreeImpl.appendIndent(sb, indent + 1).append(property.toString()).append('\n');
        }
        for (DeviceTreeImpl child : this.children) {
            child.toString(sb, indent + 1);
        }
        DeviceTreeImpl.appendIndent(sb, indent).append("}\n");
    }

    private static StringBuilder appendIndent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent * 4; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private String fullName() {
        return DeviceTreeImpl.fullName(this.name, this.address);
    }

    private static String fullName(String name, @Nullable String address) {
        return address != null ? String.format("%s@%s", name, address) : name;
    }

    private static String validateName(String value) {
        if (value.length() < 1) {
            throw new IllegalArgumentException("name too short (<1)");
        }
        if (value.length() > 31) {
            throw new IllegalArgumentException("name too long (>31)");
        }
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (DeviceTreeImpl.isValidCharacterForNodeName(ch)) continue;
            throw new IllegalArgumentException("invalid character [" + ch + "] in name [" + value + "]");
        }
        return value;
    }

    private static boolean isValidCharacterForNodeName(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 44 || ch == 46 || ch == 95 || ch == 43 || ch == 45;
    }
}

