/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree;

import li.cil.sedna.devicetree.FlattenedDeviceTree;

public final class DeviceTreeProperty {
    private final String name;
    private final Object[] values;

    public DeviceTreeProperty(String name, Object ... values) {
        this.name = DeviceTreeProperty.validateName(name);
        this.values = values;
        for (Object value : values) {
            if (value instanceof String || value instanceof Integer || value instanceof Long) continue;
            throw new IllegalArgumentException();
        }
    }

    public void flatten(FlattenedDeviceTree fdt) {
        fdt.property(this.name, this.values);
    }

    public String toString() {
        if (this.values == null || this.values.length == 0) {
            return this.name + ";";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" = ");
        boolean isFirst = true;
        boolean previousWasNumber = false;
        for (Object current : this.values) {
            boolean currentIsNumber = current instanceof Number;
            if (previousWasNumber && !currentIsNumber) {
                sb.append('>');
            }
            if (!isFirst) {
                if (!previousWasNumber || !currentIsNumber) {
                    sb.append(", ");
                } else {
                    sb.append(" ");
                }
            }
            if (currentIsNumber && !previousWasNumber) {
                sb.append('<');
            }
            isFirst = false;
            if (current instanceof String) {
                sb.append('\"').append((String)current).append('\"');
            } else if (current instanceof Integer) {
                sb.append("0x").append(Integer.toUnsignedString((Integer)current, 16));
            } else if (current instanceof Long) {
                sb.append("0x").append(Integer.toUnsignedString((int)((Long)current >>> 32), 16));
                sb.append(" ");
                sb.append("0x").append(Integer.toUnsignedString((int)((Long)current).longValue(), 16));
            } else {
                throw new AssertionError();
            }
            previousWasNumber = currentIsNumber;
        }
        if (previousWasNumber) {
            sb.append('>');
        }
        sb.append(";");
        return sb.toString();
    }

    private static String validateName(String value) {
        if (value.length() < 1) {
            throw new IllegalArgumentException("name too short (<1)");
        }
        if (value.length() > 31) {
            throw new IllegalArgumentException("name too long (>31)");
        }
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (DeviceTreeProperty.isValidCharacterForPropertyName(ch)) continue;
            throw new IllegalArgumentException("invalid character [" + ch + "] in name [" + value + "]");
        }
        return value;
    }

    private static boolean isValidCharacterForPropertyName(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 44 || ch == 46 || ch == 95 || ch == 43 || ch == 45 || ch == 63 || ch == 35;
    }
}

