/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree.provider;

import java.util.Optional;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryMap;

public final class FlashMemoryProvider
implements DeviceTreeProvider {
    @Override
    public Optional<String> getName(Device device) {
        return Optional.of("flash");
    }

    @Override
    public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
        Optional<MappedMemoryRange> range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        return range.map(r -> root.find("/soc").getChild(deviceName, r.address()));
    }

    @Override
    public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
        node.addProp("compatible", "cfi-flash").addProp("bank-width", 4);
    }
}

