/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.fs;

import java.util.ArrayList;
import java.util.List;

public final class Path {
    private final ArrayList<String> parts = new ArrayList();

    public Path() {
    }

    public Path(List<String> parts) {
        this.parts.addAll(parts);
    }

    public Path(List<String> parts, String part) {
        this.parts.addAll(parts);
        this.parts.add(part);
    }

    public Path resolve(String part) {
        if (part.equals(".")) {
            return new Path(this.parts);
        }
        if (!part.equals("..")) {
            return new Path(this.parts, part);
        }
        if (!this.parts.isEmpty()) {
            Path result = new Path(this.parts);
            result.parts.remove(result.parts.size() - 1);
            return result;
        }
        return this;
    }

    public String[] getParts() {
        return this.parts.toArray(new String[0]);
    }

    public String toString() {
        return this.toString("/");
    }

    public String toString(String pathSeparator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            if (i > 0) {
                sb.append(pathSeparator);
            }
            sb.append(this.parts.get(i));
        }
        return sb.toString();
    }
}

