/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.gdbstub;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;

public final class GDBPacketOutputStream
extends FilterOutputStream {
    private byte checksum = 0;
    private boolean closed = false;

    public GDBPacketOutputStream(OutputStream out) throws IOException {
        super(out);
        out.write(36);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        super.write(b);
        this.checksum = (byte)(this.checksum + b);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.out.write(35);
        this.out.write(HexFormat.of().toHexDigits(this.checksum).getBytes(StandardCharsets.US_ASCII));
        super.flush();
    }
}

