/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.gdbstub;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import li.cil.sedna.gdbstub.CPUDebugInterface;
import li.cil.sedna.gdbstub.GDBPacketOutputStream;
import li.cil.sedna.riscv.exception.R5MemoryAccessException;
import li.cil.sedna.utils.ByteBufferUtils;
import li.cil.sedna.utils.HexUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GDBStub {
    private static final Logger LOGGER = LogManager.getLogger();
    private GDBState state = GDBState.DISCONNECTED;
    private InputStream input;
    private OutputStream output;
    private final ServerSocketChannel listeningSock;
    private SocketChannel sock;
    private final CPUDebugInterface cpu;

    public GDBStub(ServerSocketChannel socket, CPUDebugInterface cpu) {
        this.listeningSock = socket;
        this.cpu = cpu;
        this.cpu.addBreakpointListener(this::handleBreakpointHit);
    }

    public static GDBStub createDefault(CPUDebugInterface cpu, int port) throws IOException {
        ServerSocketChannel chan = ServerSocketChannel.open();
        chan.configureBlocking(false);
        chan.bind(new InetSocketAddress(port));
        return new GDBStub(chan, cpu);
    }

    public void run(boolean waitForMessage) {
        if (this.isMessageAvailable() || waitForMessage) {
            this.runLoop(StopReason.MESSAGE);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void runLoop(StopReason reason) {
        packetBuffer = ByteBuffer.allocate(8192);
        block70: while (true) {
            switch (1.$SwitchMap$li$cil$sedna$gdbstub$GDBStub$GDBState[this.state.ordinal()]) {
                case 1: {
                    try {
                        this.listeningSock.configureBlocking(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.tryConnect();
                    ** GOTO lbl136
                }
                case 2: {
                    try {
                        s = new GDBPacketOutputStream(this.output);
                        try {
                            w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);
                            try {
                                w.write("S05");
                                this.state = GDBState.WAITING_FOR_COMMAND;
                                ** GOTO lbl136
                            }
                            finally {
                                w.close();
                            }
                        }
                        finally {
                            s.close();
                        }
                    }
                    catch (IOException e) {
                        this.disconnect();
                    }
                    ** GOTO lbl136
                }
                case 3: {
                    try {
                        packetBuffer.clear();
                        if (this.receivePacket(packetBuffer)) ** GOTO lbl39
                        this.disconnect();
                        ** GOTO lbl136
lbl39:
                        // 1 sources

                        if (packetBuffer.limit() == 0) continue block70;
                        GDBStub.LOGGER.debug("Packet: {}\n", (Object)this.asciiBytesToEscaped(packetBuffer.slice()));
                        command = packetBuffer.get();
                        block24 : switch (command) {
                            case 63: {
                                s = new GDBPacketOutputStream(this.output);
                                try {
                                    w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);
                                    try {
                                        w.write("S05");
                                        break;
                                    }
                                    finally {
                                        w.close();
                                    }
                                }
                                finally {
                                    s.close();
                                }
                            }
                            case 113: {
                                Supported = "Supported:".getBytes(StandardCharsets.US_ASCII);
                                Attached = "Attached".getBytes(StandardCharsets.US_ASCII);
                                if (ByteBufferUtils.startsWith(packetBuffer, ByteBuffer.wrap(Supported))) {
                                    packetBuffer.position(packetBuffer.position() + Supported.length);
                                    this.handleSupported(packetBuffer);
                                    break;
                                }
                                if (!ByteBufferUtils.startsWith(packetBuffer, ByteBuffer.wrap(Attached))) ** GOTO lbl77
                                s = new GDBPacketOutputStream(this.output);
                                try {
                                    w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);
                                    try {
                                        w.write("1");
                                        break;
                                    }
                                    finally {
                                        w.close();
                                    }
                                }
                                finally {
                                    s.close();
                                }
lbl77:
                                // 1 sources

                                this.unknownCommand(packetBuffer);
                                break;
                            }
                            case 103: {
                                this.readGeneralRegisters();
                                break;
                            }
                            case 71: {
                                this.writeGeneralRegisters(packetBuffer);
                                break;
                            }
                            case 109: {
                                this.handleReadMemory(packetBuffer);
                                break;
                            }
                            case 77: {
                                this.handleWriteMemory(packetBuffer);
                                break;
                            }
                            case 90: {
                                type = packetBuffer.get();
                                switch (type) {
                                    case 48: 
                                    case 49: {
                                        this.handleBreakpointAdd(packetBuffer);
                                        break block24;
                                    }
                                }
                                this.unknownCommand(packetBuffer);
                                break;
                            }
                            case 122: {
                                type = packetBuffer.get();
                                switch (type) {
                                    case 48: 
                                    case 49: {
                                        this.handleBreakpointRemove(packetBuffer);
                                        break block24;
                                    }
                                }
                                this.unknownCommand(packetBuffer);
                                break;
                            }
                            case 99: {
                                this.state = GDBState.STOP_REPLY;
                                break block70;
                            }
                            case 115: {
                                if (packetBuffer.hasRemaining()) {
                                    this.unknownCommand(packetBuffer);
                                    return;
                                }
                                this.handleStep();
                                break;
                            }
                            case 68: {
                                s = new GDBPacketOutputStream(this.output);
                                try {
                                    w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);
                                    try {
                                        w.write("OK");
                                    }
                                    finally {
                                        w.close();
                                    }
                                }
                                finally {
                                    s.close();
                                }
                                this.disconnect();
                                break block70;
                            }
                            default: {
                                this.unknownCommand(packetBuffer);
                            }
                        }
                    }
                    catch (IOException e) {
                        this.disconnect();
                    }
                }
lbl136:
                // 9 sources

                default: {
                    continue block70;
                }
            }
            break;
        }
    }

    private boolean tryConnect() {
        try {
            SocketChannel sock = this.listeningSock.accept();
            if (sock == null) {
                return false;
            }
            this.sock = sock;
        }
        catch (IOException e) {
            return false;
        }
        try {
            this.input = new BufferedInputStream(this.sock.socket().getInputStream());
            this.output = new BufferedOutputStream(this.sock.socket().getOutputStream());
            this.state = GDBState.WAITING_FOR_COMMAND;
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return false;
        }
    }

    private void disconnect() {
        try {
            LOGGER.info("GDB disconnected");
            this.state = GDBState.DISCONNECTED;
            this.sock.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.input = null;
            this.output = null;
            this.sock = null;
        }
    }

    private boolean isMessageAvailable() {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case GDBState.DISCONNECTED -> {
                boolean var1_1;
                yield var1_1 = this.tryConnect();
            }
            case GDBState.STOP_REPLY, GDBState.WAITING_FOR_COMMAND -> {
                try {
                    boolean var1_2;
                    yield var1_2 = this.input.available() > 0;
                }
                catch (IOException e) {
                    boolean var1_3;
                    this.disconnect();
                    yield var1_3 = false;
                }
            }
        };
    }

    private boolean receivePacket(ByteBuffer buffer) {
        try {
            while (true) {
                byte d;
                int c;
                byte actualChecksum = 0;
                while ((c = this.input.read()) != 36) {
                    if (c != -1) continue;
                    return false;
                }
                while ((c = this.input.read()) != 35) {
                    if (c == -1) {
                        return false;
                    }
                    buffer.put((byte)c);
                    actualChecksum = (byte)(actualChecksum + (byte)c);
                }
                int c2 = this.input.read();
                if (c2 == -1 || (d = (byte)HexFormat.fromHexDigit(c2)) == -1) {
                    return false;
                }
                byte expectedChecksum = (byte)(d << 4);
                c2 = this.input.read();
                if (c2 == -1 || (d = (byte)HexFormat.fromHexDigit(c2)) == -1) {
                    return false;
                }
                if (actualChecksum == (expectedChecksum = (byte)(expectedChecksum | d))) break;
                this.output.write(45);
                this.output.flush();
            }
            this.output.write(43);
            this.output.flush();
            buffer.flip();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void handleBreakpointHit(long address) {
        this.runLoop(StopReason.BREAKPOINT);
    }

    private void handleSupported(ByteBuffer packet) throws IOException {
        try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);){
            w.write("PacketSize=2000");
        }
    }

    private void handleReadMemory(ByteBuffer buffer) throws IOException {
        String command = StandardCharsets.US_ASCII.decode(buffer).toString();
        int addressEnd = command.indexOf(44);
        long address = Long.parseUnsignedLong(command, 0, addressEnd, 16);
        int length = Integer.parseInt(command, addressEnd + 1, command.length(), 16);
        try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
             BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII));){
            try {
                byte[] mem = this.cpu.loadDebug(address, length);
                HexFormat.of().formatHex(w, mem);
            }
            catch (R5MemoryAccessException e) {
                w.write("E14");
            }
        }
    }

    private void handleWriteMemory(ByteBuffer buffer) throws IOException {
        block16: {
            String command = StandardCharsets.US_ASCII.decode(buffer).toString();
            int addressEnd = command.indexOf(44);
            int lengthEnd = command.indexOf(58, addressEnd + 1);
            long address = Long.parseUnsignedLong(command, 0, addressEnd, 16);
            int length = Integer.parseInt(command, addressEnd + 1, lengthEnd, 16);
            int actualLength = (command.length() - (lengthEnd + 1)) / 2;
            try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
                 OutputStreamWriter w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);){
                if (length != actualLength) {
                    w.write("E22");
                    return;
                }
                byte[] mem = HexFormat.of().parseHex(command, lengthEnd + 1, command.length());
                try {
                    int wrote = this.cpu.storeDebug(address, mem);
                    if (wrote < length) {
                        w.write("E14");
                        break block16;
                    }
                    w.write("OK");
                }
                catch (R5MemoryAccessException e) {
                    w.write("E14");
                }
            }
        }
    }

    private void handleBreakpointAdd(ByteBuffer buffer) throws IOException {
        buffer.get();
        CharBuffer chars = StandardCharsets.US_ASCII.decode(buffer);
        long address = HexUtils.getLong(chars);
        try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);){
            this.cpu.addBreakpoint(address);
            w.write("OK");
        }
    }

    private void handleBreakpointRemove(ByteBuffer buffer) throws IOException {
        buffer.get();
        CharBuffer chars = StandardCharsets.US_ASCII.decode(buffer);
        long address = HexUtils.getLong(chars);
        try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);){
            this.cpu.removeBreakpoint(address);
            w.write("OK");
        }
    }

    private void handleStep() {
        this.cpu.step();
        this.state = GDBState.STOP_REPLY;
    }

    private String asciiBytesToEscaped(ByteBuffer bytes) {
        StringBuilder sb = new StringBuilder(bytes.remaining());
        while (bytes.hasRemaining()) {
            byte b = bytes.get();
            if (b >= 32 && b <= 126) {
                sb.append((char)b);
                continue;
            }
            sb.append("\\x");
            HexFormat.of().toHexDigits(sb, b);
        }
        return sb.toString();
    }

    private void unknownCommand(ByteBuffer packet) throws IOException {
        LOGGER.debug("Unknown command: {}\n", (Object)this.asciiBytesToEscaped(packet.position(0)));
        new GDBPacketOutputStream(this.output).close();
    }

    private void readGeneralRegisters() throws IOException {
        try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
             BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII));){
            for (long l : this.cpu.getGeneralRegisters()) {
                HexUtils.putLong(w, l);
            }
            HexUtils.putLong(w, this.cpu.getProgramCounter());
        }
    }

    private void writeGeneralRegisters(ByteBuffer buf) throws IOException {
        String regs = StandardCharsets.US_ASCII.decode(buf).toString();
        ByteBuffer regsRaw = ByteBuffer.wrap(HexFormat.of().parseHex(regs)).order(ByteOrder.LITTLE_ENDIAN);
        long[] xr = this.cpu.getGeneralRegisters();
        for (int i = 0; i < xr.length; ++i) {
            xr[i] = regsRaw.getLong();
        }
        this.cpu.setProgramCounter(regsRaw.getLong());
        try (GDBPacketOutputStream s = new GDBPacketOutputStream(this.output);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)s, StandardCharsets.US_ASCII);){
            w.write("OK");
        }
    }

    private static enum GDBState {
        DISCONNECTED,
        WAITING_FOR_COMMAND,
        STOP_REPLY;

    }

    private static enum StopReason {
        MESSAGE,
        BREAKPOINT;

    }
}

