/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.argument;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import li.cil.sedna.instruction.FieldPostprocessor;
import li.cil.sedna.instruction.InstructionFieldMapping;
import li.cil.sedna.instruction.argument.InstructionArgument;
import li.cil.sedna.utils.BitUtils;

public final class FieldInstructionArgument
implements InstructionArgument {
    public final ArrayList<InstructionFieldMapping> mappings;
    public final FieldPostprocessor postprocessor;

    public FieldInstructionArgument(ArrayList<InstructionFieldMapping> mappings, FieldPostprocessor postprocessor) {
        this.mappings = mappings;
        this.postprocessor = postprocessor;
        Collections.sort(mappings);
    }

    @Override
    public int get(int instruction) {
        int value = 0;
        for (InstructionFieldMapping mapping : this.mappings) {
            int part = BitUtils.getField(instruction, mapping.srcLSB, mapping.srcMSB, mapping.dstLSB);
            if (mapping.signExtend) {
                part = BitUtils.extendSign(part, mapping.dstLSB + (mapping.srcMSB - mapping.srcLSB) + 1);
            }
            value |= part;
        }
        value = this.postprocessor.apply(value);
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInstructionArgument that = (FieldInstructionArgument)o;
        return this.mappings.equals(that.mappings) && this.postprocessor == that.postprocessor;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mappings, this.postprocessor});
    }
}

