/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.decoder;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.InstructionDefinition;
import li.cil.sedna.instruction.InstructionFieldMapping;
import li.cil.sedna.instruction.InstructionType;
import li.cil.sedna.instruction.argument.ConstantInstructionArgument;
import li.cil.sedna.instruction.argument.FieldInstructionArgument;
import li.cil.sedna.instruction.argument.InstructionArgument;
import li.cil.sedna.instruction.argument.ProgramCounterInstructionArgument;
import li.cil.sedna.instruction.decoder.DecoderTreeBranchVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeLeafVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeNodeArguments;
import li.cil.sedna.instruction.decoder.DecoderTreeSwitchVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeVisitor;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeBranchNode;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeSwitchNode;
import li.cil.sedna.utils.BitUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class DecoderGenerator
extends ClassVisitor
implements Opcodes {
    private final AbstractDecoderTreeNode decoderTree;
    private final Function<InstructionDeclaration, InstructionDefinition> definitionProvider;
    private final String decoderMethod;
    private final String decoderHook;
    private final String illegalInstructionInternalName;
    private String hostClassInternalName;
    private int instructionGroupMethodIndex;

    public DecoderGenerator(ClassVisitor cv, AbstractDecoderTreeNode decoderTree, Function<InstructionDeclaration, InstructionDefinition> definitionProvider, Class<?> illegalInstructionExceptionClass, String decoderMethod, String decoderHook) {
        super(458752, cv);
        this.decoderTree = decoderTree;
        this.definitionProvider = definitionProvider;
        this.decoderMethod = decoderMethod;
        this.decoderHook = decoderHook;
        this.illegalInstructionInternalName = Type.getInternalName(illegalInstructionExceptionClass);
    }

    protected void emitInstruction(GeneratorContext context, InstructionDeclaration declaration, InstructionDefinition definition) {
        block20: {
            block21: {
                block19: {
                    context.methodVisitor.visitVarInsn(25, 0);
                    StringBuilder methodDescriptor = new StringBuilder("(");
                    for (InstructionArgument argument : definition.parameters) {
                        if (argument instanceof ConstantInstructionArgument) {
                            ConstantInstructionArgument constantArgument = (ConstantInstructionArgument)argument;
                            context.emitFastLdc(constantArgument.value);
                            methodDescriptor.append('I');
                            continue;
                        }
                        if (argument instanceof ProgramCounterInstructionArgument) {
                            context.methodVisitor.visitVarInsn(22, context.localPc);
                            methodDescriptor.append('J');
                            continue;
                        }
                        if (argument instanceof FieldInstructionArgument) {
                            FieldInstructionArgument fieldArgument = (FieldInstructionArgument)argument;
                            if (context.localVariables.containsKey((Object)fieldArgument)) {
                                int localIndex = context.localVariables.getInt((Object)fieldArgument);
                                context.methodVisitor.visitVarInsn(21, localIndex);
                            } else {
                                context.emitGetField(fieldArgument);
                            }
                            methodDescriptor.append('I');
                            continue;
                        }
                        throw new IllegalArgumentException();
                    }
                    methodDescriptor.append(')');
                    if (definition.returnsBoolean) {
                        methodDescriptor.append('Z');
                    } else {
                        methodDescriptor.append('V');
                    }
                    context.methodVisitor.visitMethodInsn(183, this.hostClassInternalName, definition.methodName, methodDescriptor.toString(), false);
                    if (!definition.returnsBoolean) break block19;
                    Label updateOffsetAndContinueLabel = new Label();
                    context.methodVisitor.visitJumpInsn(153, updateOffsetAndContinueLabel);
                    switch (context.type) {
                        case TOP_LEVEL: {
                            if (!definition.writesPC) {
                                context.emitIncrementPC(declaration.size);
                                context.emitSavePC();
                            }
                            context.methodVisitor.visitInsn(177);
                            break;
                        }
                        case CONDITIONAL_METHOD: {
                            if (!definition.writesPC) {
                                context.methodVisitor.visitInsn(4);
                            } else {
                                context.methodVisitor.visitInsn(5);
                            }
                            context.methodVisitor.visitInsn(172);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    context.methodVisitor.visitLabel(updateOffsetAndContinueLabel);
                    context.emitIncrementPC(declaration.size);
                    context.emitContinue();
                    break block20;
                }
                if (!definition.writesPC) break block21;
                switch (context.type) {
                    case TOP_LEVEL: {
                        context.emitJumpHandler();
                        break block20;
                    }
                    case CONDITIONAL_METHOD: {
                        context.methodVisitor.visitInsn(6);
                        context.methodVisitor.visitInsn(172);
                        break block20;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            context.emitIncrementPC(declaration.size);
            context.emitContinue();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.hostClassInternalName = name;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.decoderMethod.equals(name)) {
            return new TemplateMethodVisitor(super.visitMethod(access, name, descriptor, signature, exceptions), this.cv);
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    protected final class GeneratorContext
    implements Opcodes {
        public static final int LOCAL_THIS = 0;
        public static final int LOCAL_INST = 2;
        public static final int LOCAL_PC = 3;
        public static final int LOCAL_INST_OFFSET = 5;
        public static final int LOCAL_FIRST_FIELD = 8;
        public static final int LOCAL_GEN_INST = 1;
        public static final int LOCAL_GEN_PC = 2;
        public static final int LOCAL_GEN_FIRST_FIELD = 4;
        public static final int RETURN_CONTINUE = 0;
        public static final int RETURN_EXIT_INC_PC = 1;
        public static final int RETURN_EXIT = 2;
        public static final int RETURN_JUMP = 3;
        public final ClassVisitor classVisitor;
        public final MethodVisitor methodVisitor;
        public final ContextType type;
        public final int processedMask;
        public final int localInst;
        public final int localPc;
        public final int localFirstField;
        public final Label continueLabel;
        public final Label illegalInstructionLabel;
        public final Object2IntArrayMap<FieldInstructionArgument> localVariables;

        private GeneratorContext(ClassVisitor classVisitor, MethodVisitor methodVisitor) {
            this(classVisitor, methodVisitor, ContextType.TOP_LEVEL, 0, 2, 3, 8, new Label(), new Label(), (Object2IntArrayMap<FieldInstructionArgument>)new Object2IntArrayMap());
        }

        private GeneratorContext(ClassVisitor classVisitor, MethodVisitor methodVisitor, ContextType type, int processedMask, Object2IntArrayMap<FieldInstructionArgument> localVariables) {
            this(classVisitor, methodVisitor, type, processedMask, 1, 2, 4 + localVariables.size(), new Label(), new Label(), localVariables);
        }

        private GeneratorContext(ClassVisitor classVisitor, MethodVisitor methodVisitor, ContextType type, int processedMask, int localInst, int localPc, int localFirstField, Label continueLabel, Label illegalInstructionLabel, Object2IntArrayMap<FieldInstructionArgument> localVariables) {
            this.classVisitor = classVisitor;
            this.methodVisitor = methodVisitor;
            this.type = type;
            this.processedMask = processedMask;
            this.localInst = localInst;
            this.localPc = localPc;
            this.localFirstField = localFirstField;
            this.continueLabel = continueLabel;
            this.illegalInstructionLabel = illegalInstructionLabel;
            this.localVariables = localVariables;
        }

        public GeneratorContext withProcessed(int mask) {
            return new GeneratorContext(this.classVisitor, this.methodVisitor, this.type, this.processedMask | mask, this.localInst, this.localPc, this.localFirstField, this.continueLabel, this.illegalInstructionLabel, this.localVariables);
        }

        private void emitFastLdc(int value) {
            if (value >= 0 && value <= 5) {
                this.methodVisitor.visitInsn(3 + value);
            } else {
                this.methodVisitor.visitLdcInsn((Object)value);
            }
        }

        public void emitContinue() {
            switch (this.type) {
                case TOP_LEVEL: {
                    this.methodVisitor.visitJumpInsn(167, this.continueLabel);
                    break;
                }
                case VOID_METHOD: {
                    this.methodVisitor.visitInsn(177);
                    break;
                }
                case CONDITIONAL_METHOD: {
                    this.methodVisitor.visitInsn(3);
                    this.methodVisitor.visitInsn(172);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void emitThrowIllegalInstruction() {
            this.methodVisitor.visitJumpInsn(167, this.illegalInstructionLabel);
        }

        public void emitIncrementPC(int value) {
            if (this.type == ContextType.TOP_LEVEL) {
                this.methodVisitor.visitVarInsn(22, 3);
                this.methodVisitor.visitLdcInsn((Object)value);
                this.methodVisitor.visitInsn(97);
                this.methodVisitor.visitVarInsn(55, 3);
                this.methodVisitor.visitIincInsn(5, value);
            }
        }

        public void emitSavePC() {
            assert (this.type == ContextType.TOP_LEVEL);
            this.methodVisitor.visitVarInsn(25, 0);
            this.methodVisitor.visitVarInsn(22, 3);
            this.methodVisitor.visitFieldInsn(181, DecoderGenerator.this.hostClassInternalName, "pc", "J");
        }

        public void emitGetField(FieldInstructionArgument argument) {
            this.methodVisitor.visitInsn(3);
            for (InstructionFieldMapping mapping : argument.mappings) {
                this.methodVisitor.visitVarInsn(21, this.localInst);
                if (mapping.dstLSB >= mapping.srcLSB) {
                    shiftAmount = mapping.dstLSB - mapping.srcLSB;
                    this.emitFastLdc(shiftAmount);
                    this.methodVisitor.visitInsn(120);
                } else {
                    shiftAmount = mapping.srcLSB - mapping.dstLSB;
                    this.emitFastLdc(shiftAmount);
                    this.methodVisitor.visitInsn(124);
                }
                int mask = (1 << mapping.srcMSB - mapping.srcLSB + 1) - 1 << mapping.dstLSB;
                this.emitFastLdc(mask);
                this.methodVisitor.visitInsn(126);
                if (mapping.signExtend) {
                    this.emitFastLdc(mapping.dstLSB + (mapping.srcMSB - mapping.srcLSB) + 1);
                    this.methodVisitor.visitMethodInsn(184, Type.getInternalName(BitUtils.class), "extendSign", "(II)I", false);
                }
                this.methodVisitor.visitInsn(128);
            }
            switch (argument.postprocessor) {
                case NONE: {
                    break;
                }
                case ADD_8: {
                    this.emitFastLdc(8);
                    this.methodVisitor.visitInsn(96);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void emitJumpHandler() {
            this.methodVisitor.visitVarInsn(22, this.localPc);
            this.methodVisitor.visitVarInsn(25, 0);
            this.methodVisitor.visitFieldInsn(180, DecoderGenerator.this.hostClassInternalName, "pc", "J");
            this.methodVisitor.visitMethodInsn(184, Type.getInternalName(Long.class), "compareUnsigned", "(JJ)I", false);
            Label forwardJumpLabel = new Label();
            this.methodVisitor.visitJumpInsn(155, forwardJumpLabel);
            this.methodVisitor.visitInsn(177);
            this.methodVisitor.visitLabel(forwardJumpLabel);
            this.methodVisitor.visitVarInsn(22, this.localPc);
            this.methodVisitor.visitVarInsn(25, 0);
            this.methodVisitor.visitFieldInsn(180, DecoderGenerator.this.hostClassInternalName, "pc", "J");
            this.methodVisitor.visitInsn(92);
            this.methodVisitor.visitVarInsn(55, this.localPc);
            this.methodVisitor.visitInsn(101);
            this.methodVisitor.visitInsn(117);
            this.methodVisitor.visitInsn(92);
            this.methodVisitor.visitInsn(92);
            this.methodVisitor.visitInsn(136);
            this.methodVisitor.visitInsn(133);
            this.methodVisitor.visitInsn(101);
            this.methodVisitor.visitInsn(9);
            this.methodVisitor.visitInsn(148);
            Label notOutOfBoundsLabel = new Label();
            this.methodVisitor.visitJumpInsn(153, notOutOfBoundsLabel);
            this.methodVisitor.visitInsn(177);
            this.methodVisitor.visitLabel(notOutOfBoundsLabel);
            this.methodVisitor.visitInsn(136);
            this.methodVisitor.visitVarInsn(21, 5);
            this.methodVisitor.visitInsn(96);
            this.methodVisitor.visitVarInsn(54, 5);
            this.methodVisitor.visitJumpInsn(167, this.continueLabel);
        }
    }

    protected static enum ContextType {
        TOP_LEVEL,
        VOID_METHOD,
        CONDITIONAL_METHOD;

    }

    private final class TemplateMethodVisitor
    extends MethodVisitor
    implements Opcodes {
        private final ClassVisitor classVisitor;

        public TemplateMethodVisitor(MethodVisitor methodVisitor, ClassVisitor classVisitor) {
            super(458752, methodVisitor);
            this.classVisitor = classVisitor;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (!DecoderGenerator.this.decoderHook.equals(name)) {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                return;
            }
            DecoderGenerator.this.decoderTree.accept(new DecoderTreeRootNodeVisitor(new GeneratorContext(this.classVisitor, this.mv)));
        }
    }

    private record MaskField(int srcMSB, int srcLSB) {
        public static ArrayList<MaskField> create(int mask) {
            ArrayList<MaskField> maskFields = new ArrayList<MaskField>();
            int offset = 0;
            while (mask != 0) {
                int lsb = Integer.numberOfTrailingZeros(mask);
                mask >>>= lsb;
                int msb = lsb - 1;
                while ((mask & 1) != 0) {
                    ++msb;
                    mask >>>= 1;
                }
                maskFields.add(new MaskField(msb + offset, lsb + offset));
                offset += msb + 1;
            }
            return maskFields;
        }

        public int asMask() {
            return (int)BitUtils.maskFromRange(this.srcLSB, this.srcMSB);
        }
    }

    private record PatternAndLabel(int pattern, Label label) implements Comparable<PatternAndLabel>
    {
        @Override
        public int compareTo(PatternAndLabel o) {
            return Integer.compare(this.pattern, o.pattern);
        }
    }

    private static abstract class LocalVariableOwner
    implements Opcodes {
        private static final float THRESHOLD = 0.99f;
        private final HashMap<FieldInstructionArgument, String> ownedLocals = new HashMap();
        private final Label beginVariableScopeLabel = new Label();
        protected final GeneratorContext context;

        protected LocalVariableOwner(GeneratorContext context) {
            this.context = context;
        }

        protected void pushLocalVariables(DecoderTreeNodeArguments arguments) {
            int threshold = Math.max(2, (int)((float)arguments.totalLeafCount * 0.99f));
            arguments.arguments.forEach((argument, entry) -> {
                if (entry.count >= threshold && !this.context.localVariables.containsKey(argument)) {
                    this.ownedLocals.put((FieldInstructionArgument)argument, String.join((CharSequence)"_", entry.names));
                }
            });
            if (this.ownedLocals.isEmpty()) {
                return;
            }
            for (FieldInstructionArgument argument2 : this.ownedLocals.keySet()) {
                int localIndex = this.context.localFirstField + this.context.localVariables.size();
                this.context.localVariables.put((Object)argument2, localIndex);
                this.context.emitGetField(argument2);
                this.context.methodVisitor.visitVarInsn(54, localIndex);
            }
            this.context.methodVisitor.visitLabel(this.beginVariableScopeLabel);
        }

        protected void popVariables() {
            if (this.ownedLocals.isEmpty()) {
                return;
            }
            Label endVariableScopeLabel = new Label();
            this.context.methodVisitor.visitLabel(endVariableScopeLabel);
            for (Map.Entry<FieldInstructionArgument, String> entry : this.ownedLocals.entrySet()) {
                FieldInstructionArgument argument = entry.getKey();
                int localIndex = this.context.localVariables.removeInt((Object)argument);
                this.context.methodVisitor.visitLocalVariable(entry.getValue(), "I", null, this.beginVariableScopeLabel, endVariableScopeLabel, localIndex);
            }
        }
    }

    private final class LeafVisitor
    implements DecoderTreeLeafVisitor,
    Opcodes {
        private final GeneratorContext context;

        public LeafVisitor(GeneratorContext context) {
            this.context = context;
        }

        @Override
        public void visitInstruction(InstructionDeclaration declaration) {
            if (declaration.type == InstructionType.ILLEGAL) {
                this.context.emitThrowIllegalInstruction();
                return;
            }
            if (declaration.type == InstructionType.NOP) {
                this.context.emitIncrementPC(declaration.size);
                this.context.emitContinue();
                return;
            }
            InstructionDefinition definition = DecoderGenerator.this.definitionProvider.apply(declaration);
            if (definition == null) {
                this.context.emitThrowIllegalInstruction();
                return;
            }
            DecoderGenerator.this.emitInstruction(this.context, declaration, definition);
        }

        @Override
        public void visitEnd() {
        }
    }

    private final class BranchVisitor
    extends LocalVariableOwner
    implements DecoderTreeBranchVisitor {
        public BranchVisitor(GeneratorContext context) {
            super(context);
        }

        @Override
        public void visit(int count, DecoderTreeNodeArguments arguments) {
            this.pushLocalVariables(arguments);
        }

        @Override
        public DecoderTreeVisitor visitBranchCase(int index, int mask, int pattern) {
            int remainingMask = mask & ~this.context.processedMask;
            if (remainingMask != 0) {
                Label elseLabel = new Label();
                this.context.methodVisitor.visitVarInsn(21, this.context.localInst);
                this.context.emitFastLdc(remainingMask);
                this.context.methodVisitor.visitInsn(126);
                this.context.emitFastLdc(pattern & ~this.context.processedMask);
                this.context.methodVisitor.visitJumpInsn(160, elseLabel);
                return new InnerNodeVisitor(this.context.withProcessed(remainingMask), elseLabel);
            }
            return new InnerNodeVisitor(this.context.withProcessed(remainingMask), null);
        }

        @Override
        public void visitEnd() {
            this.context.emitThrowIllegalInstruction();
            this.popVariables();
        }
    }

    private final class SwitchVisitor
    extends LocalVariableOwner
    implements DecoderTreeSwitchVisitor {
        private final Label defaultCase;
        private Label[] cases;
        private int switchMask;

        public SwitchVisitor(GeneratorContext context) {
            super(context);
            this.defaultCase = new Label();
        }

        @Override
        public void visit(int mask, int[] patterns, DecoderTreeNodeArguments arguments) {
            int lookupTimeCost;
            int lookupSpaceCost;
            this.pushLocalVariables(arguments);
            int caseCount = patterns.length;
            this.cases = new Label[caseCount];
            for (int i = 0; i < caseCount; ++i) {
                this.cases[i] = new Label();
            }
            this.switchMask = mask & ~this.context.processedMask;
            int unprocessedMask = mask & ~this.context.processedMask;
            ArrayList<MaskField> maskFields = MaskField.create(unprocessedMask);
            ArrayList<MaskField> maskFieldsWithEqualPatterns = new ArrayList<MaskField>();
            for (int i = maskFields.size() - 1; i >= 0; --i) {
                int fieldMask = maskFields.get(i).asMask();
                int pattern = patterns[0] & fieldMask;
                boolean patternsMatch = true;
                for (int j = 1; j < caseCount; ++j) {
                    if ((patterns[j] & fieldMask) == pattern) continue;
                    patternsMatch = false;
                    break;
                }
                if (!patternsMatch) continue;
                maskFieldsWithEqualPatterns.add(maskFields.remove(i));
            }
            if (maskFields.isEmpty()) {
                throw new IllegalStateException(String.format("All cases in a switch node have the same patterns: [%s]", maskFieldsWithEqualPatterns.stream().map(f -> Integer.toBinaryString(patterns[0] & f.asMask())).collect(Collectors.joining(", "))));
            }
            if (!maskFieldsWithEqualPatterns.isEmpty()) {
                int commonMask = 0;
                for (MaskField maskField : maskFieldsWithEqualPatterns) {
                    commonMask |= maskField.asMask();
                }
                int commonPattern = patterns[0] & commonMask;
                Label switchLabel = new Label();
                this.context.methodVisitor.visitVarInsn(21, this.context.localInst);
                this.context.emitFastLdc(commonMask);
                this.context.methodVisitor.visitInsn(126);
                this.context.emitFastLdc(commonPattern);
                this.context.methodVisitor.visitJumpInsn(159, switchLabel);
                this.context.emitThrowIllegalInstruction();
                this.context.methodVisitor.visitLabel(switchLabel);
            }
            int[] tablePatterns = new int[caseCount];
            for (int i = 0; i < caseCount; ++i) {
                int tablePattern = 0;
                int offset = 0;
                for (MaskField maskField : maskFields) {
                    tablePattern |= (patterns[i] & maskField.asMask()) >>> maskField.srcLSB << offset;
                    offset += maskField.srcMSB - maskField.srcLSB + 1;
                }
                tablePatterns[i] = tablePattern;
            }
            Label[] tableLabels = this.sortPatternsAndGetRemappedLabels(tablePatterns);
            int tableMax = tablePatterns[tablePatterns.length - 1];
            int tableMin = tablePatterns[0];
            int tableSize = tableMax - tableMin + 1;
            int tableSpaceCost = 4 + tableSize;
            int tableTimeCost = 3;
            int tableInstructionMaskingCost = maskFields.size() == 1 && maskFields.get((int)0).srcLSB == 0 ? 0 : 1 + (maskFields.get((int)0).srcLSB == 0 ? 4 : 6) + (maskFields.size() - 1) * 8 - 3;
            if (tableInstructionMaskingCost + tableSpaceCost + 9 <= (lookupSpaceCost = 3 + 2 * tablePatterns.length) + 3 * (lookupTimeCost = tablePatterns.length)) {
                int i;
                Label[] labels = new Label[tableSize];
                int currentPattern = 0;
                for (i = 0; i < tableSize; ++i) {
                    if (tablePatterns[currentPattern] == tableMin + i) {
                        labels[i] = tableLabels[currentPattern];
                        ++currentPattern;
                        continue;
                    }
                    labels[i] = this.defaultCase;
                }
                if (maskFields.size() == 1 && maskFields.get((int)0).srcLSB == 0) {
                    for (i = 0; i < caseCount; ++i) {
                        assert ((patterns[i] & unprocessedMask) == (tablePatterns[i] & unprocessedMask));
                    }
                    this.context.methodVisitor.visitVarInsn(21, this.context.localInst);
                    this.context.emitFastLdc(unprocessedMask);
                    this.context.methodVisitor.visitInsn(126);
                } else {
                    this.context.methodVisitor.visitInsn(3);
                    int offset = 0;
                    for (MaskField maskField : maskFields) {
                        this.context.methodVisitor.visitVarInsn(21, this.context.localInst);
                        this.context.emitFastLdc(maskField.asMask());
                        this.context.methodVisitor.visitInsn(126);
                        if (maskField.srcLSB > 0) {
                            this.context.emitFastLdc(maskField.srcLSB);
                            this.context.methodVisitor.visitInsn(124);
                            if (offset > 0) {
                                this.context.emitFastLdc(offset);
                                this.context.methodVisitor.visitInsn(120);
                            }
                        }
                        this.context.methodVisitor.visitInsn(128);
                        offset += maskField.srcMSB - maskField.srcLSB + 1;
                    }
                }
                this.context.methodVisitor.visitTableSwitchInsn(tableMin, tableMax, this.defaultCase, labels);
            } else {
                int[] sortedPatterns = new int[caseCount];
                for (int i = 0; i < caseCount; ++i) {
                    sortedPatterns[i] = patterns[i] & mask;
                }
                Label[] labels = this.sortPatternsAndGetRemappedLabels(sortedPatterns);
                this.context.methodVisitor.visitVarInsn(21, this.context.localInst);
                this.context.emitFastLdc(mask);
                this.context.methodVisitor.visitInsn(126);
                this.context.methodVisitor.visitLookupSwitchInsn(this.defaultCase, sortedPatterns, labels);
            }
        }

        @Override
        public DecoderTreeVisitor visitSwitchCase(int index, int pattern) {
            this.context.methodVisitor.visitLabel(this.cases[index]);
            return new InnerNodeVisitor(this.context.withProcessed(this.switchMask), null);
        }

        @Override
        public void visitEnd() {
            this.context.methodVisitor.visitLabel(this.defaultCase);
            this.context.emitThrowIllegalInstruction();
            this.popVariables();
        }

        private Label[] sortPatternsAndGetRemappedLabels(int[] patterns) {
            int caseCount = patterns.length;
            Object[] compressedPatternsAndLabels = new PatternAndLabel[caseCount];
            for (int i = 0; i < caseCount; ++i) {
                compressedPatternsAndLabels[i] = new PatternAndLabel(patterns[i], this.cases[i]);
            }
            Arrays.sort(compressedPatternsAndLabels);
            Label[] labels = new Label[caseCount];
            for (int i = 0; i < caseCount; ++i) {
                patterns[i] = ((PatternAndLabel)compressedPatternsAndLabels[i]).pattern;
                labels[i] = ((PatternAndLabel)compressedPatternsAndLabels[i]).label;
            }
            return labels;
        }
    }

    private final class InnerNodeVisitor
    implements DecoderTreeVisitor,
    Opcodes {
        private final GeneratorContext context;
        private final Label endLabel;
        private GeneratorContext childContext;

        public InnerNodeVisitor(GeneratorContext context, Label endLabel) {
            this.context = context;
            this.endLabel = endLabel;
        }

        @Override
        public DecoderTreeSwitchVisitor visitSwitch(DecoderTreeSwitchNode node) {
            return new SwitchVisitor(this.generateMethodInvocation(node));
        }

        @Override
        public DecoderTreeBranchVisitor visitBranch(DecoderTreeBranchNode node) {
            return new BranchVisitor(this.generateMethodInvocation(node));
        }

        @Override
        public DecoderTreeLeafVisitor visitInstruction() {
            return new LeafVisitor(this.context);
        }

        @Override
        public void visitEnd() {
            if (this.childContext != null) {
                this.childContext.methodVisitor.visitLabel(this.childContext.illegalInstructionLabel);
                this.childContext.methodVisitor.visitTypeInsn(187, DecoderGenerator.this.illegalInstructionInternalName);
                this.childContext.methodVisitor.visitInsn(89);
                this.childContext.methodVisitor.visitMethodInsn(183, DecoderGenerator.this.illegalInstructionInternalName, "<init>", "()V", false);
                this.childContext.methodVisitor.visitInsn(191);
                switch (this.childContext.type) {
                    case VOID_METHOD: {
                        this.childContext.methodVisitor.visitLabel(this.childContext.continueLabel);
                        this.childContext.methodVisitor.visitInsn(177);
                        break;
                    }
                    case CONDITIONAL_METHOD: {
                        this.childContext.methodVisitor.visitLabel(this.childContext.continueLabel);
                        this.childContext.methodVisitor.visitInsn(3);
                        this.childContext.methodVisitor.visitInsn(172);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.childContext.methodVisitor.visitMaxs(-1, -1);
                this.childContext.methodVisitor.visitEnd();
            }
            if (this.endLabel != null) {
                this.context.methodVisitor.visitLabel(this.endLabel);
            }
        }

        private GeneratorContext generateMethodInvocation(AbstractDecoderTreeNode node) {
            List<InstructionDeclaration> instructions = node.getInstructions().toList();
            if (instructions.size() == 1) {
                return this.context;
            }
            OptionalInt commonInstructionSize = this.computeCommonInstructionSize(node);
            if (commonInstructionSize.isEmpty()) {
                return this.context;
            }
            ArrayList<FieldInstructionArgument> parameters = new ArrayList<FieldInstructionArgument>(node.getArguments().arguments.keySet());
            parameters.retainAll((Collection<?>)this.context.localVariables.keySet());
            Object2IntArrayMap localsInMethod = new Object2IntArrayMap();
            for (int i = 0; i < parameters.size(); ++i) {
                localsInMethod.put((Object)parameters.get(i), 4 + i);
            }
            List<InstructionDefinition> definitions = instructions.stream().map(DecoderGenerator.this.definitionProvider).filter(Objects::nonNull).toList();
            boolean containsReturns = definitions.stream().anyMatch(d -> d.writesPC || d.returnsBoolean);
            String methodName = DecoderGenerator.this.decoderMethod + "$instructionGroup" + DecoderGenerator.this.instructionGroupMethodIndex++;
            String methodDescriptor = "(IJ" + StringUtils.repeat((char)'I', (int)parameters.size()) + ")" + (containsReturns ? "I" : "V");
            this.context.methodVisitor.visitVarInsn(25, 0);
            this.context.methodVisitor.visitVarInsn(21, this.context.localInst);
            this.context.methodVisitor.visitVarInsn(22, this.context.localPc);
            for (FieldInstructionArgument parameter : parameters) {
                int localIndex = this.context.localVariables.getInt((Object)parameter);
                this.context.methodVisitor.visitVarInsn(21, localIndex);
            }
            this.context.methodVisitor.visitMethodInsn(183, DecoderGenerator.this.hostClassInternalName, methodName, methodDescriptor, false);
            if (containsReturns) {
                Label[] conditionalLabels = new Label[4];
                for (int i = 0; i < conditionalLabels.length; ++i) {
                    conditionalLabels[i] = new Label();
                }
                switch (this.context.type) {
                    case TOP_LEVEL: {
                        this.context.methodVisitor.visitTableSwitchInsn(0, conditionalLabels.length - 1, this.context.illegalInstructionLabel, conditionalLabels);
                        this.context.methodVisitor.visitLabel(conditionalLabels[0]);
                        this.context.emitIncrementPC(commonInstructionSize.getAsInt());
                        this.context.methodVisitor.visitJumpInsn(167, this.context.continueLabel);
                        this.context.methodVisitor.visitLabel(conditionalLabels[1]);
                        this.context.emitIncrementPC(commonInstructionSize.getAsInt());
                        this.context.emitSavePC();
                        this.context.methodVisitor.visitInsn(177);
                        this.context.methodVisitor.visitLabel(conditionalLabels[2]);
                        this.context.methodVisitor.visitInsn(177);
                        this.context.methodVisitor.visitLabel(conditionalLabels[3]);
                        this.context.emitJumpHandler();
                        break;
                    }
                    case CONDITIONAL_METHOD: {
                        this.context.methodVisitor.visitInsn(172);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            } else {
                this.context.emitIncrementPC(commonInstructionSize.getAsInt());
                this.context.emitContinue();
            }
            String[] exceptions = (String[])definitions.stream().map(d -> d.thrownExceptions).filter(Objects::nonNull).flatMap(Arrays::stream).distinct().toArray(String[]::new);
            MethodVisitor childVisitor = this.context.classVisitor.visitMethod(2, methodName, methodDescriptor, null, exceptions);
            childVisitor.visitCode();
            this.childContext = new GeneratorContext(this.context.classVisitor, childVisitor, containsReturns ? ContextType.CONDITIONAL_METHOD : ContextType.VOID_METHOD, this.context.processedMask, (Object2IntArrayMap<FieldInstructionArgument>)localsInMethod);
            return this.childContext;
        }

        private OptionalInt computeCommonInstructionSize(AbstractDecoderTreeNode node) {
            List<Integer> sizes = node.getInstructions().map(i -> i.size).distinct().toList();
            return sizes.size() == 1 ? OptionalInt.of(sizes.get(0)) : OptionalInt.empty();
        }
    }

    private final class DecoderTreeRootNodeVisitor
    implements DecoderTreeVisitor,
    Opcodes {
        private final GeneratorContext context;

        public DecoderTreeRootNodeVisitor(GeneratorContext context) {
            this.context = context;
        }

        @Override
        public DecoderTreeSwitchVisitor visitSwitch(DecoderTreeSwitchNode node) {
            return new SwitchVisitor(this.context);
        }

        @Override
        public DecoderTreeBranchVisitor visitBranch(DecoderTreeBranchNode node) {
            return new BranchVisitor(this.context);
        }

        @Override
        public DecoderTreeLeafVisitor visitInstruction() {
            return new LeafVisitor(this.context);
        }

        @Override
        public void visitEnd() {
            this.context.methodVisitor.visitLabel(this.context.illegalInstructionLabel);
            this.context.methodVisitor.visitTypeInsn(187, DecoderGenerator.this.illegalInstructionInternalName);
            this.context.methodVisitor.visitInsn(89);
            this.context.methodVisitor.visitMethodInsn(183, DecoderGenerator.this.illegalInstructionInternalName, "<init>", "()V", false);
            this.context.methodVisitor.visitInsn(191);
            this.context.methodVisitor.visitLabel(this.context.continueLabel);
        }
    }
}

