/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.decoder;

import java.io.PrintStream;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.decoder.DecoderTreeBranchVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeLeafVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeNodeArguments;
import li.cil.sedna.instruction.decoder.DecoderTreeSwitchVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeVisitor;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeBranchNode;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeSwitchNode;
import li.cil.sedna.utils.BitUtils;
import org.apache.commons.lang3.StringUtils;

public final class PrintStreamDecoderTreeVisitor
implements DecoderTreeVisitor {
    private final PrintStream stream;
    private final int maxDepth;

    public PrintStreamDecoderTreeVisitor() {
        this(System.out);
    }

    public PrintStreamDecoderTreeVisitor(int alignment) {
        this(System.out, alignment);
    }

    public PrintStreamDecoderTreeVisitor(PrintStream stream) {
        this(stream, 0);
    }

    public PrintStreamDecoderTreeVisitor(PrintStream stream, int alignment) {
        this.stream = stream;
        this.maxDepth = alignment;
    }

    @Override
    public DecoderTreeSwitchVisitor visitSwitch(DecoderTreeSwitchNode node) {
        return new SwitchVisitor(0, 0, 0);
    }

    @Override
    public DecoderTreeBranchVisitor visitBranch(DecoderTreeBranchNode node) {
        return new BranchVisitor(0, 0, 0);
    }

    @Override
    public DecoderTreeLeafVisitor visitInstruction() {
        return new LeafVisitor(0, 0, 0, -1, true);
    }

    @Override
    public void visitEnd() {
    }

    private void printNodeHeader(int depth, int branchMask, boolean hasChildren, boolean isLastChild) {
        for (int branch = 1 << depth; branch != 0; branch >>>= 1) {
            if (branch == 1) {
                if (isLastChild) {
                    this.stream.print("\u2514");
                } else {
                    this.stream.print("\u251c");
                }
                if (hasChildren) {
                    this.stream.print("\u2500\u252c\u2500");
                    for (j = depth + 1; j < this.maxDepth; ++j) {
                        this.stream.print("\u2500\u2500");
                    }
                } else {
                    this.stream.print("\u2500");
                    for (j = depth; j < this.maxDepth; ++j) {
                        this.stream.print("\u2500\u2500");
                    }
                }
                this.stream.print("\u2574 ");
                continue;
            }
            if ((branch & branchMask) != 0) {
                this.stream.print("\u2502 ");
                continue;
            }
            this.stream.print("  ");
        }
    }

    private static char[] formatMasked(int value, int mask, int consumedMask) {
        char[] chars = StringUtils.leftPad((String)Integer.toBinaryString(value), (int)32, (char)'0').toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if ((mask & 1 << i) == 0) {
                chars[chars.length - 1 - i] = 46;
            }
            if ((consumedMask & 1 << i) == 0) continue;
            chars[chars.length - 1 - i] = 32;
        }
        return chars;
    }

    private static int instructionSizeToMask(int size) {
        return (int)BitUtils.maskFromRange(0, size * 8 - 1);
    }

    private final class SwitchVisitor
    implements DecoderTreeSwitchVisitor {
        private final int depth;
        private final int processedMask;
        private final int branchMask;
        private int switchMask;
        private int count;

        public SwitchVisitor(int depth, int processedMask, int branchMask) {
            this.depth = depth;
            this.processedMask = processedMask;
            this.branchMask = branchMask;
        }

        @Override
        public void visit(int mask, int[] patterns, DecoderTreeNodeArguments arguments) {
            this.count = patterns.length;
            this.switchMask = mask & ~this.processedMask;
            if (this.depth > 0) {
                for (DecoderTreeNodeArguments.Entry entry : arguments.arguments.values()) {
                    PrintStreamDecoderTreeVisitor.this.stream.print(String.join((CharSequence)"=", entry.names));
                    PrintStreamDecoderTreeVisitor.this.stream.printf(" (%d/%d) ", entry.count, arguments.totalLeafCount);
                }
                PrintStreamDecoderTreeVisitor.this.stream.println();
            }
        }

        @Override
        public DecoderTreeVisitor visitSwitchCase(int index, int pattern) {
            boolean isLastChild = index == this.count - 1;
            return new InnerNodeVisitor(pattern, this.switchMask, this.processedMask, this.depth + 1, this.branchMask << 1 | (isLastChild ? 0 : 1), isLastChild);
        }

        @Override
        public void visitEnd() {
        }
    }

    private final class BranchVisitor
    implements DecoderTreeBranchVisitor {
        private final int depth;
        private final int processedMask;
        private final int branchMask;
        private int count;

        public BranchVisitor(int depth, int processedMask, int branchMask) {
            this.depth = depth;
            this.processedMask = processedMask;
            this.branchMask = branchMask;
        }

        @Override
        public void visit(int count, DecoderTreeNodeArguments arguments) {
            this.count = count;
            if (this.depth > 0) {
                for (DecoderTreeNodeArguments.Entry entry : arguments.arguments.values()) {
                    PrintStreamDecoderTreeVisitor.this.stream.print(String.join((CharSequence)"=", entry.names));
                    PrintStreamDecoderTreeVisitor.this.stream.printf(" (%d/%d) ", entry.count, arguments.totalLeafCount);
                }
                PrintStreamDecoderTreeVisitor.this.stream.println();
            }
        }

        @Override
        public DecoderTreeVisitor visitBranchCase(int index, int mask, int pattern) {
            boolean isLastChild = index == this.count - 1;
            return new InnerNodeVisitor(pattern, mask, this.processedMask, this.depth + 1, this.branchMask << 1 | (isLastChild ? 0 : 1), isLastChild);
        }

        @Override
        public void visitEnd() {
        }
    }

    private final class LeafVisitor
    implements DecoderTreeLeafVisitor {
        private final int depth;
        private final int consumedMask;
        private final int branchMask;
        private final int parentMask;
        private final boolean isLastChild;

        public LeafVisitor(int depth, int consumedMask, int branchMask, int parentMask, boolean isLastChild) {
            this.depth = depth;
            this.consumedMask = consumedMask;
            this.branchMask = branchMask;
            this.parentMask = parentMask;
            this.isLastChild = isLastChild;
        }

        @Override
        public void visitInstruction(InstructionDeclaration declaration) {
            PrintStreamDecoderTreeVisitor.this.printNodeHeader(this.depth, this.branchMask, false, this.isLastChild);
            PrintStreamDecoderTreeVisitor.this.stream.print(PrintStreamDecoderTreeVisitor.formatMasked(declaration.pattern, this.parentMask & declaration.patternMask, this.consumedMask | ~PrintStreamDecoderTreeVisitor.instructionSizeToMask(declaration.size)));
            PrintStreamDecoderTreeVisitor.this.stream.print("    ");
            PrintStreamDecoderTreeVisitor.this.stream.print(StringUtils.rightPad((String)declaration.displayName, (int)12));
            PrintStreamDecoderTreeVisitor.this.stream.println(String.join((CharSequence)" ", declaration.arguments.keySet()));
        }

        @Override
        public void visitEnd() {
        }
    }

    private final class InnerNodeVisitor
    implements DecoderTreeVisitor {
        private final int depth;
        private final int processedMask;
        private final int branchMask;
        private final int parentMask;
        private final int pattern;
        private final boolean isLastChild;

        public InnerNodeVisitor(int pattern, int parentMask, int processedMask, int depth, int branchMask, boolean isLastChild) {
            this.depth = depth;
            this.processedMask = processedMask;
            this.branchMask = branchMask;
            this.parentMask = parentMask;
            this.pattern = pattern;
            this.isLastChild = isLastChild;
        }

        @Override
        public DecoderTreeSwitchVisitor visitSwitch(DecoderTreeSwitchNode node) {
            PrintStreamDecoderTreeVisitor.this.printNodeHeader(this.depth, this.branchMask, true, this.isLastChild);
            PrintStreamDecoderTreeVisitor.this.stream.print(PrintStreamDecoderTreeVisitor.formatMasked(this.pattern, this.parentMask, this.processedMask));
            PrintStreamDecoderTreeVisitor.this.stream.print("    ");
            PrintStreamDecoderTreeVisitor.this.stream.print(StringUtils.rightPad((String)"[SWITCH]", (int)12));
            return new SwitchVisitor(this.depth, this.processedMask | this.parentMask, this.branchMask);
        }

        @Override
        public DecoderTreeBranchVisitor visitBranch(DecoderTreeBranchNode node) {
            PrintStreamDecoderTreeVisitor.this.printNodeHeader(this.depth, this.branchMask, true, this.isLastChild);
            PrintStreamDecoderTreeVisitor.this.stream.print(PrintStreamDecoderTreeVisitor.formatMasked(this.pattern, this.parentMask, this.processedMask));
            PrintStreamDecoderTreeVisitor.this.stream.print("    ");
            PrintStreamDecoderTreeVisitor.this.stream.print(StringUtils.rightPad((String)"[BRANCH]", (int)12));
            return new BranchVisitor(this.depth, this.processedMask | this.parentMask, this.branchMask);
        }

        @Override
        public DecoderTreeLeafVisitor visitInstruction() {
            return new LeafVisitor(this.depth, this.processedMask, this.branchMask, this.parentMask, this.isLastChild);
        }

        @Override
        public void visitEnd() {
        }
    }
}

