/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.memory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;

public final class MemoryMaps {
    public static int getContinuousMemorySize(MemoryMap memory, long address) {
        MappedMemoryRange range = memory.getMemoryRange(address);
        if (range == null || !(range.device instanceof PhysicalMemory)) {
            return 0;
        }
        return range.size() + MemoryMaps.getContinuousMemorySize(memory, range.end + 1L);
    }

    public static void load(MemoryMap memory, long address, byte[] dst, int offset, int length) throws MemoryAccessException {
        ByteBuffer buffer = ByteBuffer.wrap(dst, offset, length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        MemoryMaps.load(memory, address, buffer);
    }

    public static void load(MemoryMap memory, long address, ByteBuffer dst) throws MemoryAccessException {
        while (dst.hasRemaining()) {
            MappedMemoryRange range = memory.getMemoryRange(address);
            if (range == null) {
                throw new MemoryAccessException();
            }
            int offset = (int)(address - range.start);
            int length = Math.min((int)(range.end - address + 1L), dst.remaining());
            if (length <= 0) {
                throw new AssertionError();
            }
            MemoryMaps.load(range.device, offset, length, dst);
            address += (long)length;
        }
    }

    public static void store(MemoryMap memory, long address, byte[] src, int offset, int length) throws MemoryAccessException {
        ByteBuffer buffer = ByteBuffer.wrap(src, offset, length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        MemoryMaps.store(memory, address, buffer);
    }

    public static void store(MemoryMap memory, long address, ByteBuffer src) throws MemoryAccessException {
        while (src.hasRemaining()) {
            MappedMemoryRange range = memory.getMemoryRange(address);
            if (range == null) {
                throw new MemoryAccessException();
            }
            int offset = (int)(address - range.start);
            int length = Math.min((int)(range.end - address + 1L), src.remaining());
            if (length <= 0) {
                throw new AssertionError();
            }
            MemoryMaps.store(range.device, offset, length, src);
            address += (long)length;
        }
    }

    public static void store(MemoryMap memory, long address, InputStream stream) throws IOException {
        byte[] array = new byte[65536];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        while (true) {
            MappedMemoryRange range;
            if ((range = memory.getMemoryRange(address)) == null) {
                throw new MemoryAccessException();
            }
            int offset = (int)(address - range.start);
            int maxReadCount = Math.min((int)(range.end - address + 1L), array.length);
            int readCount = stream.read(array, 0, maxReadCount);
            if (readCount < 0) break;
            buffer.clear();
            MemoryMaps.store(range.device, offset, readCount, buffer);
            address += (long)readCount;
        }
    }

    private static void load(MemoryMappedDevice device, int offset, int length, ByteBuffer dst) throws MemoryAccessException {
        if (device instanceof PhysicalMemory) {
            int limit = dst.limit();
            dst.limit(dst.position() + length);
            ((PhysicalMemory)device).load(offset, dst);
            dst.limit(limit);
        } else {
            MemoryMaps.loadSlow(device, offset, length, dst);
        }
    }

    private static void store(MemoryMappedDevice device, int offset, int length, ByteBuffer src) throws MemoryAccessException {
        if (device instanceof PhysicalMemory) {
            int limit = src.limit();
            src.limit(src.position() + length);
            ((PhysicalMemory)device).store(offset, src);
            src.limit(limit);
        } else {
            MemoryMaps.storeSlow(device, offset, length, src);
        }
    }

    private static void loadSlow(MemoryMappedDevice device, int offset, int length, ByteBuffer dst) throws MemoryAccessException {
        int end = offset + length;
        if (dst.order() == ByteOrder.LITTLE_ENDIAN && (device.getSupportedSizes() & 4) != 0) {
            while (offset < end - 3) {
                dst.putInt((int)device.load(offset, 2));
                offset += 4;
            }
        }
        while (offset < end) {
            dst.put((byte)device.load(offset, 0));
            ++offset;
        }
    }

    private static void storeSlow(MemoryMappedDevice device, int offset, int length, ByteBuffer src) throws MemoryAccessException {
        int end = offset + length;
        if (src.order() == ByteOrder.LITTLE_ENDIAN && (device.getSupportedSizes() & 4) != 0) {
            while (offset < end - 3) {
                device.store(offset, src.getInt(), 2);
                offset += 4;
            }
        }
        while (offset < end) {
            device.store(offset, src.get(), 0);
            ++offset;
        }
    }
}

