/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.Board;
import li.cil.sedna.api.device.InterruptController;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.api.device.Resettable;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.device.rtc.RealTimeCounter;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.api.memory.MemoryRangeAllocationStrategy;
import li.cil.sedna.device.flash.FlashMemoryDevice;
import li.cil.sedna.devicetree.DeviceTreeRegistry;
import li.cil.sedna.devicetree.FlattenedDeviceTree;
import li.cil.sedna.gdbstub.GDBStub;
import li.cil.sedna.memory.SimpleMemoryMap;
import li.cil.sedna.riscv.R5CPU;
import li.cil.sedna.riscv.R5MemoryRangeAllocationStrategy;
import li.cil.sedna.riscv.device.R5CoreLocalInterrupter;
import li.cil.sedna.riscv.device.R5PlatformLevelInterruptController;
import li.cil.sedna.riscv.device.R5SystemController;
import li.cil.sedna.riscv.exception.R5SystemPowerOffException;
import li.cil.sedna.riscv.exception.R5SystemResetException;

public final class R5Board
implements Board {
    private static final long SYSCON_ADDRESS = 0x1000000L;
    private static final long CLINT_ADDRESS = 0x2000000L;
    private static final long PLIC_ADDRESS = 0xC000000L;
    private static final long FLASH_ADDRESS = 4096L;
    private static final int FLASH_SIZE = 256;
    private final MemoryRangeAllocationStrategy allocationStrategy = new R5MemoryRangeAllocationStrategy();
    private final MemoryMap memoryMap;
    private final RealTimeCounter rtc;
    private final FlashMemoryDevice flash;
    private final List<MemoryMappedDevice> devices = new ArrayList<MemoryMappedDevice>();
    private final List<Steppable> steppableDevices = new ArrayList<Steppable>();
    private MemoryMappedDevice standardOutputDevice;
    private GDBStub gdbStub;
    private boolean waitForGdb = false;
    @Serialized
    private final R5CPU cpu;
    @Serialized
    private final R5CoreLocalInterrupter clint;
    @Serialized
    private final R5PlatformLevelInterruptController plic;
    @Serialized
    private String bootargs;
    @Serialized
    private boolean isRunning;
    @Serialized
    private boolean isRestarting;

    public R5Board() {
        this.memoryMap = new SimpleMemoryMap();
        this.cpu = R5CPU.create(this.memoryMap);
        this.rtc = this.cpu;
        this.flash = new FlashMemoryDevice(256);
        this.clint = new R5CoreLocalInterrupter(this.rtc);
        this.plic = new R5PlatformLevelInterruptController();
        this.steppableDevices.add(this.cpu);
        this.clint.putHart(0, this.cpu);
        this.plic.setHart(this.cpu);
        this.addDevice(0x1000000L, new R5SystemController());
        this.addDevice(0x2000000L, this.clint);
        this.addDevice(0xC000000L, this.plic);
        this.addDevice(4096L, this.flash);
    }

    public boolean isRunning() {
        return this.isRunning && !this.isRestarting;
    }

    public void setRunning(boolean value) {
        this.isRunning = value;
    }

    public boolean isRestarting() {
        return this.isRestarting;
    }

    public R5CPU getCpu() {
        return this.cpu;
    }

    @Override
    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public InterruptController getInterruptController() {
        return this.plic;
    }

    @Override
    public MemoryRangeAllocationStrategy getAllocationStrategy() {
        return this.allocationStrategy;
    }

    @Override
    public boolean addDevice(long address, MemoryMappedDevice device) {
        if (device.getLength() == 0) {
            return false;
        }
        if (this.devices.contains(device)) {
            return false;
        }
        if (!this.memoryMap.addDevice(address, device)) {
            return false;
        }
        int index = Collections.binarySearch(this.devices, device, (o1, o2) -> {
            MappedMemoryRange range1 = this.memoryMap.getMemoryRange((MemoryMappedDevice)o1).orElseThrow(AssertionError::new);
            MappedMemoryRange range2 = this.memoryMap.getMemoryRange((MemoryMappedDevice)o2).orElseThrow(AssertionError::new);
            return Long.compareUnsigned(range1.address(), range2.address());
        });
        assert (index < 0);
        this.devices.add(~index, device);
        if (device instanceof Steppable) {
            this.steppableDevices.add((Steppable)((Object)device));
        }
        this.cpu.invalidateCaches();
        return true;
    }

    @Override
    public OptionalLong addDevice(MemoryMappedDevice device) {
        OptionalLong address = this.allocationStrategy.findMemoryRange(device, MemoryRangeAllocationStrategy.getMemoryMapIntersectionProvider(this.memoryMap));
        if (address.isPresent() && this.addDevice(address.getAsLong(), device)) {
            return address;
        }
        return OptionalLong.empty();
    }

    @Override
    public void removeDevice(MemoryMappedDevice device) {
        this.memoryMap.removeDevice(device);
        this.devices.remove(device);
        if (device instanceof Steppable) {
            this.steppableDevices.remove(device);
        }
        if (this.standardOutputDevice == device) {
            this.standardOutputDevice = null;
        }
        this.cpu.invalidateCaches();
    }

    @Override
    public int getInterruptCount() {
        return 31;
    }

    @Override
    public long getDefaultProgramStart() {
        return 0x80000000L;
    }

    @Override
    public void setBootArguments(String value) {
        if (value != null && value.length() > 64) {
            throw new IllegalArgumentException();
        }
        this.bootargs = value;
    }

    @Override
    public void setStandardOutputDevice(@Nullable MemoryMappedDevice device) {
        if (device != null && !this.devices.contains(device)) {
            throw new IllegalArgumentException();
        }
        this.standardOutputDevice = device;
    }

    public void enableGDB(int port, boolean waitForGdb) {
        GDBStub gdbStub;
        try {
            gdbStub = GDBStub.createDefault(this.cpu.getDebugInterface(), port);
        }
        catch (IOException e) {
            e.printStackTrace();
            gdbStub = null;
        }
        this.gdbStub = gdbStub;
        this.waitForGdb = waitForGdb;
    }

    @Override
    public void step(int cycles) {
        if (!this.isRunning()) {
            return;
        }
        if (this.gdbStub != null) {
            this.gdbStub.run(this.waitForGdb);
            this.waitForGdb = false;
        }
        try {
            for (Steppable device : this.steppableDevices) {
                device.step(cycles);
            }
        }
        catch (R5SystemResetException e) {
            this.reset();
            this.isRestarting = true;
        }
        catch (R5SystemPowerOffException e) {
            this.reset();
            this.isRunning = false;
        }
    }

    @Override
    public void reset() {
        this.cpu.reset();
        for (MemoryMappedDevice device : this.devices) {
            if (!(device instanceof Resettable)) continue;
            ((Resettable)((Object)device)).reset();
        }
    }

    public void initialize() throws IllegalStateException, MemoryAccessException {
        this.initialize(this.getDefaultProgramStart());
    }

    public void initialize(long programStart) throws IllegalStateException, MemoryAccessException {
        this.isRestarting = false;
        FlattenedDeviceTree fdt = this.buildDeviceTree().flatten();
        byte[] dtb = fdt.toDTB();
        OptionalLong fdtAddress = OptionalLong.empty();
        for (MemoryMappedDevice device : this.devices) {
            MappedMemoryRange memoryRange;
            long address;
            if (!(device instanceof PhysicalMemory) || device.getLength() < dtb.length || Long.compareUnsigned(address = memoryRange.start + (long)(memoryRange = this.memoryMap.getMemoryRange(device).orElseThrow(AssertionError::new)).size() - (long)dtb.length & 0xFFFFFFFFFFFFFFF8L, memoryRange.start) < 0 || !fdtAddress.isEmpty() && Long.compareUnsigned(address, fdtAddress.getAsLong()) <= 0) continue;
            fdtAddress = OptionalLong.of(address);
        }
        if (fdtAddress.isEmpty()) {
            throw new IllegalStateException("No memory device present that can fit device tree.");
        }
        for (int i = 0; i < dtb.length; ++i) {
            this.memoryMap.store(fdtAddress.getAsLong() + (long)i, dtb[i], 0);
        }
        ByteBuffer data = this.flash.getData();
        data.clear();
        int auipc = 23;
        int ld = 12291;
        int jalr = 103;
        int rd_t0 = 640;
        int rd_a1 = 1408;
        int rs1_t0 = 163840;
        int imm_fdtAddressOffset = 0x1000000;
        int imm_programStartOffset = 0x1800000;
        data.putInt(663);
        data.putInt(16954755);
        data.putInt(25342595);
        data.putInt(163943);
        data.putLong(fdtAddress.getAsLong());
        data.putLong(programStart);
    }

    private DeviceTree buildDeviceTree() {
        DeviceTree root = DeviceTreeRegistry.create(this.memoryMap);
        root.addProp("#address-cells", 2).addProp("#size-cells", 2).addProp("compatible", "riscv-sedna", "riscv-virtio").addProp("model", "riscv-virtio,sedna");
        root.putChild("cpus", cpus -> cpus.addProp("#address-cells", 1).addProp("#size-cells", 0).addProp("timebase-frequency", this.rtc.getFrequency()).putChild("cpu-map", cpuMap -> cpuMap.putChild("cluster0", cluster -> cluster.addProp("core0", root.getPHandle(this.cpu)))).putChild("cpu", 0L, cpuNode -> cpuNode.addProp("device_type", "cpu").addProp("reg", 0).addProp("status", "okay").addProp("compatible", "riscv").addProp("riscv,isa", R5Board.getISAString(this.cpu)).addProp("mmu-type", "riscv,sv48").addProp("clock-frequency", this.cpu.getFrequency()).putChild("interrupt-controller", ic -> ic.addProp("#interrupt-cells", 1).addProp("interrupt-controller", new Object[0]).addProp("compatible", "riscv,cpu-intc").addProp("phandle", ic.getPHandle(this.cpu)))));
        root.putChild("soc", soc -> soc.addProp("#address-cells", 2).addProp("#size-cells", 2).addProp("compatible", "simple-bus").addProp("ranges", new Object[0]));
        for (MemoryMappedDevice device : this.devices) {
            DeviceTree node = DeviceTreeRegistry.visit(root, this.memoryMap, device);
            if (node == null || device != this.standardOutputDevice) continue;
            root.putChild("chosen", chosen -> chosen.addProp("stdout-path", node.getPath()));
        }
        if (this.bootargs != null) {
            root.putChild("chosen", chosen -> chosen.addProp("bootargs", this.bootargs));
        }
        return root;
    }

    private static String getISAString(R5CPU cpu) {
        StringBuilder isa = new StringBuilder("rv64");
        for (char i : "IEMAFDQLCBJTPVNSUHKORWXYZG".toCharArray()) {
            if ((cpu.getISA() & 1L << Character.toLowerCase(i) - 97) == 0L) continue;
            isa.append(Character.toLowerCase(i));
        }
        return isa.toString();
    }
}

