/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.sedna.api.device.rtc.RealTimeCounter;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.instruction.decoder.DecoderGenerator;
import li.cil.sedna.riscv.R5CPU;
import li.cil.sedna.riscv.R5CPUTemplate;
import li.cil.sedna.riscv.R5Instructions;
import li.cil.sedna.riscv.exception.R5IllegalInstructionException;
import org.apache.logging.log4j.core.util.Throwables;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;

public final class R5CPUGenerator {
    public static final Class<R5CPUTemplate> TEMPLATE_CLASS = R5CPUTemplate.class;
    public static final String GENERATED_SUFFIX = "$Generated";
    private static final Class<R5CPU> GENERATED_CLASS = R5CPUGenerator.generateClass();
    private static final Constructor<R5CPU> GENERATED_CLASS_CTOR;

    public static Class<R5CPU> getGeneratedClass() {
        return GENERATED_CLASS;
    }

    public static R5CPU create(MemoryMap physicalMemory, @Nullable RealTimeCounter rtc) {
        try {
            return GENERATED_CLASS_CTOR.newInstance(physicalMemory, rtc);
        }
        catch (InvocationTargetException e) {
            Throwables.rethrow((Throwable)e.getCause());
            throw new AssertionError();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<?> generateClass() {
        Class<?> clazz;
        block18: {
            ClassLoader classLoader = TEMPLATE_CLASS.getClassLoader();
            CPUClassLoader definerClassLoader = new CPUClassLoader();
            InputStream stream = classLoader.getResourceAsStream(TEMPLATE_CLASS.getName().replace('.', '/') + ".class");
            try {
                if (stream == null) {
                    throw new IOException("Could not load class file for class [" + TEMPLATE_CLASS + "].");
                }
                ClassReader reader = new ClassReader(stream);
                RemappedTypeCollector typeCollector = new RemappedTypeCollector(TEMPLATE_CLASS);
                reader.accept(typeCollector.getVisitor(), 8);
                Set<String> remappedTypeNames = typeCollector.getRemappedTypeNames();
                ListRemapper remapper = new ListRemapper(remappedTypeNames);
                for (String remappedTypeName : remappedTypeNames) {
                    if (Objects.equals(remappedTypeName, typeCollector.getHostClassName())) continue;
                    try {
                        InputStream nestedTypeStream = classLoader.getResourceAsStream(remappedTypeName.replace('.', '/') + ".class");
                        try {
                            if (nestedTypeStream == null) {
                                throw new IOException("Could not load class file for class [" + remappedTypeName + "].");
                            }
                            ClassReader nestedTypeReader = new ClassReader(nestedTypeStream);
                            RemappedTypeClassWriter nestedTypeWriter = new RemappedTypeClassWriter(remappedTypeNames);
                            nestedTypeReader.accept((ClassVisitor)new ClassRemapper((ClassVisitor)nestedTypeWriter, (Remapper)remapper), 8);
                            definerClassLoader.defineClass(nestedTypeWriter.toByteArray());
                        }
                        finally {
                            if (nestedTypeStream == null) continue;
                            nestedTypeStream.close();
                        }
                    }
                    catch (Throwable e) {
                        throw new AssertionError((Object)e);
                    }
                }
                RemappedTypeClassWriter writer = new RemappedTypeClassWriter(remappedTypeNames);
                DecoderGenerator generator64 = new DecoderGenerator((ClassVisitor)new ClassRemapper((ClassVisitor)writer, (Remapper)remapper), R5Instructions.RV64.getDecoderTree(), R5Instructions.RV64::getDefinition, R5IllegalInstructionException.class, "interpretTrace64", "decode");
                DecoderGenerator generator32 = new DecoderGenerator(generator64, R5Instructions.RV32.getDecoderTree(), R5Instructions.RV32::getDefinition, R5IllegalInstructionException.class, "interpretTrace32", "decode");
                reader.accept((ClassVisitor)generator32, 8);
                byte[] bytes = writer.toByteArray();
                clazz = definerClassLoader.defineClass(bytes);
                if (stream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new AssertionError((Object)e);
                }
            }
            stream.close();
        }
        return clazz;
    }

    static {
        try {
            GENERATED_CLASS_CTOR = GENERATED_CLASS.getDeclaredConstructor(MemoryMap.class, RealTimeCounter.class);
            GENERATED_CLASS_CTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class CPUClassLoader
    extends ClassLoader {
        public CPUClassLoader() {
            super(CPUClassLoader.class.getClassLoader());
        }

        public Class<?> defineClass(byte[] bytecode) {
            return this.defineClass(null, bytecode, 0, bytecode.length);
        }
    }

    private static class RemappedTypeCollector
    extends Remapper {
        private final Set<String> remappedTypeNames = new HashSet<String>();
        private final String hostClassName;

        public RemappedTypeCollector(Class<?> hostClass) {
            this.hostClassName = Type.getInternalName(hostClass);
        }

        public String getHostClassName() {
            return this.hostClassName;
        }

        public ClassVisitor getVisitor() {
            return new ClassRemapper(null, (Remapper)this);
        }

        public Set<String> getRemappedTypeNames() {
            return this.remappedTypeNames;
        }

        public String map(String internalName) {
            if (internalName.startsWith(this.hostClassName)) {
                this.remappedTypeNames.add(internalName);
            }
            return super.map(internalName);
        }
    }

    private static final class ListRemapper
    extends SimpleRemapper {
        public ListRemapper(Set<String> remappedTypeNames) {
            super(ListRemapper.toMapping(remappedTypeNames));
        }

        private static Map<String, String> toMapping(Set<String> remappedTypeNames) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String remappedTypeName : remappedTypeNames) {
                map.put(remappedTypeName, remappedTypeName + R5CPUGenerator.GENERATED_SUFFIX);
            }
            return map;
        }
    }

    private static final class RemappedTypeClassWriter
    extends ClassWriter {
        private final Map<String, String> toNewTypeName = new HashMap<String, String>();
        private final Map<String, String> toOldTypeName = new HashMap<String, String>();

        public RemappedTypeClassWriter(Set<String> remappedTypeNames) {
            super(2);
            for (String remappedTypeName : remappedTypeNames) {
                this.toNewTypeName.put(remappedTypeName, remappedTypeName + R5CPUGenerator.GENERATED_SUFFIX);
                this.toOldTypeName.put(remappedTypeName + R5CPUGenerator.GENERATED_SUFFIX, remappedTypeName);
            }
        }

        protected String getCommonSuperClass(String type1, String type2) {
            String commonSuperClass;
            if (this.toOldTypeName.containsKey(type1) && this.toOldTypeName.containsKey(type2)) {
                commonSuperClass = super.getCommonSuperClass(this.toOldTypeName.get(type1), this.toOldTypeName.get(type2));
            } else if (this.toOldTypeName.containsKey(type1)) {
                commonSuperClass = super.getCommonSuperClass(this.toOldTypeName.get(type1), type2);
            } else if (this.toOldTypeName.containsKey(type2)) {
                commonSuperClass = super.getCommonSuperClass(type1, this.toOldTypeName.get(type2));
            } else {
                return super.getCommonSuperClass(type1, type2);
            }
            if (this.toNewTypeName.containsKey(commonSuperClass)) {
                return this.toNewTypeName.get(commonSuperClass);
            }
            return commonSuperClass;
        }

        protected ClassLoader getClassLoader() {
            return TEMPLATE_CLASS.getClassLoader();
        }
    }
}

