/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.rtc.RealTimeCounter;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.gdbstub.CPUDebugInterface;
import li.cil.sedna.instruction.InstructionDefinition;
import li.cil.sedna.riscv.R5;
import li.cil.sedna.riscv.R5CPU;
import li.cil.sedna.riscv.exception.R5IllegalInstructionException;
import li.cil.sedna.riscv.exception.R5MemoryAccessException;
import li.cil.sedna.utils.BitUtils;
import li.cil.sedna.utils.SoftDouble;
import li.cil.sedna.utils.SoftFloat;

@Serialized
final class R5CPUTemplate
implements R5CPU {
    private static final int PC_INIT = 4096;
    private static final long MSTATUS_MASK = -206158430273L;
    private static final int COUNTEREN_MASK = 5;
    private static final long SSTATUS_MASK = 12885811507L;
    private static final int TLB_SIZE = 256;
    private long pc;
    private byte mxl;
    private int xlen;
    private final long[] x = new long[32];
    private final long[] f = new long[32];
    private final SoftFloat.Flags fflags = new SoftFloat.Flags();
    private byte frm;
    private byte fs;
    private final transient SoftFloat fpu32 = new SoftFloat(this.fflags);
    private final transient SoftDouble fpu64 = new SoftDouble(this.fflags);
    private long reservation_set = -1L;
    private long mcycle;
    private long mstatus;
    private long mtvec;
    private long medeleg;
    private long mideleg;
    private final AtomicLong mip = new AtomicLong();
    private long mie;
    private int mcounteren;
    private long mscratch;
    private long mepc;
    private long mcause;
    private long mtval;
    private long stvec;
    private int scounteren;
    private long sscratch;
    private long sepc;
    private long scause;
    private long stval;
    private long satp;
    private int priv;
    private boolean waitingForInterrupt;
    private final transient TLBEntry[] fetchTLB = new TLBEntry[256];
    private final transient TLBEntry[] loadTLB = new TLBEntry[256];
    private final transient TLBEntry[] storeTLB = new TLBEntry[256];
    private final transient MemoryMap physicalMemory;
    private int cycleDebt;
    private final transient RealTimeCounter rtc;
    private transient int cycleFrequency = 50000000;
    private final transient DebugInterface debugInterface = new DebugInterface();

    public R5CPUTemplate(MemoryMap physicalMemory, @Nullable RealTimeCounter rtc) {
        int i;
        this.rtc = rtc != null ? rtc : this;
        this.physicalMemory = physicalMemory;
        for (i = 0; i < 256; ++i) {
            this.fetchTLB[i] = new TLBEntry();
        }
        for (i = 0; i < 256; ++i) {
            this.loadTLB[i] = new TLBEntry();
        }
        for (i = 0; i < 256; ++i) {
            this.storeTLB[i] = new TLBEntry();
        }
        this.reset();
    }

    @Override
    public long getISA() {
        return this.misa();
    }

    @Override
    public void setXLEN(int value) {
        this.mxl = (byte)R5.mxl(value);
        this.xlen = value;
        this.mstatus = this.mstatus & 0xFFFFFFF0FFFFFFFFL | R5.mxl(value) << 32 | R5.mxl(value) << 34;
        if (value == 32) {
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = (int)this.x[i];
            }
        }
    }

    @Override
    public void reset() {
        this.reset(true, 4096L);
    }

    @Override
    public void reset(boolean hard, long pc) {
        this.pc = pc;
        this.waitingForInterrupt = false;
        this.priv = 3;
        this.mstatus &= 0xFFFFFFFFFFFFFFF7L;
        this.mstatus &= 0xFFFFFFFFFFFDFFFFL;
        this.mcause = 0L;
        this.mxl = (byte)R5.mxl(64);
        this.xlen = 64;
        this.flushTLB();
        if (hard) {
            Arrays.fill(this.x, 0L);
            this.reservation_set = -1L;
            this.mcycle = 0L;
            this.mstatus = R5.mxl(this.xlen) << 32 | R5.mxl(this.xlen) << 34;
            this.mtvec = 0L;
            this.medeleg = 0L;
            this.mideleg = 0L;
            this.mip.set(0L);
            this.mie = 0L;
            this.mcounteren = 0;
            this.mscratch = 0L;
            this.mepc = 0L;
            this.mtval = 0L;
            this.stvec = 0L;
            this.scounteren = 0;
            this.sscratch = 0L;
            this.sepc = 0L;
            this.scause = 0L;
            this.stval = 0L;
            this.satp = 0L;
        }
    }

    @Override
    public void invalidateCaches() {
        this.flushTLB();
    }

    @Override
    public long getTime() {
        return this.mcycle;
    }

    @Override
    public int getFrequency() {
        return this.cycleFrequency;
    }

    @Override
    public void setFrequency(int value) {
        this.cycleFrequency = value;
    }

    @Override
    public CPUDebugInterface getDebugInterface() {
        return this.debugInterface;
    }

    @Override
    public void raiseInterrupts(int mask) {
        this.mip.updateAndGet(operand -> operand | (long)mask);
        if (this.waitingForInterrupt && (this.mip.get() & this.mie) != 0L) {
            this.waitingForInterrupt = false;
        }
    }

    @Override
    public void lowerInterrupts(int mask) {
        this.mip.updateAndGet(operand -> operand & (long)(~mask));
    }

    @Override
    public int getRaisedInterrupts() {
        return (int)this.mip.get();
    }

    @Override
    public void step(int cycles) {
        int paidDebt = Math.min(cycles, this.cycleDebt);
        cycles -= paidDebt;
        this.cycleDebt -= paidDebt;
        if (this.waitingForInterrupt) {
            this.mcycle += (long)cycles;
            return;
        }
        long cycleLimit = this.mcycle + (long)cycles;
        while (!this.waitingForInterrupt && this.mcycle < cycleLimit) {
            long pending = this.mip.get() & this.mie;
            if (pending != 0L) {
                this.raiseInterrupt(pending);
            }
            this.interpret(false, false);
        }
        if (this.waitingForInterrupt && this.mcycle < cycleLimit) {
            this.mcycle = cycleLimit;
        }
        this.cycleDebt += (int)(cycleLimit - this.mcycle);
    }

    private long misa() {
        return R5.mxl(this.xlen) << R5.mxlShift(this.xlen) | (long)R5.isa('I', 'M', 'A', 'C', 'F', 'D', 'S', 'U');
    }

    private long getSupervisorStatusMask() {
        return 0x3000DE133L | R5.getStatusStateDirtyMask(this.xlen);
    }

    private void interpret(boolean singleStep, boolean ignoreBreakpoints) {
        try {
            int inst;
            TLBEntry cache = this.fetchPage(this.pc);
            MemoryMappedDevice device = cache.device;
            int instOffset = (int)(this.pc + cache.toOffset);
            int instEnd = instOffset - (int)(this.pc & 0xFFFL) + 4094;
            try {
                if (instOffset < instEnd) {
                    inst = (int)device.load(instOffset, 2);
                } else {
                    inst = (short)device.load(instOffset, 1) & 0xFFFF;
                    if ((inst & 3) == 3) {
                        TLBEntry highCache = this.fetchPage(this.pc + 2L);
                        MemoryMappedDevice highDevice = highCache.device;
                        inst |= (int)(highDevice.load((int)(this.pc + 2L + highCache.toOffset), 1) << 16);
                    }
                }
            }
            catch (MemoryAccessException e) {
                this.raiseException(1L, this.pc);
                return;
            }
            if (this.xlen == 32) {
                this.interpretTrace32(device, inst, this.pc, instOffset, singleStep ? 0 : instEnd, ignoreBreakpoints ? null : cache.breakpoints);
            } else {
                this.interpretTrace64(device, inst, this.pc, instOffset, singleStep ? 0 : instEnd, ignoreBreakpoints ? null : cache.breakpoints);
            }
        }
        catch (R5MemoryAccessException e) {
            this.raiseException(e.getType(), e.getAddress());
        }
    }

    private void interpretTrace32(MemoryMappedDevice device, int inst, long pc, int instOffset, int instEnd, LongSet breakpoints) {
        try {
            while (true) {
                if (breakpoints != null && breakpoints.contains(pc)) {
                    this.pc = pc;
                    this.debugInterface.handleBreakpoint(pc);
                    return;
                }
                ++this.mcycle;
                R5CPUTemplate.decode();
                if (Integer.compareUnsigned(instOffset, instEnd) >= 0) break;
                inst = (int)device.load(instOffset, 2);
            }
            this.pc = pc;
            return;
        }
        catch (MemoryAccessException e) {
            this.pc = pc;
            this.raiseException(1L, pc);
        }
        catch (R5IllegalInstructionException e) {
            this.pc = pc;
            this.raiseException(2L, inst);
        }
        catch (R5MemoryAccessException e) {
            this.pc = pc;
            this.raiseException(e.getType(), e.getAddress());
        }
    }

    private void interpretTrace64(MemoryMappedDevice device, int inst, long pc, int instOffset, int instEnd, LongSet breakpoints) {
        try {
            while (true) {
                if (breakpoints != null && breakpoints.contains(pc)) {
                    this.pc = pc;
                    this.debugInterface.handleBreakpoint(pc);
                    return;
                }
                ++this.mcycle;
                R5CPUTemplate.decode();
                if (Integer.compareUnsigned(instOffset, instEnd) >= 0) break;
                inst = (int)device.load(instOffset, 2);
            }
            this.pc = pc;
            return;
        }
        catch (MemoryAccessException e) {
            this.pc = pc;
            this.raiseException(1L, pc);
        }
        catch (R5IllegalInstructionException e) {
            this.pc = pc;
            this.raiseException(2L, inst);
        }
        catch (R5MemoryAccessException e) {
            this.pc = pc;
            this.raiseException(e.getType(), e.getAddress());
        }
    }

    private static void decode() throws R5IllegalInstructionException, R5MemoryAccessException {
        throw new UnsupportedOperationException();
    }

    private boolean csrrwx(int rd, long newValue, int csr) throws R5IllegalInstructionException {
        boolean exitTrace;
        this.checkCSR(csr, true);
        if (rd != 0) {
            long oldValue = this.readCSR(csr);
            exitTrace = this.writeCSR(csr, newValue);
            this.x[rd] = oldValue;
        } else {
            exitTrace = this.writeCSR(csr, newValue);
        }
        return exitTrace;
    }

    private boolean csrrscx(int rd, int rs1, int csr, long mask, boolean isSet) throws R5IllegalInstructionException {
        boolean mayChange;
        boolean bl = mayChange = rs1 != 0;
        if (mayChange) {
            this.checkCSR(csr, true);
            long value = this.readCSR(csr);
            long masked = isSet ? mask | value : (mask ^ 0xFFFFFFFFFFFFFFFFL) & value;
            boolean exitTrace = this.writeCSR(csr, masked);
            if (rd != 0) {
                this.x[rd] = value;
            }
            return exitTrace;
        }
        if (rd != 0) {
            this.checkCSR(csr, false);
            this.x[rd] = this.readCSR(csr);
        }
        return false;
    }

    private void checkCSR(int csr, boolean throwIfReadonly) throws R5IllegalInstructionException {
        if (throwIfReadonly && (csr >= 3072 && csr <= 3103 || csr >= 3200 && csr <= 3231)) {
            throw new R5IllegalInstructionException();
        }
        if (throwIfReadonly && (csr & 0xC00) == 3072) {
            throw new R5IllegalInstructionException();
        }
        if (this.priv < (csr >>> 8 & 3)) {
            throw new R5IllegalInstructionException();
        }
    }

    private long readCSR(int csr) throws R5IllegalInstructionException {
        switch (csr) {
            case 1: {
                if (this.fs == 0) {
                    return -1L;
                }
                return this.fpu32.flags.value;
            }
            case 2: {
                if (this.fs == 0) {
                    return -1L;
                }
                return this.frm;
            }
            case 3: {
                if (this.fs == 0) {
                    return -1L;
                }
                return this.frm << 5 | this.fpu32.flags.value;
            }
            case 256: {
                return this.getStatus(this.getSupervisorStatusMask());
            }
            case 260: {
                return this.mie & this.mideleg;
            }
            case 261: {
                return this.stvec;
            }
            case 262: {
                return this.scounteren;
            }
            case 320: {
                return this.sscratch;
            }
            case 321: {
                return this.sepc;
            }
            case 322: {
                return this.scause;
            }
            case 323: {
                return this.stval;
            }
            case 324: {
                return this.mip.get() & this.mideleg;
            }
            case 384: {
                if (this.priv == 1 && (this.mstatus & 0x100000L) != 0L) {
                    throw new R5IllegalInstructionException();
                }
                return this.satp;
            }
            case 768: {
                return this.getStatus(-206158430273L);
            }
            case 769: {
                return this.misa();
            }
            case 770: {
                return this.medeleg;
            }
            case 771: {
                return this.mideleg;
            }
            case 772: {
                return this.mie;
            }
            case 773: {
                return this.mtvec;
            }
            case 774: {
                return this.mcounteren;
            }
            case 784: {
                if (this.xlen != 32) {
                    throw new R5IllegalInstructionException();
                }
                return this.getStatus(-206158430273L) >>> 32;
            }
            case 1952: {
                return 0L;
            }
            case 1953: {
                return 0L;
            }
            case 1954: {
                return 0L;
            }
            case 1955: {
                return 0L;
            }
            case 832: {
                return this.mscratch;
            }
            case 833: {
                return this.mepc;
            }
            case 834: {
                return this.mcause;
            }
            case 835: {
                return this.mtval;
            }
            case 836: {
                return this.mip.get();
            }
            case 2816: 
            case 2818: {
                return this.mcycle;
            }
            case 2944: 
            case 2946: {
                if (this.xlen != 32) {
                    throw new R5IllegalInstructionException();
                }
                return this.mcycle >>> 32;
            }
            case 3072: 
            case 3074: {
                this.checkCounterAccess(csr & 3);
                return this.mcycle;
            }
            case 3073: {
                return this.rtc.getTime();
            }
            case 3200: 
            case 3202: {
                if (this.xlen != 32) {
                    throw new R5IllegalInstructionException();
                }
                this.checkCounterAccess(csr & 3);
                return this.mcycle >>> 32;
            }
            case 3857: {
                return 0L;
            }
            case 3858: {
                return 0L;
            }
            case 3859: {
                return 0L;
            }
            case 3860: {
                return 0L;
            }
        }
        throw new R5IllegalInstructionException();
    }

    private boolean writeCSR(int csr, long value) throws R5IllegalInstructionException {
        switch (csr) {
            case 1: {
                this.fpu32.flags.value = (byte)(value & 0x1FL);
                this.fs = (byte)3;
                break;
            }
            case 2: {
                this.frm = (byte)(value & 7L);
                this.fs = (byte)3;
                break;
            }
            case 3: {
                this.frm = (byte)(value >>> 5 & 7L);
                this.fpu32.flags.value = (byte)(value & 0x1FL);
                this.fs = (byte)3;
                break;
            }
            case 256: {
                long supervisorStatusMask = this.getSupervisorStatusMask();
                this.setStatus(this.mstatus & (supervisorStatusMask ^ 0xFFFFFFFFFFFFFFFFL) | value & supervisorStatusMask);
                break;
            }
            case 260: {
                long mask = this.mideleg;
                this.mie = this.mie & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask;
                break;
            }
            case 261: {
                if ((value & 3L) >= 2L) break;
                this.stvec = value;
                break;
            }
            case 262: {
                this.scounteren = (int)(value & 5L);
                break;
            }
            case 320: {
                this.sscratch = value;
                break;
            }
            case 321: {
                this.sepc = value & 0xFFFFFFFFFFFFFFFEL;
                break;
            }
            case 322: {
                this.scause = value;
                break;
            }
            case 323: {
                this.stval = value;
                break;
            }
            case 324: {
                long mask = this.mideleg;
                this.mip.updateAndGet(operand -> operand & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask);
                break;
            }
            case 384: {
                long mode;
                long validatedValue = this.xlen == 32 ? value & (R5.SATP_ASID_MASK32 ^ 0xFFFFFFFFFFFFFFFFL) : value & (R5.SATP_ASID_MASK64 ^ 0xFFFFFFFFFFFFFFFFL);
                long change = this.satp ^ validatedValue;
                if (change == 0L) break;
                if (this.priv == 1 && (this.mstatus & 0x100000L) != 0L) {
                    throw new R5IllegalInstructionException();
                }
                if (this.xlen != 32 && (mode = validatedValue & R5.SATP_MODE_MASK64) != Long.MIN_VALUE && mode != -8070450532247928832L) break;
                if (this.xlen == 32) {
                    if ((this.satp & R5.SATP_MODE_MASK32) == 0L != ((validatedValue & R5.SATP_MODE_MASK32) == 0L)) {
                        this.flushTLB();
                    }
                } else if ((this.satp & R5.SATP_MODE_MASK64) == 0L != ((validatedValue & R5.SATP_MODE_MASK64) == 0L)) {
                    this.flushTLB();
                }
                this.satp = validatedValue;
                return true;
            }
            case 768: {
                this.setStatus(value & 0xFFFFFFCFFFFFFFBFL);
                break;
            }
            case 769: {
                break;
            }
            case 770: {
                this.medeleg = value & 0xFFFFFFFFFFFFF7FFL;
                break;
            }
            case 771: {
                int mask = 546;
                this.mideleg = this.mideleg & 0xFFFFFFFFFFFFFDDDL | value & 0x222L;
                break;
            }
            case 772: {
                int mask = 682;
                this.mie = this.mie & 0xFFFFFFFFFFFFFD55L | value & 0x2AAL;
                break;
            }
            case 773: {
                if ((value & 3L) >= 2L) break;
                this.mtvec = value;
                break;
            }
            case 774: {
                this.mcounteren = (int)(value & 5L);
                break;
            }
            case 784: {
                if (this.xlen != 32) {
                    throw new R5IllegalInstructionException();
                }
                this.setStatus(value << 32 & 0xFFFFFFCFFFFFFFBFL);
                break;
            }
            case 1952: {
                break;
            }
            case 1953: {
                break;
            }
            case 1954: {
                break;
            }
            case 1955: {
                break;
            }
            case 832: {
                this.mscratch = value;
                break;
            }
            case 833: {
                this.mepc = value & 0xFFFFFFFFFFFFFFFEL;
                break;
            }
            case 834: {
                this.mcause = value;
                break;
            }
            case 835: {
                this.mtval = value;
                break;
            }
            case 836: {
                int mask = 34;
                this.mip.updateAndGet(operand -> operand & 0xFFFFFFFFFFFFFFDDL | value & 0x22L);
                break;
            }
            case 3008: {
                this.setXLEN(32);
                return true;
            }
            default: {
                throw new R5IllegalInstructionException();
            }
        }
        return false;
    }

    private void checkCounterAccess(int bit) throws R5IllegalInstructionException {
        int counteren;
        if (this.priv < 3 && ((counteren = this.priv < 1 ? this.scounteren : this.mcounteren) & 1 << bit) == 0) {
            throw new R5IllegalInstructionException();
        }
    }

    private long getStatus(long mask) {
        long status = (this.mstatus | (long)(this.fs << 13)) & mask;
        boolean dirty = (this.mstatus & 0x6000L) == 24576L || (this.mstatus & 0x18000L) == 98304L;
        return status | (dirty ? R5.getStatusStateDirtyMask(this.xlen) : 0L);
    }

    private void setStatus(long value) {
        boolean mmuConfigChanged;
        long change = this.mstatus ^ value;
        boolean bl = mmuConfigChanged = (change & 0xE0000L) != 0L || (this.mstatus & 0x20000L) != 0L && (change & 0x1800L) != 0L;
        if (mmuConfigChanged) {
            this.flushTLB();
        }
        this.fs = (byte)((value & 0x6000L) >> 13);
        long mask = 0xFFFFFFCFFFFFFFBFL & ((R5.getStatusStateDirtyMask(this.xlen) | 0x6000L | 0x300000000L | 0xC00000000L) ^ 0xFFFFFFFFFFFFFFFFL);
        this.mstatus = this.mstatus & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask;
    }

    private void setPrivilege(int level) {
        if (this.priv == level) {
            return;
        }
        this.flushTLB();
        switch (level) {
            case 1: {
                this.xlen = R5.xlen((this.mstatus & 0xC00000000L) >>> 34);
                break;
            }
            case 0: {
                this.xlen = R5.xlen((this.mstatus & 0x300000000L) >>> 32);
                break;
            }
            default: {
                this.xlen = R5.xlen(this.mxl);
            }
        }
        this.priv = level;
    }

    private int resolveRoundingMode(int rm) throws R5IllegalInstructionException {
        if (rm == 7) {
            rm = this.frm;
        }
        if (rm > 4) {
            throw new R5IllegalInstructionException();
        }
        return rm;
    }

    private void raiseException(long exception, long value) {
        long vec;
        ++this.mcycle;
        long interruptMask = R5.interrupt(this.xlen);
        boolean async = (exception & interruptMask) != 0L;
        long cause = exception & (interruptMask ^ 0xFFFFFFFFFFFFFFFFL);
        long deleg = async ? this.mideleg : this.medeleg;
        int oldIE = (int)(this.mstatus >>> this.priv & 1L);
        if (this.priv <= 1 && (deleg >>> (int)cause & 1L) != 0L) {
            this.scause = exception;
            this.sepc = this.pc;
            this.stval = value;
            this.mstatus = this.mstatus & 0xFFFFFFFFFFFFFFDFL | (long)(oldIE << 5);
            this.mstatus = this.mstatus & 0xFFFFFFFFFFFFFEFFL | (long)this.priv << 8;
            this.mstatus &= 0xFFFFFFFFFFFFFFFDL;
            this.setPrivilege(1);
            vec = this.stvec;
        } else {
            this.mcause = exception;
            this.mepc = this.pc;
            this.mtval = value;
            this.mstatus = this.mstatus & 0xFFFFFFFFFFFFFF7FL | (long)(oldIE << 7);
            this.mstatus = this.mstatus & 0xFFFFFFFFFFFFE7FFL | (long)this.priv << 11;
            this.mstatus &= 0xFFFFFFFFFFFFFFF7L;
            this.setPrivilege(3);
            vec = this.mtvec;
        }
        int mode = (int)vec & 3;
        switch (mode) {
            case 1: {
                if (async) {
                    this.pc = (vec & 0xFFFFFFFFFFFFFFFEL) + 4L * cause;
                    break;
                }
                this.pc = vec & 0xFFFFFFFFFFFFFFFEL;
                break;
            }
            default: {
                this.pc = vec;
            }
        }
    }

    private void raiseException(long cause) {
        this.raiseException(cause, 0L);
    }

    private void raiseInterrupt(long pending) {
        long sieMask;
        boolean mieEnabled = (this.mstatus & 8L) != 0L;
        boolean sieEnabled = (this.mstatus & 2L) != 0L;
        long mieMask = this.priv < 3 || mieEnabled ? -1L : 0L;
        long interrupts = pending & (this.mideleg ^ 0xFFFFFFFFFFFFFFFFL) & mieMask | pending & this.mideleg & (sieMask = this.priv < 1 || this.priv == 1 && sieEnabled ? -1L : 0L);
        if (interrupts != 0L) {
            long customInterrupts = interrupts >>> 12;
            if (customInterrupts != 0L) {
                int interrupt = Long.numberOfTrailingZeros(customInterrupts) + 11 + 1;
                this.raiseException((long)interrupt | R5.interrupt(this.xlen));
            } else if ((pending & 0x800L) != 0L) {
                this.raiseException(0xBL | R5.interrupt(this.xlen));
            } else if ((pending & 8L) != 0L) {
                this.raiseException(3L | R5.interrupt(this.xlen));
            } else if ((pending & 0x80L) != 0L) {
                this.raiseException(7L | R5.interrupt(this.xlen));
            } else if ((pending & 0x200L) != 0L) {
                this.raiseException(9L | R5.interrupt(this.xlen));
            } else if ((pending & 2L) != 0L) {
                this.raiseException(1L | R5.interrupt(this.xlen));
            } else if ((pending & 0x20L) != 0L) {
                this.raiseException(5L | R5.interrupt(this.xlen));
            } else if ((pending & 0x100L) != 0L) {
                this.raiseException(8L | R5.interrupt(this.xlen));
            } else if ((pending & 1L) != 0L) {
                this.raiseException(0L | R5.interrupt(this.xlen));
            } else if ((pending & 0x10L) != 0L) {
                this.raiseException(4L | R5.interrupt(this.xlen));
            }
        }
    }

    private TLBEntry fetchPage(long address) throws R5MemoryAccessException {
        if ((address & 1L) != 0L) {
            throw new R5MemoryAccessException(address, 0);
        }
        int index = (int)(address >>> 12 & 0xFFL);
        long hash = address & 0xFFFFFFFFFFFFF000L;
        TLBEntry entry = this.fetchTLB[index];
        if (entry.hash == hash) {
            return entry;
        }
        return this.fetchPageSlow(address);
    }

    private byte load8(long address) throws R5MemoryAccessException {
        return (byte)this.loadx(address, 8, 0);
    }

    private void store8(long address, byte value) throws R5MemoryAccessException {
        this.storex(address, value, 8, 0);
    }

    private short load16(long address) throws R5MemoryAccessException {
        return (short)this.loadx(address, 16, 1);
    }

    private void store16(long address, short value) throws R5MemoryAccessException {
        this.storex(address, value, 16, 1);
    }

    private int load32(long address) throws R5MemoryAccessException {
        return (int)this.loadx(address, 32, 2);
    }

    private void store32(long address, int value) throws R5MemoryAccessException {
        this.storex(address, value, 32, 2);
    }

    private long load64(long address) throws R5MemoryAccessException {
        return this.loadx(address, 64, 3);
    }

    private void store64(long address, long value) throws R5MemoryAccessException {
        this.storex(address, value, 64, 3);
    }

    private long loadx(long address, int size, int sizeLog2) throws R5MemoryAccessException {
        long lastAddress = address + (long)(size / 8) - 1L;
        if ((address & 0xFFFFFFFFFFFFF000L) != (lastAddress & 0xFFFFFFFFFFFFF000L)) {
            return this.loadxPageMisaligned(address, size);
        }
        int index = (int)(address >>> 12 & 0xFFL);
        long hash = address & 0xFFFFFFFFFFFFF000L;
        TLBEntry entry = this.loadTLB[index];
        if (entry.hash == hash) {
            try {
                return entry.device.load((int)(address + entry.toOffset), sizeLog2);
            }
            catch (MemoryAccessException e) {
                throw new R5MemoryAccessException(address, 5);
            }
        }
        return this.loadSlow(address, sizeLog2);
    }

    private void storex(long address, long value, int size, int sizeLog2) throws R5MemoryAccessException {
        long lastAddress = address + (long)(size / 8) - 1L;
        if ((address & 0xFFFFFFFFFFFFF000L) != (lastAddress & 0xFFFFFFFFFFFFF000L)) {
            this.storexPageMisaligned(address, value, size);
            return;
        }
        int index = (int)(address >>> 12 & 0xFFL);
        long hash = address & 0xFFFFFFFFFFFFF000L;
        TLBEntry entry = this.storeTLB[index];
        if (entry.hash == hash) {
            try {
                entry.device.store((int)(address + entry.toOffset), value, sizeLog2);
            }
            catch (MemoryAccessException e) {
                throw new R5MemoryAccessException(address, 7);
            }
        } else {
            this.storeSlow(address, value, sizeLog2);
        }
    }

    private TLBEntry fetchPageSlow(long address) throws R5MemoryAccessException {
        long physicalAddress = this.getPhysicalAddress(address, MemoryAccessType.FETCH, false);
        MappedMemoryRange range = this.physicalMemory.getMemoryRange(physicalAddress);
        if (range == null || !range.device.supportsFetch()) {
            throw new R5MemoryAccessException(address, 1);
        }
        TLBEntry tlb = R5CPUTemplate.updateTLB(this.fetchTLB, address, physicalAddress, range);
        LongSortedSet subset = this.debugInterface.breakpoints.subSet(address, address + 4096L);
        if (subset.isEmpty()) {
            tlb.breakpoints = null;
        } else {
            tlb.breakpoints = new LongOpenHashSet(subset.size());
            tlb.breakpoints.addAll((LongCollection)subset);
        }
        return tlb;
    }

    private long loadSlow(long address, int sizeLog2) throws R5MemoryAccessException {
        long physicalAddress = this.getPhysicalAddress(address, MemoryAccessType.LOAD, false);
        MappedMemoryRange range = this.physicalMemory.getMemoryRange(physicalAddress);
        if (range == null) {
            throw new R5MemoryAccessException(address, 5);
        }
        try {
            if (range.device.supportsFetch()) {
                TLBEntry entry = R5CPUTemplate.updateTLB(this.loadTLB, address, physicalAddress, range);
                return entry.device.load((int)(address + entry.toOffset), sizeLog2);
            }
            return range.device.load((int)(physicalAddress - range.address()), sizeLog2);
        }
        catch (MemoryAccessException e) {
            throw new R5MemoryAccessException(address, 5);
        }
    }

    private void storeSlow(long address, long value, int sizeLog2) throws R5MemoryAccessException {
        long physicalAddress = this.getPhysicalAddress(address, MemoryAccessType.STORE, false);
        MappedMemoryRange range = this.physicalMemory.getMemoryRange(physicalAddress);
        if (range == null) {
            throw new R5MemoryAccessException(address, 7);
        }
        try {
            if (range.device.supportsFetch()) {
                TLBEntry entry = R5CPUTemplate.updateTLB(this.storeTLB, address, physicalAddress, range);
                int offset = (int)(address + entry.toOffset);
                entry.device.store(offset, value, sizeLog2);
                this.physicalMemory.setDirty(range, offset);
            } else {
                range.device.store((int)(physicalAddress - range.start), value, sizeLog2);
            }
        }
        catch (MemoryAccessException e) {
            throw new R5MemoryAccessException(address, 7);
        }
    }

    private long loadxPageMisaligned(long address, int size) throws R5MemoryAccessException {
        long value = 0L;
        for (int i = 0; i < size / 8; ++i) {
            value |= (this.loadx(address + (long)i, 8, 0) & 0xFFL) << i * 8;
        }
        return value;
    }

    private void storexPageMisaligned(long address, long value, int size) throws R5MemoryAccessException {
        for (int i = 0; i < size / 8; ++i) {
            long valueByte = value >> i * 8 & 0xFFL;
            this.storex(address + (long)i, valueByte, 8, 0);
        }
    }

    private long getPhysicalAddress(long virtualAddress, MemoryAccessType accessType, boolean bypassPermissions) throws R5MemoryAccessException {
        int pteSizeLog2;
        long ppnMask;
        long mode;
        int privilege = (this.mstatus & 0x20000L) != 0L && accessType != MemoryAccessType.FETCH ? (int)((this.mstatus & 0x1800L) >>> 11) : this.priv;
        if (privilege == 3) {
            if (this.xlen == 32) {
                return virtualAddress & 0xFFFFFFFFL;
            }
            return virtualAddress;
        }
        if (this.xlen == 32) {
            mode = this.satp & R5.SATP_MODE_MASK32;
            if (mode == 0L) {
                return virtualAddress & 0xFFFFFFFFL;
            }
        } else {
            mode = this.satp & R5.SATP_MODE_MASK64;
            if (mode == 0L) {
                return virtualAddress;
            }
        }
        if (mode == 0x80000000L) {
            levels = 2;
            ppnMask = R5.SATP_PPN_MASK32;
            pteSizeLog2 = 2;
        } else if (mode == Long.MIN_VALUE) {
            levels = 3;
            ppnMask = R5.SATP_PPN_MASK64;
            pteSizeLog2 = 3;
        } else if (mode == -8070450532247928832L) {
            levels = 4;
            ppnMask = R5.SATP_PPN_MASK64;
            pteSizeLog2 = 3;
        } else if (mode == -6917529027641081856L) {
            levels = 5;
            ppnMask = R5.SATP_PPN_MASK64;
            pteSizeLog2 = 3;
        } else {
            throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
        }
        int xpnSize = 12 - pteSizeLog2;
        int xpnMask = (1 << xpnSize) - 1;
        long pteAddress = (this.satp & ppnMask) << 12;
        for (int i = levels - 1; i >= 0; --i) {
            long pte;
            int vpnShift = 12 + xpnSize * i;
            int vpn = (int)(virtualAddress >>> vpnShift & (long)xpnMask);
            pteAddress += (long)vpn << pteSizeLog2;
            try {
                pte = this.physicalMemory.load(pteAddress, pteSizeLog2);
            }
            catch (MemoryAccessException e) {
                pte = 0L;
            }
            if ((pte & 1L) == 0L || (pte & 2L) == 0L && (pte & 4L) != 0L) {
                throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
            }
            int xwr = (int)(pte & 0xEL);
            if (xwr != 0) {
                int ppnLSB;
                if (!bypassPermissions) {
                    boolean userModeFlag;
                    boolean bl = userModeFlag = (pte & 0x10L) != 0L;
                    if (userModeFlag && privilege != 0 && (accessType == MemoryAccessType.FETCH || (this.mstatus & 0x40000L) == 0L)) {
                        throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
                    }
                    if (!userModeFlag && privilege != 1) {
                        throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
                    }
                    if (accessType == MemoryAccessType.LOAD && (this.mstatus & 0x80000L) != 0L && (xwr & 8) != 0) {
                        xwr |= 2;
                    }
                    if ((xwr & accessType.mask) == 0) {
                        throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
                    }
                }
                if (i > 0 && (ppnLSB = (int)(pte >>> 10 & (long)xpnMask)) != 0) {
                    throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
                }
                long updated_pte = pte | 0x40L | (long)(accessType == MemoryAccessType.STORE ? 128 : 0);
                if (pte != updated_pte) {
                    try {
                        this.physicalMemory.store(pteAddress, updated_pte, pteSizeLog2);
                    }
                    catch (MemoryAccessException e) {
                        throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
                    }
                }
                long vpnAndPageOffsetMask = (1L << vpnShift) - 1L;
                long ppn = pte >>> 10 << 12;
                return ppn & (vpnAndPageOffsetMask ^ 0xFFFFFFFFFFFFFFFFL) | virtualAddress & vpnAndPageOffsetMask;
            }
            long ppn = pte >>> 10;
            pteAddress = ppn << 12;
        }
        throw R5CPUTemplate.getPageFaultException(accessType, virtualAddress);
    }

    private static R5MemoryAccessException getPageFaultException(MemoryAccessType accessType, long address) {
        return switch (accessType) {
            default -> throw new IncompatibleClassChangeError();
            case MemoryAccessType.LOAD -> new R5MemoryAccessException(address, 13);
            case MemoryAccessType.STORE -> new R5MemoryAccessException(address, 15);
            case MemoryAccessType.FETCH -> new R5MemoryAccessException(address, 12);
        };
    }

    private static TLBEntry updateTLB(TLBEntry[] tlb, long address, long physicalAddress, MappedMemoryRange range) {
        int index = (int)(address >>> 12 & 0xFFL);
        return R5CPUTemplate.updateTLBEntry(tlb[index], address, physicalAddress, range);
    }

    private static TLBEntry updateTLBEntry(TLBEntry tlb, long address, long physicalAddress, MappedMemoryRange range) {
        tlb.hash = address & 0xFFFFFFFFFFFFF000L;
        tlb.toOffset = physicalAddress - address - range.start;
        tlb.device = range.device;
        return tlb;
    }

    private void flushTLB() {
        int i;
        for (i = 0; i < 256; ++i) {
            this.fetchTLB[i].hash = -1L;
        }
        for (i = 0; i < 256; ++i) {
            this.loadTLB[i].hash = -1L;
        }
        for (i = 0; i < 256; ++i) {
            this.storeTLB[i].hash = -1L;
        }
    }

    private void flushTLB(long address) {
        int index = (int)(address >>> 12 & 0xFFL);
        long hash = address & 0xFFFFFFFFFFFFF000L;
        if (this.fetchTLB[index].hash == hash) {
            this.fetchTLB[index].hash = -1L;
        }
        if (this.loadTLB[index].hash == hash) {
            this.loadTLB[index].hash = -1L;
        }
        if (this.storeTLB[index].hash == hash) {
            this.storeTLB[index].hash = -1L;
        }
    }

    @InstructionDefinition.Instruction(value="LUI")
    private void lui(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = imm;
        }
    }

    @InstructionDefinition.Instruction(value="AUIPC")
    private void auipc(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (rd != 0) {
            this.x[rd] = pc + (long)imm;
        }
    }

    @InstructionDefinition.Instruction(value="JAL")
    private void jal(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc, @InstructionDefinition.InstructionSize int instructionSize) {
        if (rd != 0) {
            this.x[rd] = pc + (long)instructionSize;
        }
        this.pc = pc + (long)imm;
    }

    @InstructionDefinition.Instruction(value="JALR")
    private void jalr(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc, @InstructionDefinition.InstructionSize int instructionSize) {
        long address = this.x[rs1] + (long)imm & 0xFFFFFFFFFFFFFFFEL;
        if (rd != 0) {
            this.x[rd] = pc + (long)instructionSize;
        }
        this.pc = address;
    }

    @InstructionDefinition.Instruction(value="BEQ")
    private boolean beq(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (this.x[rs1] == this.x[rs2]) {
            this.pc = pc + (long)imm;
            return true;
        }
        return false;
    }

    @InstructionDefinition.Instruction(value="BNE")
    private boolean bne(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (this.x[rs1] != this.x[rs2]) {
            this.pc = pc + (long)imm;
            return true;
        }
        return false;
    }

    @InstructionDefinition.Instruction(value="BLT")
    private boolean blt(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (this.x[rs1] < this.x[rs2]) {
            this.pc = pc + (long)imm;
            return true;
        }
        return false;
    }

    @InstructionDefinition.Instruction(value="BGE")
    private boolean bge(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (this.x[rs1] >= this.x[rs2]) {
            this.pc = pc + (long)imm;
            return true;
        }
        return false;
    }

    @InstructionDefinition.Instruction(value="BLTU")
    private boolean bltu(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (Long.compareUnsigned(this.x[rs1], this.x[rs2]) < 0) {
            this.pc = pc + (long)imm;
            return true;
        }
        return false;
    }

    @InstructionDefinition.Instruction(value="BGEU")
    private boolean bgeu(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (Long.compareUnsigned(this.x[rs1], this.x[rs2]) >= 0) {
            this.pc = pc + (long)imm;
            return true;
        }
        return false;
    }

    @InstructionDefinition.Instruction(value="LB")
    private void lb(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        byte result = this.load8(this.x[rs1] + (long)imm);
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="LH")
    private void lh(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        short result = this.load16(this.x[rs1] + (long)imm);
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="LW")
    private void lw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        int result = this.load32(this.x[rs1] + (long)imm);
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="LBU")
    private void lbu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        int result = this.load8(this.x[rs1] + (long)imm) & 0xFF;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="LHU")
    private void lhu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        int result = this.load16(this.x[rs1] + (long)imm) & 0xFFFF;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="SB")
    private void sb(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        this.store8(this.x[rs1] + (long)imm, (byte)this.x[rs2]);
    }

    @InstructionDefinition.Instruction(value="SH")
    private void sh(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        this.store16(this.x[rs1] + (long)imm, (short)this.x[rs2]);
    }

    @InstructionDefinition.Instruction(value="SW")
    private void sw(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        this.store32(this.x[rs1] + (long)imm, (int)this.x[rs2]);
    }

    @InstructionDefinition.Instruction(value="ADDI")
    private void addi(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] + (long)imm;
        }
    }

    @InstructionDefinition.Instruction(value="SLTI")
    private void slti(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] < (long)imm ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="SLTIU")
    private void sltiu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = Long.compareUnsigned(this.x[rs1], imm) < 0 ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="XORI")
    private void xori(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] ^ (long)imm;
        }
    }

    @InstructionDefinition.Instruction(value="ORI")
    private void ori(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] | (long)imm;
        }
    }

    @InstructionDefinition.Instruction(value="ANDI")
    private void andi(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] & (long)imm;
        }
    }

    @InstructionDefinition.Instruction(value="SLLI")
    private void slli(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="shamt") int shamt) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] << shamt;
        }
    }

    @InstructionDefinition.Instruction(value="SRLI")
    private void srli(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="shamt") int shamt) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] >>> shamt;
        }
    }

    @InstructionDefinition.Instruction(value="SRAI")
    private void srai(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="shamt") int shamt) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] >> shamt;
        }
    }

    @InstructionDefinition.Instruction(value="ADD")
    private void add(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] + this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SUB")
    private void sub(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] - this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SLL")
    private void sll(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] << (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SLT")
    private void slt(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] < this.x[rs2] ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="SLTU")
    private void sltu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = Long.compareUnsigned(this.x[rs1], this.x[rs2]) < 0 ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="XOR")
    private void xor(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] ^ this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SRL")
    private void srl(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] >>> (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SRA")
    private void sra(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] >> (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="OR")
    private void or(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] | this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="AND")
    private void and(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] & this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="FENCE")
    private void fence() {
    }

    @InstructionDefinition.Instruction(value="ECALL")
    private void ecall(@InstructionDefinition.ProgramCounter long pc) {
        this.pc = pc;
        this.raiseException(8 + this.priv);
    }

    @InstructionDefinition.Instruction(value="EBREAK")
    private void ebreak(@InstructionDefinition.ProgramCounter long pc) {
        this.pc = pc;
        this.raiseException(3L);
    }

    @InstructionDefinition.Instruction(value="AUIPCW")
    private void auipcw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc) {
        if (rd != 0) {
            this.x[rd] = (int)(pc + (long)imm);
        }
    }

    @InstructionDefinition.Instruction(value="JALW")
    private void jalw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc, @InstructionDefinition.InstructionSize int instructionSize) {
        if (rd != 0) {
            this.x[rd] = (int)(pc + (long)instructionSize);
        }
        this.pc = pc + (long)imm;
    }

    @InstructionDefinition.Instruction(value="JALRW")
    private void jalrw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm, @InstructionDefinition.ProgramCounter long pc, @InstructionDefinition.InstructionSize int instructionSize) {
        long address = this.x[rs1] + (long)imm & 0xFFFFFFFFFFFFFFFEL;
        if (rd != 0) {
            this.x[rd] = (int)(pc + (long)instructionSize);
        }
        this.pc = address;
    }

    @InstructionDefinition.Instruction(value="ADDIW")
    private void addiw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] + imm;
        }
    }

    @InstructionDefinition.Instruction(value="SLLIW")
    private void slliw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="shamt") int shamt) {
        if (rd != 0) {
            this.x[rd] = (int)(this.x[rs1] << shamt);
        }
    }

    @InstructionDefinition.Instruction(value="SRLIW")
    private void srliw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="shamt") int shamt) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] >>> shamt;
        }
    }

    @InstructionDefinition.Instruction(value="SRAIW")
    private void sraiw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="shamt") int shamt) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] >> shamt;
        }
    }

    @InstructionDefinition.Instruction(value="ADDW")
    private void addw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] + (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SUBW")
    private void subw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] - (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SLLW")
    private void sllw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] << (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SRLW")
    private void srlw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] >>> (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="SRAW")
    private void sraw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] >> (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="LWU")
    private void lwu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        long address = this.x[rs1] + (long)imm;
        long result = (long)this.load32(address) & 0xFFFFFFFFL;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="LD")
    private void ld(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        long address = this.x[rs1] + (long)imm;
        long result = this.load64(address);
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="SD")
    private void sd(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        this.store64(this.x[rs1] + (long)imm, this.x[rs2]);
    }

    @InstructionDefinition.Instruction(value="FENCE.I")
    private void fence_i() {
    }

    @InstructionDefinition.Instruction(value="CSRRW")
    private boolean csrrw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="csr") int csr) throws R5IllegalInstructionException {
        return this.csrrwx(rd, this.x[rs1], csr);
    }

    @InstructionDefinition.Instruction(value="CSRRS")
    private boolean csrrs(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="csr") int csr) throws R5IllegalInstructionException {
        return this.csrrscx(rd, rs1, csr, this.x[rs1], true);
    }

    @InstructionDefinition.Instruction(value="CSRRC")
    private boolean csrrc(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="csr") int csr) throws R5IllegalInstructionException {
        return this.csrrscx(rd, rs1, csr, this.x[rs1], false);
    }

    @InstructionDefinition.Instruction(value="CSRRWI")
    private boolean csrrwi(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="csr") int csr) throws R5IllegalInstructionException {
        return this.csrrwx(rd, rs1, csr);
    }

    @InstructionDefinition.Instruction(value="CSRRSI")
    private boolean csrrsi(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="csr") int csr) throws R5IllegalInstructionException {
        return this.csrrscx(rd, rs1, csr, rs1, true);
    }

    @InstructionDefinition.Instruction(value="CSRRCI")
    private boolean csrrci(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="csr") int csr) throws R5IllegalInstructionException {
        return this.csrrscx(rd, rs1, csr, rs1, false);
    }

    @InstructionDefinition.Instruction(value="MUL")
    private void mul(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs1] * this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="MULH")
    private void mulh(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = BigInteger.valueOf(this.x[rs1]).multiply(BigInteger.valueOf(this.x[rs2])).shiftRight(64).longValue();
        }
    }

    @InstructionDefinition.Instruction(value="MULHSU")
    private void mulhsu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = BigInteger.valueOf(this.x[rs1]).multiply(BitUtils.unsignedLongToBigInteger(this.x[rs2])).shiftRight(64).longValue();
        }
    }

    @InstructionDefinition.Instruction(value="MULHU")
    private void mulhu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = BitUtils.unsignedLongToBigInteger(this.x[rs1]).multiply(BitUtils.unsignedLongToBigInteger(this.x[rs2])).shiftRight(64).longValue();
        }
    }

    @InstructionDefinition.Instruction(value="DIV")
    private void div(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? -1L : (this.x[rs1] == Long.MIN_VALUE && this.x[rs2] == -1L ? this.x[rs1] : this.x[rs1] / this.x[rs2]);
        }
    }

    @InstructionDefinition.Instruction(value="DIVU")
    private void divu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? -1L : Long.divideUnsigned(this.x[rs1], this.x[rs2]);
        }
    }

    @InstructionDefinition.Instruction(value="REM")
    private void rem(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? this.x[rs1] : (this.x[rs1] == Long.MIN_VALUE && this.x[rs2] == -1L ? 0L : this.x[rs1] % this.x[rs2]);
        }
    }

    @InstructionDefinition.Instruction(value="REMU")
    private void remu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? this.x[rs1] : Long.remainderUnsigned(this.x[rs1], this.x[rs2]);
        }
    }

    @InstructionDefinition.Instruction(value="MULW")
    private void mulw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)this.x[rs1] * (int)this.x[rs2];
        }
    }

    @InstructionDefinition.Instruction(value="MULHW")
    private void mulhw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)(this.x[rs1] * this.x[rs2] >>> 32);
        }
    }

    @InstructionDefinition.Instruction(value="MULHSUW")
    private void mulhsuw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)(this.x[rs1] * (this.x[rs2] & 0xFFFFFFFFL) >>> 32);
        }
    }

    @InstructionDefinition.Instruction(value="MULHUW")
    private void mulhuw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = (int)((this.x[rs1] & 0xFFFFFFFFL) * (this.x[rs2] & 0xFFFFFFFFL) >>> 32);
        }
    }

    @InstructionDefinition.Instruction(value="DIVW")
    private void divw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? -1L : ((int)this.x[rs1] == Integer.MIN_VALUE && (int)this.x[rs2] == -1 ? (long)((int)this.x[rs1]) : (long)((int)this.x[rs1] / (int)this.x[rs2]));
        }
    }

    @InstructionDefinition.Instruction(value="DIVUW")
    private void divuw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? -1L : (long)Integer.divideUnsigned((int)this.x[rs1], (int)this.x[rs2]);
        }
    }

    @InstructionDefinition.Instruction(value="REMW")
    private void remw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? (long)((int)this.x[rs1]) : (this.x[rs1] == Integer.MIN_VALUE && this.x[rs2] == -1L ? 0L : (long)((int)this.x[rs1] % (int)this.x[rs2]));
        }
    }

    @InstructionDefinition.Instruction(value="REMUW")
    private void remuw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        if (rd != 0) {
            this.x[rd] = this.x[rs2] == 0L ? (long)((int)this.x[rs1]) : (long)Integer.remainderUnsigned((int)this.x[rs1], (int)this.x[rs2]);
        }
    }

    @InstructionDefinition.Instruction(value="LR.W")
    private void lr_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int result = this.load32(address);
        this.reservation_set = address;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="SC.W")
    private void sc_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        int result;
        long address = this.x[rs1];
        if (address == this.reservation_set) {
            this.store32(address, (int)this.x[rs2]);
            result = 0;
        } else {
            result = 1;
        }
        this.reservation_set = -1L;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="AMOSWAP.W")
    private void amoswap_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOADD.W")
    private void amoadd_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, a + b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOXOR.W")
    private void amoxor_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, a ^ b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOAND.W")
    private void amoand_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, a & b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOOR.W")
    private void amoor_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, a | b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMIN.W")
    private void amomin_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, Math.min(a, b));
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMAX.W")
    private void amomax_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        int a = this.load32(address);
        int b = (int)this.x[rs2];
        this.store32(address, Math.max(a, b));
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMINU.W")
    private void amominu_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        int b;
        long address;
        int a = this.load32(address = this.x[rs1]);
        this.store32(address, Integer.compareUnsigned(a, b = (int)this.x[rs2]) < 0 ? a : b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMAXU.W")
    private void amomaxu_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        int b;
        long address;
        int a = this.load32(address = this.x[rs1]);
        this.store32(address, Integer.compareUnsigned(a, b = (int)this.x[rs2]) > 0 ? a : b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="LR.D")
    private void lr_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long result = this.load64(address);
        this.reservation_set = address;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="SC.D")
    private void sc_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        int result;
        long address = this.x[rs1];
        if (address == this.reservation_set) {
            this.store64(address, this.x[rs2]);
            result = 0;
        } else {
            result = 1;
        }
        this.reservation_set = -1L;
        if (rd != 0) {
            this.x[rd] = result;
        }
    }

    @InstructionDefinition.Instruction(value="AMOSWAP.D")
    private void amoswap_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOADD.D")
    private void amoadd_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, a + b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOXOR.D")
    private void amoxor_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, a ^ b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOAND.D")
    private void amoand_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, a & b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOOR.D")
    private void amoor_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, a | b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMIN.D")
    private void amomin_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, Math.min(a, b));
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMAX.D")
    private void amomax_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long address = this.x[rs1];
        long a = this.load64(address);
        long b = this.x[rs2];
        this.store64(address, Math.max(a, b));
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMINU.D")
    private void amominu_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long b;
        long address;
        long a = this.load64(address = this.x[rs1]);
        this.store64(address, Long.compareUnsigned(a, b = this.x[rs2]) < 0 ? a : b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="AMOMAXU.D")
    private void amomaxu_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5MemoryAccessException {
        long b;
        long address;
        long a = this.load64(address = this.x[rs1]);
        this.store64(address, Long.compareUnsigned(a, b = this.x[rs2]) > 0 ? a : b);
        if (rd != 0) {
            this.x[rd] = a;
        }
    }

    @InstructionDefinition.Instruction(value="SRET")
    private boolean sret() throws R5IllegalInstructionException {
        if (this.priv < 1) {
            throw new R5IllegalInstructionException();
        }
        if ((this.mstatus & 0x400000L) != 0L && this.priv < 3) {
            throw new R5IllegalInstructionException();
        }
        int spp = (int)((this.mstatus & 0x100L) >>> 8);
        int spie = (int)((this.mstatus & 0x20L) >>> 5);
        this.mstatus = this.mstatus & 0xFFFFFFFFFFFFFFFDL | 2L * (long)spie << 1;
        this.mstatus = this.mstatus & (long)(~(1 << spp)) | (long)(spie << spp);
        this.mstatus |= 0x20L;
        this.mstatus &= 0xFFFFFFFFFFFFFEFFL;
        this.mstatus &= 0xFFFFFFFFFFFDFFFFL;
        this.setPrivilege(spp);
        this.pc = this.sepc;
        return true;
    }

    @InstructionDefinition.Instruction(value="MRET")
    private boolean mret() throws R5IllegalInstructionException {
        if (this.priv < 3) {
            throw new R5IllegalInstructionException();
        }
        int mpp = (int)((this.mstatus & 0x1800L) >>> 11);
        int mpie = (int)((this.mstatus & 0x80L) >>> 7);
        this.mstatus = this.mstatus & 0xFFFFFFFFFFFFFFF7L | 8L * (long)mpie << 3;
        this.mstatus |= 0x80L;
        this.mstatus &= 0xFFFFFFFFFFFFE7FFL;
        if (mpp != 3) {
            this.mstatus &= 0xFFFFFFFFFFFDFFFFL;
        }
        this.setPrivilege(mpp);
        this.pc = this.mepc;
        return true;
    }

    @InstructionDefinition.Instruction(value="WFI")
    private boolean wfi() throws R5IllegalInstructionException {
        if (this.priv == 0) {
            throw new R5IllegalInstructionException();
        }
        if ((this.mstatus & 0x200000L) != 0L && this.priv == 1) {
            throw new R5IllegalInstructionException();
        }
        if ((this.mip.get() & this.mie) != 0L) {
            return false;
        }
        this.waitingForInterrupt = true;
        return true;
    }

    @InstructionDefinition.Instruction(value="SFENCE.VMA")
    private boolean sfence_vma(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) throws R5IllegalInstructionException {
        if (this.priv == 0) {
            throw new R5IllegalInstructionException();
        }
        if ((this.mstatus & 0x100000L) != 0L && this.priv == 1) {
            throw new R5IllegalInstructionException();
        }
        if (rs1 == 0) {
            this.flushTLB();
        } else {
            this.flushTLB(this.x[rs1]);
        }
        return true;
    }

    private static int checkFloat(long value) {
        if ((value & 0xFFFFFFFF00000000L) != -4294967296L) {
            return SoftFloat.nan();
        }
        return (int)value;
    }

    @InstructionDefinition.Instruction(value="FLW")
    private void flw(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        this.f[rd] = (long)this.load32(this.x[rs1] + (long)imm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSW")
    private void fsw(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        if (this.fs == 0) {
            return;
        }
        this.store32(this.x[rs1] + (long)imm, (int)this.f[rs2]);
    }

    @InstructionDefinition.Instruction(value="FMADD.S")
    private void fmadd_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.muladd(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), R5CPUTemplate.checkFloat(this.f[rs3]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMSUB.S")
    private void fmsub_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.mulsub(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), R5CPUTemplate.checkFloat(this.f[rs3]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FNMSUB.S")
    private void fnmsub_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.neg(this.fpu32.mulsub(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), R5CPUTemplate.checkFloat(this.f[rs3]), rm)) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FNMADD.S")
    private void fnmadd_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.neg(this.fpu32.muladd(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), R5CPUTemplate.checkFloat(this.f[rs3]), rm)) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FADD.S")
    private void fadd_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.add(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSUB.S")
    private void fsub_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.sub(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMUL.S")
    private void fmul_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.mul(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FDIV.S")
    private void fdiv_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.div(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSQRT.S")
    private void fsqrt_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.sqrt(R5CPUTemplate.checkFloat(this.f[rs1]), rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSGNJ.S")
    private void fsgnj_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        long value = R5CPUTemplate.checkFloat(this.f[rs1]) & Integer.MAX_VALUE;
        this.f[rd] = value | (long)(R5CPUTemplate.checkFloat(this.f[rs2]) & Integer.MIN_VALUE) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSGNJN.S")
    private void fsgnjn_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        long value = R5CPUTemplate.checkFloat(this.f[rs1]) & Integer.MAX_VALUE;
        this.f[rd] = value | (long)(~R5CPUTemplate.checkFloat(this.f[rs2]) & Integer.MIN_VALUE) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSGNJX.S")
    private void fsgnjx_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        this.f[rd] = this.f[rs1] ^ (long)(R5CPUTemplate.checkFloat(this.f[rs2]) & Integer.MIN_VALUE) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMIN.S")
    private void fmin_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        this.f[rd] = (long)this.fpu32.min(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2])) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMAX.S")
    private void fmax_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        this.f[rd] = (long)this.fpu32.max(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2])) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.W.S")
    private void fcvt_w_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        int value = this.fpu32.floatToInt(R5CPUTemplate.checkFloat(this.f[rs1]), rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.WU.S")
    private void fcvt_wu_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        int value = this.fpu32.floatToUnsignedInt(R5CPUTemplate.checkFloat(this.f[rs1]), rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FMV.X.W")
    private void fmv_x_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) {
        if (rd != 0) {
            this.x[rd] = (int)this.f[rs1];
        }
    }

    @InstructionDefinition.Instruction(value="FEQ.S")
    private void feq_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        boolean areEqual = this.fpu32.equals(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]));
        if (rd != 0) {
            this.x[rd] = areEqual ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="FLT.S")
    private void flt_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        boolean isLessThan = this.fpu32.lessThan(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]));
        if (rd != 0) {
            this.x[rd] = isLessThan ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="FLE.S")
    private void fle_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        boolean isLessOrEqual = this.fpu32.lessOrEqual(R5CPUTemplate.checkFloat(this.f[rs1]), R5CPUTemplate.checkFloat(this.f[rs2]));
        if (rd != 0) {
            this.x[rd] = isLessOrEqual ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="FCLASS.S")
    private void fclass_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) {
        if (rd != 0) {
            this.x[rd] = this.fpu32.classify(R5CPUTemplate.checkFloat(this.f[rs1]));
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.S.W")
    private void fcvt_s_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.intToFloat((int)this.x[rs1], rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.S.WU")
    private void fcvt_s_wu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.unsignedIntToFloat((int)this.x[rs1], rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMV.W.X")
    private void fmv_w_x(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) {
        this.f[rd] = this.x[rs1] | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.L.S")
    private void fcvt_l_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        long value = this.fpu32.floatToLong((int)this.f[rs1], rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.LU.S")
    private void fcvt_lu_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        long value = this.fpu32.floatToUnsignedLong((int)this.f[rs1], rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.S.L")
    private void fcvt_s_l(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.longToFloat(this.x[rs1], rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.S.LU")
    private void fcvt_s_lu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu32.unsignedLongToFloat(this.x[rs1], rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FLD")
    private void fld(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        this.f[rd] = this.load64(this.x[rs1] + (long)imm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSD")
    private void fsd(@InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="imm") int imm) throws R5MemoryAccessException {
        if (this.fs == 0) {
            return;
        }
        this.store64(this.x[rs1] + (long)imm, this.f[rs2]);
    }

    @InstructionDefinition.Instruction(value="FMADD.D")
    private void fmadd_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.muladd(this.f[rs1], this.f[rs2], this.f[rs3], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMSUB.D")
    private void FMSUB_D(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.mulsub(this.f[rs1], this.f[rs2], this.f[rs3], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FNMSUB.D")
    private void fnmsub_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.neg(this.fpu64.mulsub(this.f[rs1], this.f[rs2], this.f[rs3], rm));
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FNMADD.D")
    private void fnmadd_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rs3") int rs3, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.neg(this.fpu64.muladd(this.f[rs1], this.f[rs2], this.f[rs3], rm));
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FADD.D")
    private void fadd_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.add(this.f[rs1], this.f[rs2], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSUB.D")
    private void fsub_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.sub(this.f[rs1], this.f[rs2], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMUL.D")
    private void fmul_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.mul(this.f[rs1], this.f[rs2], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FDIV.D")
    private void fdiv_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.div(this.f[rs1], this.f[rs2], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSQRT.D")
    private void fsqrt_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.sqrt(this.f[rs1], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSGNJ.D")
    private void fsgnj_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        long value = this.f[rs1] & Long.MAX_VALUE;
        this.f[rd] = value | this.f[rs2] & Long.MIN_VALUE;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSGNJN.D")
    private void fsgnjn_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        long value = this.f[rs1] & Long.MAX_VALUE;
        this.f[rd] = value | (this.f[rs2] ^ 0xFFFFFFFFFFFFFFFFL) & Long.MIN_VALUE;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FSGNJX.D")
    private void fsgnjx_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        this.f[rd] = this.f[rs1] ^ this.f[rs2] & Long.MIN_VALUE;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMIN.D")
    private void fmin_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        this.f[rd] = this.fpu64.min(this.f[rs1], this.f[rs2]);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMAX.D")
    private void fmax_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        this.f[rd] = this.fpu64.max(this.f[rs1], this.f[rs2]);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.S.D")
    private void fcvt_s_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = (long)this.fpu64.doubleToFloat(this.f[rs1], rm) | 0xFFFFFFFF00000000L;
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.D.S")
    private void fcvt_d_s(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.floatToDouble((int)this.f[rs1], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FEQ.D")
    private void feq_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        boolean areEqual = this.fpu64.equals(this.f[rs1], this.f[rs2]);
        if (rd != 0) {
            this.x[rd] = areEqual ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="FLT.D")
    private void flt_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        boolean isLessThan = this.fpu64.lessThan(this.f[rs1], this.f[rs2]);
        if (rd != 0) {
            this.x[rd] = isLessThan ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="FLE.D")
    private void fle_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rs2") int rs2) {
        boolean isLessOrEqual = this.fpu64.lessOrEqual(this.f[rs1], this.f[rs2]);
        if (rd != 0) {
            this.x[rd] = isLessOrEqual ? 1L : 0L;
        }
    }

    @InstructionDefinition.Instruction(value="FCLASS.D")
    private void fclass_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) {
        if (rd != 0) {
            this.x[rd] = this.fpu64.classify(this.f[rs1]);
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.W.D")
    private void fcvt_w_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        int value = this.fpu64.doubleToInt(this.f[rs1], rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.WU.D")
    private void fcvt_wu_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        int value = this.fpu64.doubleToUnsignedInt(this.f[rs1], rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.D.W")
    private void fcvt_d_w(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.intToDouble((int)this.x[rs1], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.D.WU")
    private void fcvt_d_wu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.unsignedIntToDouble((int)this.x[rs1], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.L.D")
    private void fcvt_l_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        long value = this.fpu64.doubleToLong(this.f[rs1], rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.LU.D")
    private void fcvt_lu_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        long value = this.fpu64.doubleToUnsignedLong(this.f[rs1], rm);
        if (rd != 0) {
            this.x[rd] = value;
        }
    }

    @InstructionDefinition.Instruction(value="FMV.X.D")
    private void fmv_x_d(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) {
        if (rd != 0) {
            this.x[rd] = this.f[rs1];
        }
    }

    @InstructionDefinition.Instruction(value="FCVT.D.L")
    private void fcvt_d_l(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.longToDouble(this.x[rs1], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FCVT.D.LU")
    private void fcvt_d_lu(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1, @InstructionDefinition.Field(value="rm") int rm) throws R5IllegalInstructionException {
        rm = this.resolveRoundingMode(rm);
        this.f[rd] = this.fpu64.unsignedLongToDouble(this.x[rs1], rm);
        this.fs = (byte)3;
    }

    @InstructionDefinition.Instruction(value="FMV.D.X")
    private void fmv_d_x(@InstructionDefinition.Field(value="rd") int rd, @InstructionDefinition.Field(value="rs1") int rs1) {
        this.f[rd] = this.x[rs1];
        this.fs = (byte)3;
    }

    private static final class TLBEntry {
        public long hash = -1L;
        public long toOffset;
        public MemoryMappedDevice device;
        public LongSet breakpoints;

        private TLBEntry() {
        }
    }

    private final class DebugInterface
    implements CPUDebugInterface {
        private final Collection<LongConsumer> breakpointListeners = new ArrayList<LongConsumer>();
        private final LongSortedSet breakpoints = new LongAVLTreeSet();

        private DebugInterface() {
        }

        @Override
        public long getProgramCounter() {
            return R5CPUTemplate.this.pc;
        }

        @Override
        public void setProgramCounter(long value) {
            R5CPUTemplate.this.pc = value;
        }

        @Override
        public void step() {
            R5CPUTemplate.this.interpret(true, true);
        }

        @Override
        public long[] getGeneralRegisters() {
            return R5CPUTemplate.this.x;
        }

        @Override
        public byte[] loadDebug(long address, int size) throws R5MemoryAccessException {
            byte[] mem = new byte[size];
            if (size == 0) {
                return mem;
            }
            TLBEntry entry = this.getPageDebug(address, MemoryAccessType.LOAD);
            int i = 0;
            while (true) {
                try {
                    mem[i] = (byte)entry.device.load((int)(address + (long)i + entry.toOffset), 0);
                }
                catch (MemoryAccessException e) {
                    return Arrays.copyOf(mem, i);
                }
                if (++i == size) break;
                if ((address + (long)i & 0xFFFL) != 0L) continue;
                entry = this.getPageDebug(address + (long)i, MemoryAccessType.LOAD);
            }
            return mem;
        }

        @Override
        public int storeDebug(long address, byte[] data) throws R5MemoryAccessException {
            TLBEntry entry = this.getPageDebug(address, MemoryAccessType.STORE);
            int i = 0;
            while (true) {
                try {
                    entry.device.store((int)(address + (long)i + entry.toOffset), data[i], 0);
                }
                catch (MemoryAccessException e) {
                    return i;
                }
                if (++i == data.length) break;
                if ((address + (long)i & 0xFFFL) != 0L) continue;
                entry = this.getPageDebug(address + (long)i, MemoryAccessType.STORE);
            }
            return i;
        }

        @Override
        public void addBreakpointListener(LongConsumer listener) {
            if (!this.breakpointListeners.contains(listener)) {
                this.breakpointListeners.add(listener);
            }
        }

        @Override
        public void removeBreakpointListener(LongConsumer listener) {
            this.breakpointListeners.remove(listener);
        }

        @Override
        public void addBreakpoint(long address) {
            this.breakpoints.add(address);
            TLBEntry entry = this.tryGetTLBEntry(address, MemoryAccessType.FETCH);
            if (entry != null) {
                if (entry.breakpoints == null) {
                    entry.breakpoints = new LongOpenHashSet();
                }
                entry.breakpoints.add(address);
            }
        }

        @Override
        public void removeBreakpoint(long address) {
            this.breakpoints.remove(address);
            TLBEntry entry = this.tryGetTLBEntry(address, MemoryAccessType.FETCH);
            if (entry != null && entry.breakpoints != null) {
                entry.breakpoints.remove(address);
            }
        }

        private TLBEntry getPageDebug(long address, MemoryAccessType accessType) throws R5MemoryAccessException {
            TLBEntry entry = this.tryGetTLBEntry(address, accessType);
            if (entry != null) {
                return entry;
            }
            long physicalAddress = R5CPUTemplate.this.getPhysicalAddress(address, accessType, true);
            MappedMemoryRange range = R5CPUTemplate.this.physicalMemory.getMemoryRange(physicalAddress);
            if (range == null) {
                throw R5CPUTemplate.getPageFaultException(accessType, address);
            }
            return R5CPUTemplate.updateTLBEntry(new TLBEntry(), address, physicalAddress, range);
        }

        @Nullable
        private TLBEntry tryGetTLBEntry(long address, MemoryAccessType accessType) {
            TLBEntry[] tlb = switch (accessType) {
                default -> throw new IncompatibleClassChangeError();
                case MemoryAccessType.LOAD -> R5CPUTemplate.this.loadTLB;
                case MemoryAccessType.STORE -> R5CPUTemplate.this.storeTLB;
                case MemoryAccessType.FETCH -> R5CPUTemplate.this.fetchTLB;
            };
            int index = (int)(address >>> 12 & 0xFFL);
            long hash = address & 0xFFFFFFFFFFFFF000L;
            TLBEntry entry = tlb[index];
            if (entry.hash == hash) {
                return entry;
            }
            return null;
        }

        private void handleBreakpoint(long pc) {
            for (LongConsumer listener : this.breakpointListeners) {
                listener.accept(pc);
            }
        }
    }

    private static enum MemoryAccessType {
        LOAD(2),
        STORE(4),
        FETCH(8);

        public final int mask;

        private MemoryAccessType(int mask) {
            this.mask = mask;
        }
    }
}

