/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.riscv.R5Instructions;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class R5Disassembler {
    private static final String ILLEGAL_INSTRUCTION = "ILLEGAL";
    private static final String HINT = "HINT";
    private static final int INST_WIDTH = 12;
    private static final String[] REGISTER_NAME = new String[]{"zero", "ra", "sp", "gp", "tp", "t0", "t1", "t2", "s0", "s1", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", "t3", "t4", "t5", "t6"};
    private static final int REG_RA = ArrayUtils.indexOf((Object[])REGISTER_NAME, (Object)"ra");
    private static final Int2ObjectArrayMap<String> CSR_NAME = new Int2ObjectArrayMap(Stream.of({0, "ustatus"}, {4, "uie"}, {5, "utvec"}, {64, "uscratch"}, {65, "uepc"}, {66, "ucause"}, {67, "utval"}, {68, "uip"}, {1, "fflags"}, {2, "frm"}, {3, "fcsr"}, {3072, "cycle"}, {3073, "time"}, {3074, "instret"}, {3200, "cycleh"}, {3201, "timeh"}, {3202, "instreth"}, {256, "sstatus"}, {258, "sedeleg"}, {259, "sideleg"}, {260, "sie"}, {261, "stvec"}, {262, "scountern"}, {320, "sscratch"}, {321, "sepc"}, {322, "scause"}, {323, "stval"}, {324, "sip"}, {384, "satp"}, {1536, "hstatus"}, {1538, "hedeleg"}, {1539, "hideleg"}, {1540, "hie"}, {1542, "hcounteren"}, {1543, "hgeie"}, {1603, "htval"}, {1604, "hip"}, {1605, "hvip"}, {1610, "htinst"}, {3602, "hgeip"}, {1664, "hgatp"}, {1541, "htimedelta"}, {1557, "htimedeltah"}, {512, "vsstatus"}, {516, "vsie"}, {517, "vstvec"}, {576, "vsscratch"}, {577, "vsepc"}, {578, "vscause"}, {579, "vstval"}, {580, "vsip"}, {640, "vsatp"}, {3857, "mvendorid"}, {3858, "marchid"}, {3859, "mimpid"}, {3860, "mhartid"}, {768, "mstatus"}, {769, "misa"}, {770, "medeleg"}, {771, "mideleg"}, {772, "mie"}, {773, "mtvec"}, {774, "mcounteren"}, {784, "mstatush"}, {832, "mscratch"}, {833, "mepc"}, {834, "mcause"}, {835, "mtval"}, {836, "mip"}, {842, "mtinst"}, {843, "mtval2"}, {2816, "mcycle"}, {2818, "minstret"}, {2944, "mcycleh"}, {2946, "minstreth"}, {800, "mcounterhibit"}, {1952, "tselect"}, {1953, "tdata1"}, {1954, "tdata2"}, {1955, "tdata3"}, {1968, "dcsr"}, {1969, "dpc"}, {1970, "dscratch0"}, {1971, "dscratch1"}).collect(Collectors.toMap(kvp -> (Integer)kvp[0], kvp -> (String)kvp[1])));
    private static final Object2IntArrayMap<String> ARGUMENT_INDEX = new Object2IntArrayMap(Stream.of({"rd", 0}, {"rs1", 1}, {"rs2", 2}, {"rs3", 3}, {"shamt", 5}, {"csr", 5}, {"imm", 6}, {"rm", 7}).collect(Collectors.toMap(kvp -> (String)kvp[0], kvp -> (Integer)kvp[1])));
    private static final String[] REGISTER_ARGUMENTS = new String[]{"rd", "rs1", "rs2", "rs3"};
    private static final FormatPattern[] PATTERNS = new FormatPattern[]{new FormatPattern("JAL", "J", "%imm").withFilter("rd", 0), new FormatPattern("JALR", "RET").withFilter("rd", 0).withFilter("rs1", REG_RA).withFilter("imm", 0), new FormatPattern("JALR", "JR", "%rs1").withFilter("rd", 0).withFilter("imm", 0), new FormatPattern("JALR", "JR", "%imm(%rs1)").withFilter("rd", 0), new FormatPattern("JALR", "JALR", "%rs1").withFilter("rd", REG_RA).withFilter("imm", 0), new FormatPattern("ADD", "MV", "%rd, %rs1").withFilter("rs2", 0), new FormatPattern("ADD", "MV", "%rd, %rs2").withFilter("rs1", 0), new FormatPattern("ADDI", "LI", "%rd, %imm").withFilter("rs1", 0), new FormatPattern("ADDI", "MV", "%rd, %rs1").withFilter("imm", 0), new FormatPattern("ADDIW", "SEXT.W", "%rd, %rs1").withFilter("imm", 0), new FormatPattern("XOR", "NOT", "%rd, %rs1").withFilter("rs2", -1), new FormatPattern("BGE", "BGEZ", "%rs1, %imm").withFilter("rs2", 0), new FormatPattern("BNE", "BNEZ", "%rs1, %imm").withFilter("rs2", 0), new FormatPattern("BEQ", "BEQZ", "%rs1, %imm").withFilter("rs2", 0), new FormatPattern("LD", "LD", "%rd, %imm(%rs1)"), new FormatPattern("SD", "SD", "%rs2, %imm(%rs1)"), new FormatPattern("LW", "LW", "%rd, %imm(%rs1)"), new FormatPattern("SW", "SW", "%rs2, %imm(%rs1)"), new FormatPattern("LH", "LH", "%rd, %imm(%rs1)"), new FormatPattern("SH", "SH", "%rs2, %imm(%rs1)"), new FormatPattern("LB", "LB", "%rd, %imm(%rs1)"), new FormatPattern("SB", "SB", "%rs2, %imm(%rs1)")};

    public static String disassemble(int instruction) {
        StringBuffer sb = new StringBuffer();
        InstructionDeclaration declaration = R5Instructions.getDecoderTree().query(instruction);
        if (declaration == null) {
            sb.append(StringUtils.leftPad((String)Integer.toHexString(instruction), (int)8, (char)'0')).append("    ").append(ILLEGAL_INSTRUCTION);
            return sb.toString();
        }
        int instructionMask = (int)((1L << declaration.size * 8) - 1L);
        sb.append(StringUtils.leftPad((String)StringUtils.leftPad((String)Integer.toHexString(instruction & instructionMask), (int)declaration.size, (char)'0'), (int)8)).append("    ");
        switch (declaration.type) {
            case NOP: {
                sb.append(HINT);
                return sb.toString();
            }
            case ILLEGAL: {
                sb.append(ILLEGAL_INSTRUCTION);
                return sb.toString();
            }
        }
        for (FormatPattern pattern : PATTERNS) {
            if (!pattern.matches(instruction, declaration)) continue;
            pattern.format(instruction, declaration, sb);
            return sb.toString();
        }
        sb.append(StringUtils.rightPad((String)declaration.name, (int)12));
        String[] argumentNames = (String[])declaration.arguments.keySet().stream().sorted(Comparator.comparingInt(R5Disassembler::argIndex)).toArray(String[]::new);
        boolean isFirst = true;
        for (String argName : argumentNames) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(R5Disassembler.arg2s(instruction, declaration, argName));
        }
        return sb.toString();
    }

    private static String arg2s(int instruction, InstructionDeclaration declaration, String argName) {
        int argValue = declaration.arguments.get(argName).get(instruction);
        if (ArrayUtils.contains((Object[])REGISTER_ARGUMENTS, (Object)argName)) {
            return R5Disassembler.reg(argValue);
        }
        if ("csr".equals(argName)) {
            return R5Disassembler.csr2n(argValue);
        }
        if (argValue < 0) {
            return String.valueOf(argValue);
        }
        return String.format("0x%x", argValue);
    }

    private static String reg(Object index) {
        if (index instanceof Integer) {
            return REGISTER_NAME[(Integer)index];
        }
        return index.toString();
    }

    private static String csr2n(int csr) {
        if (CSR_NAME.containsKey(csr)) {
            return (String)CSR_NAME.get(csr);
        }
        if (csr >= 3075 && csr <= 3103) {
            return "hpmcounter" + (3 + (csr - 3075));
        }
        if (csr >= 3203 && csr <= 3231) {
            return "hpmcounter" + (3 + (csr - 3075)) + "h";
        }
        if (csr >= 928 && csr <= 943) {
            return "pmpcfg" + (csr - 928);
        }
        if (csr >= 944 && csr <= 1007) {
            return "pmpaddr" + (csr - 944);
        }
        if (csr >= 2819 && csr <= 2847) {
            return "mhpmcounter" + (3 + (csr - 2819));
        }
        if (csr >= 2947 && csr <= 2975) {
            return "mhpmcounter" + (3 + (csr - 2947)) + "h";
        }
        if (csr >= 803 && csr <= 831) {
            return "mhpmevent" + (3 + (csr - 803));
        }
        return String.valueOf(csr);
    }

    private static int argIndex(String argName) {
        if (ARGUMENT_INDEX.containsKey((Object)argName)) {
            return ARGUMENT_INDEX.getInt((Object)argName);
        }
        return Integer.MAX_VALUE;
    }

    private static final class FormatPattern {
        private static final Pattern ARG_PATTERN = Pattern.compile("(%[a-zA-Z0-9]+)");
        private final String instName;
        private final String alias;
        private final String argFormat;
        private final ArrayList<String> args;
        private final ArrayList<ArgFilter> argFilters;

        public FormatPattern(String instName, String alias, String argFormat) {
            this.instName = instName;
            this.alias = alias;
            this.argFormat = argFormat;
            this.args = new ArrayList();
            Matcher matcher = ARG_PATTERN.matcher(argFormat);
            while (matcher.find()) {
                this.args.add(matcher.group().substring(1));
            }
            this.argFilters = new ArrayList();
        }

        public FormatPattern(String instName, String alias) {
            this(instName, alias, "");
        }

        public FormatPattern withFilter(String argName, int argValue) {
            this.argFilters.add(new ArgFilter(argName, argValue));
            return this;
        }

        public boolean matches(int instruction, InstructionDeclaration declaration) {
            if (!Objects.equals(declaration.displayName, this.instName) && !Objects.equals(declaration.name, this.instName)) {
                return false;
            }
            for (String argName : this.args) {
                if (declaration.arguments.containsKey(argName)) continue;
                return false;
            }
            for (ArgFilter filter : this.argFilters) {
                if (filter.matches(instruction, declaration)) continue;
                return false;
            }
            return true;
        }

        public void format(int instruction, InstructionDeclaration declaration, StringBuffer sb) {
            sb.append(StringUtils.rightPad((String)this.alias, (int)12));
            Matcher matcher = ARG_PATTERN.matcher(this.argFormat);
            while (matcher.find()) {
                String argName = matcher.group().substring(1);
                matcher.appendReplacement(sb, R5Disassembler.arg2s(instruction, declaration, argName));
            }
            matcher.appendTail(sb);
        }

        private static final class ArgFilter {
            public final String argName;
            public final int argValue;

            private ArgFilter(String argName, int argValue) {
                this.argName = argName;
                this.argValue = argValue;
            }

            public boolean matches(int instruction, InstructionDeclaration declaration) {
                if (!declaration.arguments.containsKey(this.argName)) {
                    return false;
                }
                return declaration.arguments.get(this.argName).get(instruction) == this.argValue;
            }
        }
    }
}

