/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv.device;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.Interrupt;
import li.cil.sedna.api.device.InterruptController;
import li.cil.sedna.api.device.InterruptSource;
import li.cil.sedna.api.device.MemoryMappedDevice;

@Serialized
public class R5PlatformLevelInterruptController
implements MemoryMappedDevice,
InterruptController,
InterruptSource {
    public static final int INTERRUPT_COUNT = 31;
    private static final int PLIC_PRIORITY_BASE = 4;
    private static final int PLIC_PENDING_BASE = 4096;
    private static final int PLIC_ENABLE_BASE = 8192;
    private static final int PLIC_ENABLE_STRIDE = 128;
    private static final int PLIC_CONTEXT_BASE = 0x200000;
    private static final int PLIC_CONTEXT_STRIDE = 4096;
    private static final int PLIC_LENGTH = 0x4000000;
    private static final int PLIC_SOURCE_COUNT = 32;
    private static final int PLIC_SOURCE_MASK = 31;
    private static final int PLIC_CONTEXT_COUNT = 2;
    private static final int PLIC_MAX_PRIORITY = 7;
    private final transient Interrupt meip = new Interrupt(11);
    private final transient Interrupt seip = new Interrupt(9);
    private final transient Interrupt[] interruptByContext = new Interrupt[]{this.meip, this.seip};
    private final int sourceWords;
    private final int[] priorityBySource = new int[32];
    private final int[] thresholdByContext = new int[2];
    private final AtomicInteger[] pending = new AtomicInteger[this.sourceWords];
    private final AtomicInteger[] claimed;
    private final int[] enabled;

    public R5PlatformLevelInterruptController() {
        int i;
        this.sourceWords = 1;
        for (i = 0; i < this.sourceWords; ++i) {
            this.pending[i] = new AtomicInteger(0);
        }
        this.claimed = new AtomicInteger[this.sourceWords];
        for (i = 0; i < this.sourceWords; ++i) {
            this.claimed[i] = new AtomicInteger(0);
        }
        this.enabled = new int[this.sourceWords * 2];
    }

    public void setHart(InterruptController interruptController) {
        for (Interrupt interrupt : this.interruptByContext) {
            interrupt.controller = interruptController;
        }
    }

    @Override
    public int getLength() {
        return 0x4000000;
    }

    @Override
    public int getSupportedSizes() {
        return 4;
    }

    @Override
    public long load(int offset, int sizeLog2) {
        if (sizeLog2 != 2) {
            return 0L;
        }
        if (offset >= 4 && offset < 132) {
            int source = (offset - 4 >> 2) + 1;
            return this.priorityBySource[source];
        }
        if (offset >= 4096 && offset < 4096 + this.sourceWords) {
            int word = offset - 4096 >> 2;
            return this.pending[word].get();
        }
        if (offset >= 8192 && offset < 8448) {
            int context = (offset - 8192) / 128;
            int contextOffset = offset & 0x7F;
            int word = contextOffset >>> 2;
            if (word < this.sourceWords) {
                return this.enabled[context * this.sourceWords + word];
            }
            return 0L;
        }
        if (offset >= 0x200000 && offset < 0x202000) {
            int context = (offset - 0x200000) / 4096;
            int contextOffset = offset & 0xFFF;
            if (contextOffset == 0) {
                return this.thresholdByContext[context];
            }
            if (contextOffset == 4) {
                int value = this.claim(context);
                this.updateInterrupts();
                return value;
            }
            return 0L;
        }
        return 0L;
    }

    @Override
    public void store(int offset, long value, int sizeLog2) {
        if (sizeLog2 != 2) {
            return;
        }
        int intValue = (int)value;
        if (offset >= 4 && offset < 132) {
            int source = (offset - 4 >> 2) + 1;
            this.priorityBySource[source] = intValue & 7;
            this.updateInterrupts();
        } else if (offset >= 8192 && offset < 8448) {
            int context = (offset - 8192) / 128;
            int contextOffset = offset & 0x7F;
            int word = contextOffset >>> 2;
            if (word < this.sourceWords) {
                this.enabled[context * this.sourceWords + word] = intValue;
            }
        } else if (offset >= 0x200000 && offset < 0x202000) {
            int context = (offset - 0x200000) / 4096;
            int contextOffset = offset & 0xFFF;
            if (contextOffset == 0) {
                if (Integer.compareUnsigned(intValue, 7) <= 0) {
                    this.thresholdByContext[context] = intValue;
                    this.updateInterrupts();
                }
            } else if (contextOffset == 4 && Integer.compareUnsigned(intValue, 32) < 0) {
                this.setClaimed(intValue, false);
                this.updateInterrupts();
            }
        }
    }

    @Override
    public void raiseInterrupts(int mask) {
        int i = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                this.setPending(i, true);
            }
            ++i;
            mask >>>= 1;
        }
        this.updateInterrupts();
    }

    @Override
    public void lowerInterrupts(int mask) {
        int i = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                this.setPending(i, false);
            }
            ++i;
            mask >>>= 1;
        }
        this.updateInterrupts();
    }

    @Override
    public int getRaisedInterrupts() {
        return this.pending[0].get();
    }

    @Override
    public Iterable<Interrupt> getInterrupts() {
        return Arrays.asList(this.interruptByContext);
    }

    private boolean hasPending(int context) {
        for (int i = 0; i < this.sourceWords; ++i) {
            int unclaimed = this.pending[i].get() & ~this.claimed[i].get() & this.enabled[context * this.sourceWords + i];
            if (unclaimed == 0) continue;
            for (int j = 0; j < 32; ++j) {
                boolean enabled;
                int source = i * 32 + j;
                int priority = this.priorityBySource[source];
                boolean bl = enabled = (unclaimed & 1 << j) != 0;
                if (!enabled || priority <= this.thresholdByContext[context]) continue;
                return true;
            }
        }
        return false;
    }

    private void setPending(int source, boolean value) {
        int word = source >>> 5;
        int mask = 1 << (source & 0x1F);
        if (value) {
            this.pending[word].updateAndGet(operand -> operand |= mask);
        } else {
            this.pending[word].updateAndGet(operand -> operand &= ~mask);
        }
    }

    private int claim(int context) {
        int maxSource = 0;
        int maxPriority = this.thresholdByContext[context];
        for (int i = 0; i < this.sourceWords; ++i) {
            int unclaimed = this.pending[i].get() & ~this.claimed[i].get() & this.enabled[context * this.sourceWords + i];
            if (unclaimed == 0) continue;
            for (int j = 0; j < 32; ++j) {
                boolean enabled;
                int source = i * 32 + j;
                int priority = this.priorityBySource[source];
                boolean bl = enabled = (unclaimed & 1 << j) != 0;
                if (!enabled || priority <= maxPriority) continue;
                maxSource = source;
                maxPriority = priority;
            }
        }
        if (maxSource > 0) {
            this.setPending(maxSource, false);
            this.setClaimed(maxSource, true);
        }
        return maxSource;
    }

    private void setClaimed(int source, boolean value) {
        int word = source >>> 5;
        int mask = 1 << (source & 0x1F);
        if (value) {
            this.claimed[word].updateAndGet(operand -> operand |= mask);
        } else {
            this.claimed[word].updateAndGet(operand -> operand &= ~mask);
        }
    }

    private void updateInterrupts() {
        for (int context = 0; context < 2; ++context) {
            if (this.hasPending(context)) {
                this.interruptByContext[context].raiseInterrupt();
                continue;
            }
            this.interruptByContext[context].lowerInterrupt();
        }
    }
}

