/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import li.cil.oc2r.client.gui.KeyCodeMapping;
import li.cil.oc2r.common.blockentity.KeyboardBlockEntity;
import li.cil.oc2r.common.item.Items;
import li.cil.oc2r.common.network.Network;
import li.cil.oc2r.common.network.message.KeyboardInputMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public final class KeyboardScreen
extends Screen {
    private static final int BORDER_SIZE = 4;
    private static final float ARM_SWING_RATE = 0.8f;
    private static final int BORDER_COLOR = -1;
    private static final MutableComponent CLOSE_INFO = Component.m_237115_((String)"gui.oc2r.keyboard.close_info");
    private final KeyboardBlockEntity keyboard;
    public static boolean hideHotbar = false;

    public KeyboardScreen(KeyboardBlockEntity keyboard) {
        super(((Item)Items.KEYBOARD.get()).m_41466_());
        this.keyboard = keyboard;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.grabMouse();
        hideHotbar = true;
    }

    public void m_86600_() {
        super.m_86600_();
        Vec3 keyboardCenter = Vec3.m_82512_((Vec3i)this.keyboard.m_58899_());
        if (!this.keyboard.isValid() || this.getMinecraft().f_91074_ == null || this.getMinecraft().f_91074_.m_20238_(keyboardCenter) > 64.0) {
            this.m_7379_();
        }
    }

    public boolean m_7933_(int keycode, int scancode, int modifiers) {
        this.sendInputMessage(keycode, true);
        return true;
    }

    public boolean m_7920_(int keycode, int scancode, int modifiers) {
        this.sendInputMessage(keycode, false);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderBorderOverlay(graphics);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280554_(this.f_96547_, (FormattedText)CLOSE_INFO, 12, this.f_96544_ - 12 - 9, this.f_96543_ - 24, -1996488705);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        hideHotbar = false;
    }

    private void renderBorderOverlay(GuiGraphics graphics) {
        this.blitQuad(graphics, 4, 4, this.f_96543_ - 4, 8, -1);
        this.blitQuad(graphics, 4, 4, 8, this.f_96544_ - 4, -1);
        this.blitQuad(graphics, 4, this.f_96544_ - 8, this.f_96543_ - 4, this.f_96544_ - 4, -1);
        this.blitQuad(graphics, this.f_96543_ - 8, 4, this.f_96543_ - 4, this.f_96544_ - 4, -1);
    }

    private void blitQuad(GuiGraphics graphics, int x0, int y0, int x1, int y1, int color) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x0, (float)y1, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x1, (float)y1, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x1, (float)y0, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x0, (float)y0, 0.0f).m_193479_(color).m_5752_();
        tesselator.m_85914_();
    }

    private void grabMouse() {
        Minecraft minecraft = this.getMinecraft();
        MouseHandler mouseHandler = minecraft.f_91067_;
        mouseHandler.f_91520_ = true;
        InputConstants.m_84833_((long)minecraft.m_91268_().m_85439_(), (int)212995, (double)mouseHandler.m_91589_(), (double)mouseHandler.m_91594_());
    }

    private void sendInputMessage(int keycode, boolean isDown) {
        if (KeyCodeMapping.MAPPING.containsKey(keycode)) {
            this.swingArm();
            int evdevCode = KeyCodeMapping.MAPPING.get(keycode);
            Network.sendToServer(new KeyboardInputMessage(this.keyboard, evdevCode, isDown));
        }
    }

    private void swingArm() {
        Minecraft minecraft = this.getMinecraft();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        RandomSource random = player.m_217043_();
        if (random.m_188501_() < 0.8f) {
            return;
        }
        InteractionHand handToSwing = minecraft.f_91066_.m_92176_().m_90612_() ? InteractionHand.MAIN_HAND : (random.m_188499_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        player.m_6674_(handToSwing);
    }
}

