/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2r.client.gui.AbstractMachineTerminalScreen;
import li.cil.oc2r.client.gui.AbstractMonitorDisplayScreen;
import li.cil.oc2r.client.gui.KeyCodeMapping;
import li.cil.oc2r.client.gui.Sprites;
import li.cil.oc2r.client.renderer.MonitorGUIRenderer;
import li.cil.oc2r.common.container.AbstractMonitorContainer;
import li.cil.oc2r.common.network.Network;
import li.cil.oc2r.common.network.message.MonitorInputMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class MonitorDisplayWidget {
    private static final int TERMINAL_WIDTH = 320;
    private static final int TERMINAL_HEIGHT = 192;
    private static final int MARGIN_SIZE = 8;
    private static final int TERMINAL_X = 8;
    private static final int TERMINAL_Y = 8;
    public static final int WIDTH = Sprites.MONITOR_SCREEN.width;
    public static final int HEIGHT = Sprites.MONITOR_SCREEN.height;
    private final AbstractMonitorDisplayScreen<?> parent;
    private final AbstractMonitorContainer container;
    private int leftPos;
    private int topPos;
    private boolean isMouseOverTerminal;
    private MonitorGUIRenderer.RendererView rendererView;

    public MonitorDisplayWidget(AbstractMonitorDisplayScreen<?> parent) {
        this.parent = parent;
        this.container = (AbstractMonitorContainer)this.parent.m_6262_();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.isMouseOverTerminal = this.isMouseOverTerminal(mouseX, mouseY);
        Sprites.MONITOR_SCREEN.draw(graphics, this.leftPos, this.topPos);
        if (this.shouldCaptureInput()) {
            Sprites.TERMINAL_FOCUSED.draw(graphics, this.leftPos, this.topPos);
        }
    }

    public void render(GuiGraphics graphics, @Nullable Component error) {
        if (this.container.getPowerState() && this.container.isMounted() && this.container.hasPower()) {
            PoseStack terminalStack = new PoseStack();
            terminalStack.m_252880_((float)(this.leftPos + 8), (float)(this.topPos + 8), 0.0f);
            terminalStack.m_85841_(((float)Sprites.MONITOR_SCREEN.width - 16.0f) / 640.0f, ((float)Sprites.MONITOR_SCREEN.height - 16.0f) / 480.0f, 1.0f);
            if (this.rendererView == null) {
                this.rendererView = this.container.getMonitor().getMonitor().getRenderer(this.container.getMonitor());
            }
            Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)this.parent.f_96543_, (float)this.parent.f_96544_, 0.0f, -10.0f, 10.0f);
            this.rendererView.render(terminalStack, projectionMatrix, 640.0f, 480.0f);
        } else if (this.container.getPowerState()) {
            Font font = this.getClient().f_91062_;
            if (error != null) {
                int textWidth = font.m_92852_((FormattedText)error);
                int textOffsetX = (Sprites.MONITOR_SCREEN.width - textWidth) / 2;
                int n = Sprites.MONITOR_SCREEN.height;
                Objects.requireNonNull(font);
                int textOffsetY = (n - 9) / 2;
                this.drawShadow(font, graphics, error, this.leftPos + textOffsetX, this.topPos + textOffsetY, 0xEE3322);
            }
        }
    }

    private void drawShadow(Font font, GuiGraphics graphics, Component text, float x, float y, int color) {
        MultiBufferSource.BufferSource batch = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272077_(text, x, y, color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)batch, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        batch.m_109911_();
    }

    public void tick() {
    }

    public void init() {
        this.leftPos = (this.parent.f_96543_ - WIDTH) / 2;
        this.topPos = (this.parent.f_96544_ - HEIGHT) / 2;
    }

    public void onClose() {
        if (this.rendererView != null) {
            this.rendererView = null;
        }
    }

    public boolean keyPressed(int keycode, int scancode, int modifiers) {
        if (keycode == 256 && !this.shouldCaptureInput()) {
            return false;
        }
        this.sendInputMessage(keycode, true);
        return true;
    }

    public boolean keyReleased(int keycode, int scancode, int modifiers) {
        if (keycode == 256 && !this.shouldCaptureInput()) {
            return false;
        }
        this.sendInputMessage(keycode, false);
        return true;
    }

    private void sendInputMessage(int keycode, boolean isDown) {
        if (KeyCodeMapping.MAPPING.containsKey(keycode)) {
            int evdevCode = KeyCodeMapping.MAPPING.get(keycode);
            Network.sendToServer(new MonitorInputMessage(this.container.getMonitor(), evdevCode, isDown));
        }
    }

    private Minecraft getClient() {
        return this.parent.getMinecraft();
    }

    private boolean shouldCaptureInput() {
        return this.isMouseOverTerminal && AbstractMachineTerminalScreen.isInputCaptureEnabled();
    }

    private boolean isMouseOverTerminal(int mouseX, int mouseY) {
        return this.parent.isMouseOver(mouseX, mouseY, 8, 8, 320, 192);
    }
}

