/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.client.renderer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import li.cil.oc2r.client.renderer.ModShaders;
import li.cil.oc2r.common.block.ProjectorBlock;
import li.cil.oc2r.common.blockentity.ProjectorBlockEntity;
import li.cil.oc2r.common.ext.MinecraftExt;
import li.cil.oc2r.common.util.FakePlayerUtils;
import li.cil.oc2r.jcodec.common.model.Picture;
import li.cil.oc2r.jcodec.scale.Yuv420jToRgb;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public final class ProjectorDepthRenderer {
    private static final int DEPTH_CAPTURE_SIZE = 256;
    private static final List<ProjectorBlockEntity> VISIBLE_PROJECTORS = new ArrayList<ProjectorBlockEntity>();
    private static final DepthOnlyRenderTarget[] PROJECTOR_DEPTH_TARGETS = new DepthOnlyRenderTarget[3];
    private static final DynamicTexture[] PROJECTOR_COLOR_TARGETS = new DynamicTexture[3];
    private static final Matrix4f[] PROJECTOR_CAMERA_MATRICES = new Matrix4f[3];
    private static final Camera PROJECTOR_DEPTH_CAMERA = new Camera();
    private static DepthOnlyRenderTarget MAIN_CAMERA_DEPTH = new DepthOnlyRenderTarget(854, 480);
    private static final float PROJECTOR_FORWARD_SHIFT = 0.4375f;
    private static final float PROJECTOR_NEAR = 0.0625f;
    private static final float PROJECTOR_FAR = 16.0f;
    private static final int FRUSTUM_WIDTH = 6;
    private static final int FRUSTUM_HEIGHT = 9;
    private static final Matrix4f DEPTH_CAMERA_PROJECTION_MATRIX = new Matrix4f().frustum(-ProjectorDepthRenderer.calculateFrustumComponent(6.0f), ProjectorDepthRenderer.calculateFrustumComponent(6.0f), 0.0f, ProjectorDepthRenderer.calculateFrustumComponent(9.0f), 0.0625f, 16.0f);
    private static final Cache<ProjectorBlockEntity, RenderInfo> RENDER_INFO = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(5L)).removalListener(ProjectorDepthRenderer::handleProjectorNoLongerRendering).build();
    private static boolean isRenderingProjectorDepth;
    private static HitResult hitResultBak;
    private static boolean entityShadowsBak;
    private static Entity minecraftCameraEntityBak;
    private static Camera gameRendererMainCameraBak;

    private static float calculateFrustumComponent(float originalValue) {
        return originalValue / 16.0f / 12.0f;
    }

    private static void handleProjectorNoLongerRendering(RemovalNotification<ProjectorBlockEntity, RenderInfo> notification) {
        RenderInfo renderInfo;
        ProjectorBlockEntity projector = (ProjectorBlockEntity)notification.getKey();
        if (projector != null) {
            projector.setFrameConsumer(null);
        }
        if ((renderInfo = (RenderInfo)notification.getValue()) != null) {
            renderInfo.close();
        }
    }

    public static void addProjector(ProjectorBlockEntity projector) {
        VISIBLE_PROJECTORS.add(projector);
    }

    public static boolean willRenderProjectorDepth() {
        return !VISIBLE_PROJECTORS.isEmpty();
    }

    public static boolean isIsRenderingProjectorDepth() {
        return isRenderingProjectorDepth;
    }

    public static void captureMainCameraDepth() {
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        if (mainRenderTarget.f_83915_ != ProjectorDepthRenderer.MAIN_CAMERA_DEPTH.f_83915_ || mainRenderTarget.f_83916_ != ProjectorDepthRenderer.MAIN_CAMERA_DEPTH.f_83916_) {
            MAIN_CAMERA_DEPTH.m_83941_(mainRenderTarget.f_83915_, mainRenderTarget.f_83916_, Minecraft.f_91002_);
        }
        if (mainRenderTarget.isStencilEnabled()) {
            MAIN_CAMERA_DEPTH.enableStencil();
        } else if (MAIN_CAMERA_DEPTH.isStencilEnabled()) {
            MAIN_CAMERA_DEPTH.m_83930_();
            MAIN_CAMERA_DEPTH = new DepthOnlyRenderTarget(mainRenderTarget.f_83915_, mainRenderTarget.f_83916_);
        }
        MAIN_CAMERA_DEPTH.m_83945_(mainRenderTarget);
        mainRenderTarget.m_83947_(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void renderProjectors(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            return;
        }
        if (VISIBLE_PROJECTORS.isEmpty()) {
            return;
        }
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            LocalPlayer player = minecraft.f_91074_;
            if (level == null || player == null) {
                return;
            }
            VISIBLE_PROJECTORS.sort((projector1, projector2) -> {
                double distance1 = player.m_20238_(Vec3.m_82512_((Vec3i)projector1.m_58899_()));
                double distance2 = player.m_20238_(Vec3.m_82512_((Vec3i)projector2.m_58899_()));
                return Double.compare(distance1, distance2);
            });
            int projectorCount = Math.min(VISIBLE_PROJECTORS.size(), 3);
            ProjectorDepthRenderer.renderProjectorDepths(minecraft, level, event.getPartialTick(), projectorCount);
            ProjectorDepthRenderer.renderProjectorColors(minecraft, event.getPoseStack().m_85850_().m_252922_(), event.getProjectionMatrix(), projectorCount);
        }
        finally {
            VISIBLE_PROJECTORS.clear();
            Arrays.fill(PROJECTOR_COLOR_TARGETS, null);
        }
    }

    @SubscribeEvent
    public static void handleFog(EntityRenderersEvent event) {
        if (isRenderingProjectorDepth) {
            FogRenderer.m_109017_();
        }
    }

    @SubscribeEvent
    public static void handleNameplate(RenderNameTagEvent event) {
        if (isRenderingProjectorDepth) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void handleClientTick(TickEvent.ClientTickEvent event) {
        RENDER_INFO.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderProjectorDepths(Minecraft minecraft, ClientLevel level, float partialTicks, int projectorCount) {
        Vec3 mainCameraPosition = minecraft.f_91063_.m_109153_().m_90583_();
        ProjectorDepthRenderer.prepareDepthBufferRendering(minecraft, level, partialTicks);
        try {
            PoseStack viewModelStack = new PoseStack();
            for (int projectorIndex = 0; projectorIndex < projectorCount; ++projectorIndex) {
                ProjectorBlockEntity projector = VISIBLE_PROJECTORS.get(projectorIndex);
                Direction facing = (Direction)projector.m_58900_().m_61143_((Property)ProjectorBlock.f_54117_);
                Vec3 projectorPos = Vec3.m_82512_((Vec3i)projector.m_58899_()).m_82549_(new Vec3(facing.m_253071_()).m_82490_(0.4375));
                ProjectorDepthRenderer.configureProjectorDepthCamera(level, projectorPos, facing.m_122435_());
                RenderSystem.setProjectionMatrix((Matrix4f)DEPTH_CAMERA_PROJECTION_MATRIX, (VertexSorting)VertexSorting.f_276450_);
                ProjectorDepthRenderer.setupViewModelMatrix(viewModelStack);
                ProjectorDepthRenderer.storeProjectorMatrix(projectorIndex, projectorPos, mainCameraPosition, viewModelStack);
                ProjectorDepthRenderer.bindProjectorDepthRenderTarget(projectorIndex, minecraft);
                ProjectorDepthRenderer.renderProjectorDepthBuffer(minecraft, partialTicks, viewModelStack);
                ProjectorDepthRenderer.storeProjectorColorBuffer(projectorIndex, projector);
                projector.onRendering();
            }
        }
        finally {
            ProjectorDepthRenderer.finishDepthBufferRendering(minecraft);
        }
    }

    private static void prepareDepthBufferRendering(Minecraft minecraft, ClientLevel level, float partialTicks) {
        isRenderingProjectorDepth = true;
        hitResultBak = minecraft.f_91077_;
        minecraft.f_91077_ = null;
        entityShadowsBak = (Boolean)minecraft.f_91066_.m_231818_().m_231551_();
        minecraft.f_91066_.m_231818_().m_231514_((Object)false);
        minecraftCameraEntityBak = minecraft.m_91288_();
        minecraft.m_91118_((Entity)ProjectorCameraEntity.get((Level)level, Vec3.f_82478_, partialTicks));
        gameRendererMainCameraBak = minecraft.f_91063_.f_109054_;
        minecraft.f_91063_.f_109054_ = PROJECTOR_DEPTH_CAMERA;
        RenderSystem.backupProjectionMatrix();
    }

    private static void finishDepthBufferRendering(Minecraft minecraft) {
        minecraft.f_91077_ = hitResultBak;
        minecraft.f_91066_.m_231818_().m_231514_((Object)entityShadowsBak);
        RenderSystem.restoreProjectionMatrix();
        ((MinecraftExt)minecraft).setMainRenderTargetOverride(null);
        minecraft.m_91385_().m_83947_(true);
        minecraft.m_91118_(minecraftCameraEntityBak);
        minecraft.f_91063_.f_109054_ = gameRendererMainCameraBak;
        isRenderingProjectorDepth = false;
    }

    private static void configureProjectorDepthCamera(ClientLevel level, Vec3 pos, float rotationY) {
        PROJECTOR_DEPTH_CAMERA.m_90575_((BlockGetter)level, (Entity)ProjectorCameraEntity.get((Level)level, pos, rotationY), false, false, 0.0f);
    }

    private static void setupViewModelMatrix(PoseStack viewModelStack) {
        viewModelStack.m_166856_();
        viewModelStack.m_252781_(Axis.f_252436_.m_252977_(PROJECTOR_DEPTH_CAMERA.m_90590_() + 180.0f));
        Matrix3f viewRotationMatrix = new Matrix3f((Matrix3fc)viewModelStack.m_85850_().m_252943_());
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)viewRotationMatrix.invert());
    }

    private static void storeProjectorMatrix(int projectorIndex, Vec3 projectorPos, Vec3 mainCameraPosition, PoseStack viewModelStack) {
        ProjectorDepthRenderer.PROJECTOR_CAMERA_MATRICES[projectorIndex] = new Matrix4f((Matrix4fc)DEPTH_CAMERA_PROJECTION_MATRIX);
        viewModelStack.m_85836_();
        viewModelStack.m_85837_(mainCameraPosition.m_7096_() - projectorPos.m_7096_(), mainCameraPosition.m_7098_() - projectorPos.m_7098_(), mainCameraPosition.m_7094_() - projectorPos.m_7094_());
        PROJECTOR_CAMERA_MATRICES[projectorIndex].mul((Matrix4fc)viewModelStack.m_85850_().m_252922_());
        viewModelStack.m_85849_();
    }

    private static void bindProjectorDepthRenderTarget(int projectorIndex, Minecraft minecraft) {
        DepthOnlyRenderTarget projectorDepthTarget = PROJECTOR_DEPTH_TARGETS[projectorIndex];
        projectorDepthTarget.m_83947_(true);
        ((MinecraftExt)minecraft).setMainRenderTargetOverride((RenderTarget)projectorDepthTarget);
    }

    private static void renderProjectorDepthBuffer(Minecraft minecraft, float partialTicks, PoseStack viewModelStack) {
        LevelRenderer levelRenderer = minecraft.f_91060_;
        levelRenderer.m_253210_(viewModelStack, PROJECTOR_DEPTH_CAMERA.m_90583_(), DEPTH_CAMERA_PROJECTION_MATRIX);
        levelRenderer.m_109599_(viewModelStack, partialTicks, 0L, false, PROJECTOR_DEPTH_CAMERA, minecraft.f_91063_, minecraft.f_91063_.m_109154_(), DEPTH_CAMERA_PROJECTION_MATRIX);
    }

    private static void storeProjectorColorBuffer(int projectorIndex, ProjectorBlockEntity projector) {
        ProjectorDepthRenderer.PROJECTOR_COLOR_TARGETS[projectorIndex] = ProjectorDepthRenderer.getColorBuffer(projector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderProjectorColors(Minecraft minecraft, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, int projectorCount) {
        ProjectorDepthRenderer.prepareColorBufferRendering();
        try {
            ProjectorDepthRenderer.prepareOrthographicRendering(minecraft);
            RenderSystem.setShader(ModShaders::getProjectorsShader);
            ModShaders.configureProjectorsShader((RenderTarget)MAIN_CAMERA_DEPTH, ProjectorDepthRenderer.constructInverseMainCameraMatrix(modelViewMatrix, projectionMatrix), PROJECTOR_COLOR_TARGETS, (RenderTarget[])PROJECTOR_DEPTH_TARGETS, PROJECTOR_CAMERA_MATRICES, projectorCount);
            ProjectorDepthRenderer.renderIntoScreenRect();
        }
        finally {
            ProjectorDepthRenderer.finishColorBufferRendering();
        }
    }

    private static void prepareColorBufferRendering() {
        RenderSystem.backupProjectionMatrix();
        RenderSystem.getModelViewStack().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }

    private static void finishColorBufferRendering() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void prepareOrthographicRendering(Minecraft minecraft) {
        Matrix4f screenProjectionMatrix = new Matrix4f().setOrtho(0.0f, (float)minecraft.m_91268_().m_85441_(), (float)minecraft.m_91268_().m_85442_(), 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)screenProjectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_166856_();
        modelViewStack.m_252880_(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
    }

    private static Matrix4f constructInverseMainCameraMatrix(Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        Matrix4f inverseModelViewMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        inverseModelViewMatrix.mul((Matrix4fc)modelViewMatrix);
        inverseModelViewMatrix.invert();
        return inverseModelViewMatrix;
    }

    private static void renderIntoScreenRect() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_5483_(0.0, (double)ProjectorDepthRenderer.MAIN_CAMERA_DEPTH.f_83916_, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_5483_((double)ProjectorDepthRenderer.MAIN_CAMERA_DEPTH.f_83915_, (double)ProjectorDepthRenderer.MAIN_CAMERA_DEPTH.f_83916_, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)ProjectorDepthRenderer.MAIN_CAMERA_DEPTH.f_83915_, 0.0, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
    }

    private static DynamicTexture getColorBuffer(ProjectorBlockEntity projector) {
        try {
            return ((RenderInfo)RENDER_INFO.get((Object)projector, () -> {
                DynamicTexture texture = new DynamicTexture(640, 480, false);
                texture.m_117985_();
                RenderInfo renderInfo = new RenderInfo(texture);
                projector.setFrameConsumer(renderInfo);
                return renderInfo;
            })).texture();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            ProjectorDepthRenderer.PROJECTOR_DEPTH_TARGETS[i] = new DepthOnlyRenderTarget(256, 256);
            ProjectorDepthRenderer.PROJECTOR_CAMERA_MATRICES[i] = new Matrix4f();
        }
    }

    private record RenderInfo(DynamicTexture texture) implements ProjectorBlockEntity.FrameConsumer
    {
        private static final ThreadLocal<byte[]> RGB = ThreadLocal.withInitial(() -> new byte[3]);

        public synchronized void close() {
            this.texture.close();
        }

        @Override
        public synchronized void processFrame(Picture picture) {
            NativeImage image = this.texture.m_117991_();
            if (image == null) {
                return;
            }
            byte[] y = picture.getPlaneData(0);
            byte[] u = picture.getPlaneData(1);
            byte[] v = picture.getPlaneData(2);
            int lumaIndex = 0;
            int chromaIndex = 0;
            int halfRow = 0;
            while (halfRow < 240) {
                int row = halfRow * 2;
                int halfCol = 0;
                while (halfCol < 320) {
                    int col = halfCol * 2;
                    int yIndex = lumaIndex + col;
                    byte cb = u[chromaIndex];
                    byte cr = v[chromaIndex];
                    RenderInfo.setFromYUV420(image, col, row, y[yIndex], cb, cr);
                    RenderInfo.setFromYUV420(image, col + 1, row, y[yIndex + 1], cb, cr);
                    RenderInfo.setFromYUV420(image, col, row + 1, y[yIndex + 640], cb, cr);
                    RenderInfo.setFromYUV420(image, col + 1, row + 1, y[yIndex + 640 + 1], cb, cr);
                    ++halfCol;
                    ++chromaIndex;
                }
                ++halfRow;
                lumaIndex += 1280;
            }
            this.texture.m_117985_();
        }

        private static void setFromYUV420(NativeImage image, int col, int row, byte y, byte cb, byte cr) {
            byte[] bytes = RGB.get();
            Yuv420jToRgb.YUVJtoRGB(y, cb, cr, bytes, 0);
            int r = bytes[0] + 128;
            int g = bytes[1] + 128;
            int b = bytes[2] + 128;
            image.m_84988_(col, row, r | g << 8 | b << 16 | 0xFF000000);
        }
    }

    private static final class DepthOnlyRenderTarget
    extends TextureTarget {
        public DepthOnlyRenderTarget(int width, int height) {
            super(width, height, true, Minecraft.f_91002_);
        }

        public void m_83950_(int width, int height, boolean isOnOSX) {
            super.m_83950_(width, height, isOnOSX);
            if (this.f_83923_ > -1) {
                if (this.f_83920_ > -1) {
                    GL30.glBindFramebuffer((int)36160, (int)this.f_83920_);
                    GL11.glDrawBuffer((int)0);
                    GL30.glBindFramebuffer((int)36160, (int)0);
                }
                TextureUtil.releaseTextureId((int)this.f_83923_);
                this.f_83923_ = -1;
            }
        }
    }

    private static final class ProjectorCameraEntity
    extends Player {
        private static ProjectorCameraEntity instance;

        public static ProjectorCameraEntity get(Level level, Vec3 pos, float rotationY) {
            if (instance == null) {
                instance = new ProjectorCameraEntity(level, BlockPos.f_121853_, rotationY);
            }
            instance.m_284535_(level);
            instance.m_7678_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), rotationY, 0.0f);
            return instance;
        }

        private ProjectorCameraEntity(Level level, BlockPos blockPos, float rotationY) {
            super(level, blockPos, rotationY, FakePlayerUtils.getFakePlayerProfile());
        }

        public float m_5675_(float partialTicks) {
            return this.f_19859_;
        }

        public float m_5686_(float partialTicks) {
            return this.f_19860_;
        }

        public boolean m_5833_() {
            return false;
        }

        public boolean m_7500_() {
            return true;
        }
    }
}

