/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import li.cil.oc2r.client.renderer.ModRenderType;
import li.cil.oc2r.common.blockentity.ChargerBlockEntity;
import li.cil.oc2r.common.util.ChainableVertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public final class ChargerRenderer
implements BlockEntityRenderer<ChargerBlockEntity> {
    public static final ResourceLocation EFFECT_LOCATION = new ResourceLocation("oc2r", "block/charger/effect");
    private static final Material TEXTURE_EFFECT = new Material(InventoryMenu.f_39692_, EFFECT_LOCATION);
    private static final int EFFECT_LAYERS = 3;
    private static final float EFFECT_HEIGHT = 0.5f;
    private static final float EFFECT_SPEED = 0.1f;
    private static final float EFFECT_SCALE_START = 0.6f;
    private static final float EFFECT_SCALE_END = 0.8f;
    private float offset = 0.0f;

    public ChargerRenderer(BlockEntityRendererProvider.Context ignoredContext) {
    }

    public void render(ChargerBlockEntity charger, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        this.offset = (this.offset + 0.1f * partialTicks / 20.0f) % ((float)Math.PI * 2);
        stack.m_85836_();
        stack.m_85837_(0.5, 1.1, 0.5);
        VertexConsumer consumer = TEXTURE_EFFECT.m_119194_(bufferSource, ModRenderType::getUnlitBlock);
        for (int i = 0; i < 3; ++i) {
            float relativeY = (1.0f + Mth.m_14031_((float)(this.offset + (float)Math.PI * 2 * (float)i / 3.0f))) * 0.5f;
            float y = relativeY * 0.5f;
            float scale = 0.6f + relativeY * 0.19999999f;
            stack.m_85836_();
            stack.m_252880_(0.0f, y, 0.0f);
            ChargerRenderer.renderScaledQuad(stack, consumer, scale);
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    private static void renderScaledQuad(PoseStack stack, VertexConsumer consumer, float scale) {
        stack.m_85836_();
        stack.m_85841_(scale, scale, scale);
        ChargerRenderer.renderQuad(stack.m_85850_().m_252922_(), consumer);
        stack.m_85849_();
    }

    private static void renderQuad(Matrix4f matrix, VertexConsumer consumer) {
        ChainableVertexConsumer wrapper = new ChainableVertexConsumer(consumer);
        wrapper.m_252986_(matrix, -0.5f, 0.0f, -0.5f).m_7421_(0.0f, 0.0f).m_5752_();
        wrapper.m_252986_(matrix, -0.5f, 0.0f, 0.5f).m_7421_(0.0f, 1.0f).m_5752_();
        wrapper.m_252986_(matrix, 0.5f, 0.0f, 0.5f).m_7421_(1.0f, 1.0f).m_5752_();
        wrapper.m_252986_(matrix, 0.5f, 0.0f, -0.5f).m_7421_(1.0f, 0.0f).m_5752_();
    }
}

