/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.block;

import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2r.common.blockentity.BlockEntities;
import li.cil.oc2r.common.blockentity.NetworkConnectorBlockEntity;
import li.cil.oc2r.common.blockentity.TickableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class NetworkConnectorBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    private static final VoxelShape NEG_Z_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0, (double)16.0);
    private static final VoxelShape POS_Z_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)9.0);
    private static final VoxelShape NEG_X_SHAPE = Block.m_49796_((double)7.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    private static final VoxelShape POS_X_SHAPE = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0);
    private static final VoxelShape NEG_Y_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private static final VoxelShape POS_Y_SHAPE = Block.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public NetworkConnectorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
    }

    public static Direction getFacing(BlockState state) {
        return FaceAttachedHorizontalDirectionalBlock.m_53200_((BlockState)state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block changedBlock, BlockPos changedBlockPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (Objects.equals(changedBlockPos, pos.m_121945_(NetworkConnectorBlock.getFacing(state).m_122424_())) && (blockEntity = level.m_7702_(pos)) instanceof NetworkConnectorBlockEntity) {
            NetworkConnectorBlockEntity networkConnector = (NetworkConnectorBlockEntity)blockEntity;
            networkConnector.setNeighborChanged();
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        yield POS_X_SHAPE;
                    }
                    case WEST: {
                        yield NEG_X_SHAPE;
                    }
                    case SOUTH: {
                        yield POS_Z_SHAPE;
                    }
                }
                yield NEG_Z_SHAPE;
            }
            case AttachFace.CEILING -> POS_Y_SHAPE;
            default -> NEG_Y_SHAPE;
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.NETWORK_CONNECTOR.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickableBlockEntity.createServerTicker(level, type, (BlockEntityType)BlockEntities.NETWORK_CONNECTOR.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_53179_, f_54117_});
    }
}

