/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.blockentity;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2r.common.util.LazyOptionalUtils;
import li.cil.oc2r.common.util.ServerScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class ModBlockEntity
extends BlockEntity {
    private final Runnable onWorldUnloaded = this::onWorldUnloaded;
    private final HashMap<CapabilityCacheKey, LazyOptional<?>> capabilityCache = new HashMap();
    private boolean needsWorldUnloadEvent;
    private boolean isUnloaded;

    protected ModBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(final Capability<T> capability, @Nullable Direction side) {
        if (!this.isValid()) {
            return LazyOptional.empty();
        }
        CapabilityCacheKey key = new CapabilityCacheKey(capability, side);
        LazyOptional value = this.capabilityCache.containsKey(key) ? this.capabilityCache.get(key) : LazyOptional.empty();
        if (!value.isPresent()) {
            final ArrayList list = new ArrayList();
            this.collectCapabilities(new CapabilityCollector(){

                public <TOffered> void offer(Capability<TOffered> offeredCapability, TOffered instance) {
                    if (offeredCapability == capability) {
                        list.add(instance);
                    }
                }
            }, side);
            if (!list.isEmpty()) {
                Object instance = list.get(0);
                value = LazyOptional.of(() -> instance);
            } else {
                value = super.getCapability(capability, side);
            }
            if (value.isPresent()) {
                this.capabilityCache.put(key, value);
                LazyOptionalUtils.addWeakListener(value, this.capabilityCache, (map, optional) -> map.remove(key, optional));
            }
        }
        return value.cast();
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            this.loadClient();
        } else {
            this.loadServer();
            if (this.needsWorldUnloadEvent) {
                ServerScheduler.scheduleOnUnload((LevelAccessor)this.f_58857_, this.onWorldUnloaded);
            }
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onUnload(false);
        this.isUnloaded = true;
    }

    public void onWorldUnloaded() {
        this.invalidateCaps();
        this.onUnload(false);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            this.onUnload(true);
        }
    }

    public boolean isValid() {
        return !this.m_58901_() && !this.isUnloaded;
    }

    protected <T> void invalidateCapability(Capability<T> capability, @Nullable Direction direction) {
        CapabilityCacheKey key = new CapabilityCacheKey(capability, direction);
        LazyOptional<?> value = this.capabilityCache.get(key);
        if (value != null) {
            value.invalidate();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> capability : new ArrayList(this.capabilityCache.values())) {
            capability.invalidate();
        }
    }

    protected void onUnload(boolean isRemove) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.unloadServer(isRemove);
            ServerScheduler.cancelOnUnload((LevelAccessor)this.f_58857_, this.onWorldUnloaded);
        }
    }

    protected void setNeedsLevelUnloadEvent() {
        this.needsWorldUnloadEvent = true;
    }

    protected void collectCapabilities(CapabilityCollector collector, @Nullable Direction direction) {
    }

    protected void loadClient() {
    }

    protected void loadServer() {
    }

    protected void unloadServer(boolean isRemove) {
    }

    private record CapabilityCacheKey(Capability<?> capability, @Nullable Direction direction) {
    }

    @FunctionalInterface
    protected static interface CapabilityCollector {
        public <T> void offer(Capability<T> var1, T var2);
    }
}

