/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.blockentity;

import javax.annotation.Nullable;
import li.cil.oc2r.common.Config;
import li.cil.oc2r.common.block.PciCardCageBlock;
import li.cil.oc2r.common.blockentity.BlockEntities;
import li.cil.oc2r.common.blockentity.ModBlockEntity;
import li.cil.oc2r.common.blockentity.TickableBlockEntity;
import li.cil.oc2r.common.bus.device.vm.block.PciCardCageDevice;
import li.cil.oc2r.common.capabilities.Capabilities;
import li.cil.oc2r.common.energy.FixedEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class PciCardCageBlockEntity
extends ModBlockEntity
implements TickableBlockEntity {
    private static final String ENERGY_TAG_NAME = "energy";
    private static final String HAS_ENERGY_TAG_NAME = "has_energy";
    private final PciCardCageDevice cardCageDevice = new PciCardCageDevice(this, this::handleMountedChanged);
    private boolean isMounted;
    private boolean hasEnergy;
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.cardCageEnergyStorage);

    public PciCardCageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.PCI_CARD_CAGE.get(), pos, state);
    }

    private void handleMountedChanged(boolean value) {
    }

    public boolean hasEnergy() {
        return this.hasEnergy;
    }

    @Override
    public void serverTick() {
        if (!this.isMounted) {
            return;
        }
        if (Config.cardCagesUseEnergy()) {
            boolean isPowered;
            boolean bl = isPowered = this.energy.extractEnergy(Config.cardCageEnergyPerTick, true) >= Config.cardCageEnergyPerTick;
            if (isPowered) {
                this.energy.extractEnergy(Config.cardCageEnergyPerTick, false);
            }
        } else {
            boolean isPowered = true;
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_(HAS_ENERGY_TAG_NAME, this.hasEnergy);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.hasEnergy = tag.m_128471_(HAS_ENERGY_TAG_NAME);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ENERGY_TAG_NAME, (Tag)this.energy.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT((Tag)tag.m_128469_(ENERGY_TAG_NAME));
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (Config.cardCagesUseEnergy()) {
            collector.offer(Capabilities.energyStorage(), this.energy);
        }
        if (direction == ((Direction)this.m_58900_().m_61143_((Property)PciCardCageBlock.f_54117_)).m_122424_()) {
            collector.offer(Capabilities.device(), this.cardCageDevice);
        }
    }
}

