/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.blockentity;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import li.cil.oc2r.api.bus.device.object.Callback;
import li.cil.oc2r.api.bus.device.object.DocumentedDevice;
import li.cil.oc2r.api.bus.device.object.NamedDevice;
import li.cil.oc2r.api.bus.device.object.Parameter;
import li.cil.oc2r.api.util.Side;
import li.cil.oc2r.common.Constants;
import li.cil.oc2r.common.blockentity.BlockEntities;
import li.cil.oc2r.common.blockentity.ModBlockEntity;
import li.cil.oc2r.common.integration.util.BundledRedstone;
import li.cil.oc2r.common.util.HorizontalBlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;

public final class RedstoneInterfaceBlockEntity
extends ModBlockEntity
implements NamedDevice,
DocumentedDevice {
    private static final String OUTPUT_TAG_NAME = "output";
    private static final String BUNDLED_TAG_NAME = "bundled";
    private static final String GET_REDSTONE_INPUT = "getRedstoneInput";
    private static final String GET_REDSTONE_OUTPUT = "getRedstoneOutput";
    private static final String SET_REDSTONE_OUTPUT = "setRedstoneOutput";
    private static final String GET_BUNDLED_INPUT = "getBundledInput";
    private static final String GET_BUNDLED_OUTPUT = "getBundledOutput";
    private static final String SET_BUNDLED_OUTPUT = "setBundledOutput";
    private static final String SET_BUNDLED_OUTPUTS = "setBundledOutputs";
    private static final String SIDE = "side";
    private static final String VALUE = "value";
    private static final String VALUES = "values";
    private static final String COLOUR = "colour";
    private final byte[] output = new byte[Constants.BLOCK_FACE_COUNT];
    private final byte[][] bundled_output = new byte[Constants.BLOCK_FACE_COUNT][16];

    public RedstoneInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.REDSTONE_INTERFACE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128382_(OUTPUT_TAG_NAME, this.output);
        CompoundTag tag_bundled_output = new CompoundTag();
        for (Direction dir : Direction.values()) {
            tag_bundled_output.m_128382_(dir.m_122433_(), this.bundled_output[dir.m_122411_()]);
        }
        tag.m_128365_(BUNDLED_TAG_NAME, (Tag)tag_bundled_output);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        byte[] serializedOutput = tag.m_128463_(OUTPUT_TAG_NAME);
        System.arraycopy(serializedOutput, 0, this.output, 0, Math.min(serializedOutput.length, this.output.length));
        CompoundTag tag_bundled_output = tag.m_128469_(BUNDLED_TAG_NAME);
        for (Direction dir : Direction.values()) {
            byte[] serializedBundledOutput = tag_bundled_output.m_128463_(dir.m_122433_());
            byte[] dest_output = this.bundled_output[dir.m_122411_()];
            System.arraycopy(serializedBundledOutput, 0, dest_output, 0, Math.min(serializedBundledOutput.length, dest_output.length));
        }
    }

    public int getOutputForDirection(Direction direction) {
        Direction localDirection = HorizontalBlockUtils.toLocal(this.m_58900_(), direction);
        assert (localDirection != null);
        return this.output[localDirection.m_122411_()];
    }

    @Callback(name="getRedstoneInput")
    public int getRedstoneInput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        if (this.f_58857_ == null) {
            return 0;
        }
        BlockPos pos = this.m_58899_();
        Direction direction = HorizontalBlockUtils.toGlobal(this.m_58900_(), side);
        assert (direction != null);
        BlockPos neighborPos = pos.m_121945_(direction);
        ChunkPos chunkPos = new ChunkPos(neighborPos);
        if (!this.f_58857_.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return 0;
        }
        return this.f_58857_.m_277185_(neighborPos, direction);
    }

    @Callback(name="getRedstoneOutput", synchronize=false)
    public int getRedstoneOutput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        int index = side.getDirection().m_122411_();
        return this.output[index];
    }

    @Callback(name="setRedstoneOutput")
    public void setRedstoneOutput(@Parameter(value="side") @Nullable Side side, @Parameter(value="values") int value) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        int index = side.getDirection().m_122411_();
        byte clampedValue = (byte)Mth.m_14045_((int)value, (int)0, (int)15);
        if (clampedValue == this.output[index]) {
            return;
        }
        this.output[index] = clampedValue;
        Direction direction = HorizontalBlockUtils.toGlobal(this.m_58900_(), side);
        if (direction != null) {
            this.notifyNeighbor(direction);
        }
        this.m_6596_();
    }

    @Nullable
    @Callback(name="getBundledInput")
    public byte[] getBundledInput(@Parameter(value="side") @Nullable Side side) {
        if (!ModList.get().isLoaded("projectred_transmission")) {
            throw new IllegalStateException();
        }
        if (side == null) {
            throw new IllegalArgumentException();
        }
        BundledRedstone bundledRedstone = BundledRedstone.getInstance();
        if (bundledRedstone.isAvailable()) {
            return bundledRedstone.getBundledInput(this.f_58857_, this.m_58899_(), side.getDirection().m_122424_());
        }
        return new byte[Constants.BLOCK_FACE_COUNT];
    }

    @Callback(name="getBundledOutput")
    public byte[] getBundledOutput(@Parameter(value="side") @Nullable Side side) {
        if (!ModList.get().isLoaded("projectred_transmission")) {
            throw new IllegalStateException();
        }
        if (side == null) {
            throw new IllegalArgumentException();
        }
        int index = side.getDirection().m_122411_();
        return this.bundled_output[index];
    }

    @Callback(name="setBundledOutput")
    public void setBundledOutput(@Parameter(value="side") @Nullable Side side, @Parameter(value="value") int value, @Parameter(value="colour") int color) {
        if (!ModList.get().isLoaded("projectred_transmission")) {
            throw new IllegalStateException();
        }
        if (side == null) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        int index = side.getDirection().m_122424_().m_122411_();
        byte clampedValue = (byte)Mth.m_14045_((int)value, (int)0, (int)255);
        byte clampedColor = (byte)Mth.m_14045_((int)color, (int)0, (int)15);
        if (this.bundled_output[index][clampedColor] != clampedValue) {
            changed = true;
            this.bundled_output[index][clampedColor] = clampedValue;
        }
        if (changed) {
            Direction direction = HorizontalBlockUtils.toGlobal(this.m_58900_(), side);
            if (direction != null) {
                this.notifyNeighbor(direction);
            }
            this.m_6596_();
        }
    }

    @Callback(name="setBundledOutputs")
    public void setBundledOutputs(@Parameter(value="side") @Nullable Side side, @Parameter(value="values") int[] values) {
        if (!ModList.get().isLoaded("projectred_transmission")) {
            throw new IllegalStateException();
        }
        if (side == null) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        int index = side.getDirection().m_122424_().m_122411_();
        for (int i = 0; i < values.length; ++i) {
            byte clampedValue = (byte)Mth.m_14045_((int)values[i], (int)0, (int)255);
            if (clampedValue == this.bundled_output[index][i]) continue;
            this.bundled_output[index][i] = clampedValue;
            changed = true;
        }
        if (changed) {
            Direction direction = HorizontalBlockUtils.toGlobal(this.m_58900_(), side);
            if (direction != null) {
                this.notifyNeighbor(direction);
            }
            this.m_6596_();
        }
    }

    @Override
    public Collection<String> getDeviceTypeNames() {
        return Collections.singletonList("redstone");
    }

    @Override
    public void getDeviceDocumentation(DocumentedDevice.DeviceVisitor visitor) {
        visitor.visitCallback(GET_REDSTONE_INPUT).description("Get the current redstone level received on the specified side. Note that if the current output level on the specified side is not zero, this will affect the measured level.\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device.").returnValueDescription("the current received level on the specified side.").parameterDescription(SIDE, "the side to read the input level from.");
        visitor.visitCallback(GET_REDSTONE_OUTPUT).description("Get the current redstone level transmitted on the specified side. This will return the value last set via setRedstoneOutput().\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device.").returnValueDescription("the current transmitted level on the specified side.").parameterDescription(SIDE, "the side to read the output level from.");
        visitor.visitCallback(SET_REDSTONE_OUTPUT).description("Set the new redstone level transmitted on the specified side.\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device.").parameterDescription(SIDE, "the side to write the output level to.").parameterDescription(VALUE, "the output level to set, will be clamped to [0, 15].");
        if (ModList.get().isLoaded("projectred_transmission")) {
            visitor.visitCallback(GET_BUNDLED_INPUT).description("Get the current bundled level received on the specified side.").parameterDescription(SIDE, "the side to read the bundled input level from");
            visitor.visitCallback(GET_BUNDLED_OUTPUT).description("Get the current bundled level sent out on the specified side.").parameterDescription(SIDE, "the side to read the bundled output level from");
            visitor.visitCallback(SET_BUNDLED_OUTPUT).description("Set the new bundled level transmitted for a specific color on the specified side.\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device.").parameterDescription(SIDE, "the side to write the output level to.").parameterDescription(VALUE, "the output level to set, will be clamped to [0, 255].").parameterDescription(COLOUR, "the colour wire this sets, as int [0, 15]");
            visitor.visitCallback(SET_BUNDLED_OUTPUTS).description("Set the new bundled levels transmitted on the specified side.\nSides may be specified by name or zero-based index. Please note that the side depends on the orientation of the device.").parameterDescription(SIDE, "the side to write the output level to.").parameterDescription(VALUES, "the output levels to set in array form, each value will be clamped to [0, 255], 16 entries.");
        }
    }

    private void notifyNeighbor(Direction direction) {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_46672_(this.m_58899_().m_121945_(direction), this.m_58900_().m_60734_());
    }

    @Nullable
    public byte[] getBundledSignal(Direction direction) {
        int index = direction.m_122411_();
        return this.bundled_output[index];
    }
}

