/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import li.cil.oc2r.api.bus.DeviceBusController;
import li.cil.oc2r.api.bus.DeviceBusElement;
import li.cil.oc2r.api.bus.device.Device;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractDeviceBusElement
implements DeviceBusElement {
    protected final Object2IntArrayMap<Device> devices = new Object2IntArrayMap();
    protected final HashSet<DeviceBusController> controllers = new HashSet();

    public void addDevice(Device device) {
        this.devices.put((Object)device, 0);
        this.scanDevices();
    }

    @Override
    public void addController(DeviceBusController controller) {
        this.controllers.add(controller);
    }

    @Override
    public void removeController(DeviceBusController controller) {
        this.controllers.remove(controller);
    }

    @Override
    public Collection<DeviceBusController> getControllers() {
        return Collections.unmodifiableSet(this.controllers);
    }

    @Override
    public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
        return Optional.of(Collections.emptyList());
    }

    @Override
    public Collection<Device> getLocalDevices() {
        return Collections.unmodifiableSet(this.devices.keySet());
    }

    @Override
    public Optional<UUID> getDeviceIdentifier(Device device) {
        return Optional.empty();
    }

    @Override
    public double getEnergyConsumption() {
        long accumulator = 0L;
        for (Object2IntMap.Entry entry : this.devices.object2IntEntrySet()) {
            accumulator += (long)entry.getIntValue();
        }
        return accumulator;
    }

    @Override
    public Collection<Device> getDevices() {
        if (!this.controllers.isEmpty()) {
            return this.controllers.stream().flatMap(controller -> controller.getDevices().stream()).collect(Collectors.toUnmodifiableSet());
        }
        return this.getLocalDevices();
    }

    @Override
    public void scheduleScan() {
        for (DeviceBusController controller : this.controllers) {
            controller.scheduleBusScan();
        }
    }

    protected void scanDevices() {
        for (DeviceBusController controller : this.controllers) {
            controller.scanDevices();
        }
    }
}

