/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.oc2r.api.bus.device.Device;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2r.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2r.common.bus.AbstractGroupingDeviceBusElement;
import li.cil.oc2r.common.bus.device.provider.Providers;
import li.cil.oc2r.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2r.common.bus.device.util.Devices;
import li.cil.oc2r.common.bus.device.util.ItemDeviceInfo;
import li.cil.oc2r.common.util.ItemDeviceUtils;
import li.cil.oc2r.common.util.RegistryUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class AbstractItemDeviceBusElement
extends AbstractGroupingDeviceBusElement<ItemEntry, ItemDeviceQuery> {
    public AbstractItemDeviceBusElement(int groupCount) {
        super(groupCount);
    }

    public boolean groupContains(int groupIndex, Device device) {
        for (ItemEntry entry : (HashSet)this.groups.get(groupIndex)) {
            if (!Objects.equals(entry.getDevice(), device)) continue;
            return true;
        }
        return false;
    }

    public void handleSlotContentsChanged(int slot, ItemStack stack) {
        ItemQueryResult queryResult = this.collectDevices(stack);
        this.setEntriesForGroup(slot, queryResult);
    }

    public void exportDeviceDataToItemStack(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag exportedTag = new CompoundTag();
        for (ItemEntry entry : (HashSet)this.groups.get(slot)) {
            entry.getDeviceDataKey().ifPresent(key -> {
                CompoundTag deviceTag = new CompoundTag();
                entry.getDevice().exportToItemStack(deviceTag);
                if (!deviceTag.m_128456_()) {
                    exportedTag.m_128365_(key, (Tag)deviceTag);
                }
            });
        }
        if (!exportedTag.m_128456_()) {
            ItemDeviceUtils.setItemDeviceData(stack, exportedTag);
        }
    }

    protected abstract ItemDeviceQuery makeQuery(ItemStack var1);

    protected ItemQueryResult collectDevices(ItemStack stack) {
        ItemDeviceQuery query = this.makeQuery(stack);
        HashSet<ItemEntry> entries = new HashSet<ItemEntry>();
        for (ItemDeviceInfo deviceInfo : Devices.getDevices(query)) {
            entries.add(new ItemEntry(deviceInfo));
        }
        this.collectSyntheticDevices(query, entries);
        this.importDeviceDataFromItemStack(query, entries);
        return new ItemQueryResult(query, entries);
    }

    protected void collectSyntheticDevices(ItemDeviceQuery query, HashSet<ItemEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (query.getItemStack().m_41611_() != null) {
            entries.add(new ItemEntry(new ItemDeviceInfo(null, new TypeNameRPCDevice(query.getItemStack().m_41611_().toString()), 0)));
        }
    }

    @Override
    protected void onEntryRemoved(String dataKey, CompoundTag tag, @Nullable ItemDeviceQuery query) {
        super.onEntryRemoved(dataKey, tag, query);
        IForgeRegistry<ItemDeviceProvider> registry = Providers.itemDeviceProviderRegistry();
        ItemDeviceProvider provider = (ItemDeviceProvider)registry.getValue(new ResourceLocation(dataKey));
        if (provider != null) {
            provider.unmount(query, tag);
        }
    }

    private void importDeviceDataFromItemStack(ItemDeviceQuery query, HashSet<ItemEntry> entries) {
        CompoundTag exportedTag = ItemDeviceUtils.getItemDeviceData(query.getItemStack());
        if (!exportedTag.m_128456_()) {
            for (ItemEntry entry : entries) {
                entry.getDeviceDataKey().ifPresent(key -> {
                    if (exportedTag.m_128425_(key, 10)) {
                        ((ItemDevice)entry.deviceInfo.device).importFromItemStack(exportedTag.m_128469_(key));
                    }
                });
            }
        }
    }

    protected record ItemEntry(ItemDeviceInfo deviceInfo) implements AbstractGroupingDeviceBusElement.Entry
    {
        @Override
        public Optional<String> getDeviceDataKey() {
            return RegistryUtils.optionalKey((ItemDeviceProvider)this.deviceInfo.provider);
        }

        @Override
        public OptionalInt getDeviceEnergyConsumption() {
            return OptionalInt.of(this.deviceInfo.getEnergyConsumption());
        }

        @Override
        public ItemDevice getDevice() {
            return (ItemDevice)this.deviceInfo.device;
        }
    }

    protected final class ItemQueryResult
    extends AbstractGroupingDeviceBusElement.QueryResult {
        @Nullable
        private final ItemDeviceQuery query;
        private final Set<ItemEntry> entries;

        public ItemQueryResult(ItemDeviceQuery query, Set<ItemEntry> entries) {
            this.query = query;
            this.entries = entries;
        }

        @Nullable
        public ItemDeviceQuery getQuery() {
            return this.query;
        }

        public Set<ItemEntry> getEntries() {
            return this.entries;
        }
    }
}

