/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import li.cil.oc2r.api.bus.device.data.BlockDeviceData;
import li.cil.oc2r.common.bus.device.data.BlockDeviceDataRegistry;
import li.cil.oc2r.common.bus.device.data.ResourceBlockDeviceData;
import li.cil.oc2r.common.util.TextFormatUtils;
import li.cil.oc2r.common.vm.fs.LayeredFileSystem;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.ZipStreamFileSystem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class FileSystems {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LayeredFileSystem LAYERED_FILE_SYSTEM = new LayeredFileSystem();
    private static final Map<ResourceLocation, BlockDeviceData> BLOCK_DEVICE_DATA = new HashMap<ResourceLocation, BlockDeviceData>();

    public static FileSystem getLayeredFileSystem() {
        return LAYERED_FILE_SYSTEM;
    }

    public static ResourceLocation getKeyByValue(BlockDeviceData value) {
        for (Map.Entry<ResourceLocation, BlockDeviceData> entry : BLOCK_DEVICE_DATA.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map<ResourceLocation, BlockDeviceData> getBlockData() {
        return BLOCK_DEVICE_DATA;
    }

    public static void reset() {
        LAYERED_FILE_SYSTEM.clear();
        for (BlockDeviceData data : BLOCK_DEVICE_DATA.values()) {
            try {
                ((ResourceBlockDeviceData)data).close();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        BLOCK_DEVICE_DATA.clear();
    }

    @SubscribeEvent
    public static void handleAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ReloadListener.INSTANCE);
    }

    @SubscribeEvent
    public static void handleServerStopped(ServerStoppedEvent event) {
        FileSystems.reset();
    }

    private static void reload(ResourceManager resourceManager) {
        FileSystems.reset();
        LOGGER.info("Searching for datapack filesystems...");
        Set fileSystemDescriptorLocations = resourceManager.m_214159_("file_systems", s -> s.toString().endsWith(".json")).keySet();
        ArrayList<ZipStreamFileSystem> fileSystems = new ArrayList<ZipStreamFileSystem>();
        Object2IntArrayMap fileSystemOrder = new Object2IntArrayMap();
        block15: for (ResourceLocation fileSystemDescriptorLocation : fileSystemDescriptorLocations) {
            LOGGER.info("Found [{}]", (Object)fileSystemDescriptorLocation);
            try {
                String type;
                Resource fileSystemDescriptor = (Resource)resourceManager.m_213713_(fileSystemDescriptorLocation).get();
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(fileSystemDescriptor.m_215507_())).getAsJsonObject();
                switch (type = json.getAsJsonPrimitive("type").getAsString()) {
                    case "layer": {
                        ZipStreamFileSystem fileSystem;
                        ResourceLocation location = new ResourceLocation(json.getAsJsonPrimitive("location").getAsString());
                        try (InputStream stream = ((Resource)resourceManager.m_213713_(location).get()).m_215507_();){
                            fileSystem = new ZipStreamFileSystem(stream);
                        }
                        long fileCount = fileSystem.statfs().fileCount;
                        if (fileCount > 0L) {
                            LOGGER.info("  Adding layer with [{}] file(s).", (Object)fileCount);
                            fileSystems.add(fileSystem);
                        } else {
                            LOGGER.info("  Skipping empty layer.");
                        }
                        if (json.has("order")) {
                            JsonPrimitive order = json.getAsJsonPrimitive("order");
                            fileSystemOrder.put((Object)fileSystem, order.getAsInt());
                            break;
                        }
                        fileSystemOrder.put((Object)fileSystem, 0);
                        break;
                    }
                    case "block": {
                        ResourceLocation location = new ResourceLocation(json.getAsJsonPrimitive("location").getAsString());
                        if (BlockDeviceDataRegistry.getValue(location) != null) {
                            LOGGER.error("Block device from datapack collides with already registered location [{}].", (Object)location);
                            continue block15;
                        }
                        String name = json.has("name") ? json.getAsJsonPrimitive("name").getAsString() : "???";
                        ResourceBlockDeviceData data = new ResourceBlockDeviceData(resourceManager, location, name);
                        LOGGER.info("  Adding block device [{}] with id [{}] and a size of [{}].", (Object)name, (Object)location, (Object)TextFormatUtils.formatSize(data.getBlockDevice().getCapacity()));
                        BLOCK_DEVICE_DATA.put(location, data);
                        break;
                    }
                    default: {
                        LOGGER.error("Unsupported file system type [{}].", (Object)type);
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
            }
        }
        fileSystems.sort(Comparator.comparingInt(arg_0 -> ((Object2IntArrayMap)fileSystemOrder).getInt(arg_0)));
        fileSystems.forEach(LAYERED_FILE_SYSTEM::addLayer);
    }

    private static final class ReloadListener
    implements PreparableReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> FileSystems.reload(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        }
    }
}

