/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.provider.item;

import java.util.Optional;
import java.util.function.Supplier;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2r.common.bus.device.provider.util.AbstractItemDeviceProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractItemStackCapabilityDeviceProvider<TCapability>
extends AbstractItemDeviceProvider {
    private final Supplier<Capability<TCapability>> capabilitySupplier;

    protected AbstractItemStackCapabilityDeviceProvider(Supplier<Capability<TCapability>> capabilitySupplier) {
        this.capabilitySupplier = capabilitySupplier;
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        Capability<TCapability> capability = this.capabilitySupplier.get();
        if (capability == null) {
            throw new IllegalStateException();
        }
        LazyOptional optional = query.getItemStack().getCapability(capability);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        Object value = optional.orElseThrow(AssertionError::new);
        return this.getItemDevice(query, value);
    }

    protected abstract Optional<ItemDevice> getItemDevice(ItemDeviceQuery var1, TCapability var2);
}

