/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.provider.item;

import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2r.common.Config;
import li.cil.oc2r.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2r.common.bus.device.vm.item.HardDriveDevice;
import li.cil.oc2r.common.item.HardDriveItem;
import li.cil.oc2r.common.util.LocationSupplierUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public final class HardDriveItemDeviceProvider
extends AbstractItemDeviceProvider {
    public HardDriveItemDeviceProvider() {
        super(HardDriveItem.class);
    }

    @Override
    public void unmount(@Nullable ItemDeviceQuery query, CompoundTag tag) {
        super.unmount(query, tag);
        HardDriveDevice.unmount(tag);
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        return Optional.of(new HardDriveDevice(query.getItemStack(), HardDriveItemDeviceProvider.getCapacity(query), false, LocationSupplierUtils.of(query)));
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        return Math.max(1, (int)Math.round((double)HardDriveItemDeviceProvider.getCapacity(query) * Config.hardDriveEnergyPerMegabytePerTick / 1048576.0));
    }

    private static int getCapacity(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveItem item = (HardDriveItem)stack.m_41720_();
        return Math.max(item.getCapacity(stack), 0);
    }
}

