/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.provider.util;

import java.util.function.Supplier;
import li.cil.oc2r.api.bus.device.Device;
import li.cil.oc2r.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2r.api.util.Invalidatable;
import li.cil.oc2r.common.bus.device.provider.util.AbstractBlockEntityDeviceProvider;
import li.cil.oc2r.common.util.LazyOptionalUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractBlockEntityCapabilityDeviceProvider<TCapability, TBlockEntity extends BlockEntity>
extends AbstractBlockEntityDeviceProvider<TBlockEntity> {
    private final Supplier<Capability<TCapability>> capabilitySupplier;

    protected AbstractBlockEntityCapabilityDeviceProvider(BlockEntityType<TBlockEntity> blockEntityType, Supplier<Capability<TCapability>> capabilitySupplier) {
        super(blockEntityType);
        this.capabilitySupplier = capabilitySupplier;
    }

    protected AbstractBlockEntityCapabilityDeviceProvider(Supplier<Capability<TCapability>> capabilitySupplier) {
        this.capabilitySupplier = capabilitySupplier;
    }

    @Override
    protected final Invalidatable<Device> getBlockDevice(BlockDeviceQuery query, TBlockEntity blockEntity) {
        Capability<TCapability> capability = this.capabilitySupplier.get();
        if (capability == null) {
            throw new IllegalStateException();
        }
        LazyOptional optional = blockEntity.getCapability(capability, query.getQuerySide());
        if (!optional.isPresent()) {
            return Invalidatable.empty();
        }
        Object value = optional.orElseThrow(AssertionError::new);
        Invalidatable<Device> device = this.getBlockDevice(query, (TCapability)value);
        LazyOptionalUtils.addWeakListener(optional, device, (invalidatable, unused) -> invalidatable.invalidate());
        return device;
    }

    @Override
    protected abstract Invalidatable<Device> getBlockDevice(BlockDeviceQuery var1, TCapability var2);
}

