/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.provider.util;

import java.util.Optional;
import java.util.function.Predicate;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2r.api.bus.device.provider.ItemDeviceQuery;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public abstract class AbstractItemDeviceProvider
implements ItemDeviceProvider {
    private final Predicate<Item> predicate;

    private AbstractItemDeviceProvider(Predicate<Item> predicate) {
        this.predicate = predicate;
    }

    protected AbstractItemDeviceProvider(RegistryObject<? extends Item> item) {
        this((Item i) -> i == item.get());
    }

    protected AbstractItemDeviceProvider(Class<? extends Item> type) {
        this(type::isInstance);
    }

    protected AbstractItemDeviceProvider() {
        this.predicate = i -> true;
    }

    @Override
    public final Optional<ItemDevice> getDevice(ItemDeviceQuery query) {
        return this.matches(query) ? this.getItemDevice(query) : Optional.empty();
    }

    @Override
    public final int getEnergyConsumption(ItemDeviceQuery query) {
        return this.matches(query) ? this.getItemDeviceEnergyConsumption(query) : 0;
    }

    protected boolean matches(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        return !stack.m_41619_() && this.predicate.test(stack.m_41720_());
    }

    protected abstract Optional<ItemDevice> getItemDevice(ItemDeviceQuery var1);

    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        return 0;
    }
}

