/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.rpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Map;
import li.cil.oc2r.common.bus.device.rpc.RPCItemStackTagFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RPCItemStackTagFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ArrayList<RPCItemStackTagFilter> FILTERS = new ArrayList();

    public static CompoundTag getFilteredTag(ItemStack stack, CompoundTag tag) {
        CompoundTag result = new CompoundTag();
        for (RPCItemStackTagFilter filter : FILTERS) {
            CompoundTag filtered = filter.apply(stack, tag);
            if (filtered == null) continue;
            result.m_128391_(filtered);
        }
        return result;
    }

    @SubscribeEvent
    public static void handleAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ReloadListener.INSTANCE);
    }

    private static final class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "item_tag_filters");
        }

        protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
            FILTERS.clear();
            objects.forEach((location, element) -> {
                try {
                    RPCItemStackTagFilter filter = (RPCItemStackTagFilter)GSON.fromJson(element, RPCItemStackTagFilter.class);
                    if (filter != null) {
                        FILTERS.add(filter);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed loading item tag filter [{}].", location, (Object)e);
                }
            });
        }
    }
}

