/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.rpc.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import li.cil.oc2r.api.bus.device.object.Callback;
import li.cil.oc2r.api.bus.device.object.DocumentedDevice;
import li.cil.oc2r.api.bus.device.object.Parameter;
import li.cil.oc2r.api.capabilities.TerminalUserProvider;
import li.cil.oc2r.common.bus.device.rpc.item.AbstractItemRPCDevice;
import li.cil.oc2r.common.network.Network;
import li.cil.oc2r.common.network.message.ExportedFileMessage;
import li.cil.oc2r.common.network.message.RequestImportedFileMessage;
import li.cil.oc2r.common.network.message.ServerCanceledImportFileMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class FileImportExportCardItemDevice
extends AbstractItemRPCDevice
implements DocumentedDevice {
    public static final int MAX_TRANSFERRED_FILE_SIZE = 0x100000;
    private static final String BEGIN_EXPORT_FILE = "beginExportFile";
    private static final String WRITE_EXPORT_FILE = "writeExportFile";
    private static final String FINISH_EXPORT_FILE = "finishExportFile";
    private static final String REQUEST_IMPORT_FILE = "requestImportFile";
    private static final String BEGIN_IMPORT_FILE = "beginImportFile";
    private static final String READ_IMPORT_FILE = "readImportFile";
    private static final String RESET = "reset";
    private static final String NAME = "name";
    private static final String DATA = "data";
    private static final Int2ObjectArrayMap<ImportFileRequest> importingDevices = new Int2ObjectArrayMap();
    private static int nextImportId = 1;
    private final TerminalUserProvider userProvider;
    private State state;
    private ExportedFile exportedFile;
    private int importingId;
    private ImportedFile importedFile;

    public FileImportExportCardItemDevice(ItemStack identity, TerminalUserProvider userProvider) {
        super(identity, "file_import_export");
        this.userProvider = userProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setImportedFile(int id, String name, byte[] data) {
        Int2ObjectArrayMap<ImportFileRequest> int2ObjectArrayMap = importingDevices;
        synchronized (int2ObjectArrayMap) {
            FileImportExportCardItemDevice device;
            ImportFileRequest request = (ImportFileRequest)importingDevices.remove(id);
            if (request != null && (device = (FileImportExportCardItemDevice)request.Device.get()) != null) {
                device.importedFile = new ImportedFile(name, data);
                ServerCanceledImportFileMessage message = new ServerCanceledImportFileMessage(id);
                for (ServerPlayer serverPlayer : request.PendingPlayers) {
                    Network.sendToClient(message, serverPlayer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelImport(ServerPlayer player, int id) {
        Int2ObjectArrayMap<ImportFileRequest> int2ObjectArrayMap = importingDevices;
        synchronized (int2ObjectArrayMap) {
            ImportFileRequest request = (ImportFileRequest)importingDevices.get(id);
            if (request != null) {
                request.PendingPlayers.remove(player);
                if (request.PendingPlayers.isEmpty()) {
                    importingDevices.remove(id);
                    FileImportExportCardItemDevice device = (FileImportExportCardItemDevice)request.Device.get();
                    if (device != null) {
                        device.state = State.IMPORT_CANCELED;
                    }
                }
            }
        }
    }

    @Override
    public void unmount() {
        this.reset();
    }

    @Callback(name="beginExportFile", synchronize=false)
    public void beginExportFile(@Parameter(value="name") String name) {
        if (this.state != State.IDLE) {
            throw new IllegalStateException("invalid state");
        }
        if (StringUtil.m_14408_((String)name)) {
            throw new IllegalArgumentException("name must not be empty");
        }
        this.state = State.EXPORTING;
        this.exportedFile = new ExportedFile(name);
    }

    @Callback(name="writeExportFile", synchronize=false)
    public void writeExportFile(@Parameter(value="data") @Nullable byte[] data) throws IOException {
        if (this.state != State.EXPORTING) {
            throw new IllegalStateException("invalid state");
        }
        if (data == null) {
            throw new IllegalArgumentException("data is required");
        }
        this.exportedFile.data.write(data);
        if (this.exportedFile.data.size() > 0x100000) {
            this.reset();
            throw new IllegalArgumentException("exported file too large");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback(name="finishExportFile")
    public void finishExportFile() {
        if (this.state != State.EXPORTING) {
            throw new IllegalStateException("invalid state");
        }
        try {
            for (Player player : this.userProvider.getTerminalUsers()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ExportedFileMessage message = new ExportedFileMessage(this.exportedFile.name, this.exportedFile.data.toByteArray());
                Network.sendToClient(message, serverPlayer);
            }
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback(name="requestImportFile")
    public boolean requestImportFile() {
        if (this.state != State.IDLE) {
            throw new IllegalStateException("invalid state");
        }
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        for (Player player : this.userProvider.getTerminalUsers()) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            players.add(serverPlayer);
        }
        if (players.isEmpty()) {
            return false;
        }
        this.state = State.IMPORT_REQUESTED;
        this.importingId = nextImportId++;
        Iterator<Object> iterator = importingDevices;
        synchronized (iterator) {
            importingDevices.put(this.importingId, (Object)new ImportFileRequest(this));
        }
        for (ServerPlayer serverPlayer : players) {
            RequestImportedFileMessage message = new RequestImportedFileMessage(this.importingId);
            Network.sendToClient(message, serverPlayer);
        }
        return true;
    }

    @Nullable
    @Callback(name="beginImportFile")
    public ImportedFileInfo beginImportFile() {
        if (this.state == State.IMPORT_CANCELED) {
            this.reset();
            throw new IllegalStateException("import was canceled");
        }
        if (this.state != State.IMPORT_REQUESTED) {
            throw new IllegalStateException("invalid state");
        }
        if (this.importedFile == null) {
            return null;
        }
        this.state = State.IMPORTING;
        return new ImportedFileInfo(this.importedFile.name, this.importedFile.size);
    }

    @Nullable
    @Callback(name="readImportFile")
    public byte[] readImportFile() throws IOException {
        if (this.state == State.IMPORT_CANCELED) {
            this.reset();
            throw new IllegalStateException("import was canceled");
        }
        if (this.state != State.IMPORTING) {
            throw new IllegalStateException("invalid state");
        }
        if (this.importedFile == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[512];
        int count = this.importedFile.data.read(buffer);
        if (count <= 0) {
            this.reset();
            return null;
        }
        if (count < buffer.length) {
            byte[] data = new byte[count];
            System.arraycopy(buffer, 0, data, 0, count);
            return data;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback(name="reset")
    public void reset() {
        this.state = State.IDLE;
        this.exportedFile = null;
        this.importedFile = null;
        Int2ObjectArrayMap<ImportFileRequest> int2ObjectArrayMap = importingDevices;
        synchronized (int2ObjectArrayMap) {
            importingDevices.remove(this.importingId);
        }
    }

    @Override
    public void getDeviceDocumentation(DocumentedDevice.DeviceVisitor visitor) {
        visitor.visitCallback(BEGIN_EXPORT_FILE).description("Begins exporting a file to external data storage. Requires calls to writeExportFile() to provide data of the exported file and a call to finishExportFile() to complete the export.\nThis method may error if the device is currently exporting or importing.").parameterDescription(NAME, "the name of the file being exported.");
        visitor.visitCallback(WRITE_EXPORT_FILE).description("Appends more data to the currently being exported file.\nThis method may error if the device is not currently exporting or the export was interrupted.\n").parameterDescription(DATA, "the contents of the file being exported.");
        visitor.visitCallback(FINISH_EXPORT_FILE).description("Finishes an export. This will prompt present users to select an external file location for the file being exported. If multiple users are present, the file is provided to all users.\nThis method may error if the device is not currently exporting or the export was interrupted.");
        visitor.visitCallback(BEGIN_IMPORT_FILE).description("Begins a file import operation. This will prompt present users to select an externally stored file for import. If multiple users are present, the first user to select a file will have their file uploaded. Use the readImportFile() method to read the contents of the file being imported.\nThis method may error if the device is currently exporting or importing.");
        visitor.visitCallback(READ_IMPORT_FILE).description("Tries to read some data from a file being imported. Returns zero length data if no data is available yet. Returns null when no more data is available.\nThis method may error if the device is not currently importing or the import was interrupted.").returnValueDescription("data from the file being imported.");
        visitor.visitCallback(RESET).description("Resets the device and cancels any currently running export or import operation.");
    }

    private static final class ImportFileRequest {
        public final Set<ServerPlayer> PendingPlayers = Collections.newSetFromMap(new WeakHashMap());
        public final WeakReference<FileImportExportCardItemDevice> Device;

        private ImportFileRequest(FileImportExportCardItemDevice device) {
            this.Device = new WeakReference<FileImportExportCardItemDevice>(device);
        }
    }

    private static final class ImportedFile {
        public final String name;
        public final int size;
        public final ByteArrayInputStream data;

        private ImportedFile(String name, byte[] data) {
            this.name = name;
            this.size = data.length;
            this.data = new ByteArrayInputStream(data);
        }
    }

    private static enum State {
        IDLE,
        EXPORTING,
        IMPORT_REQUESTED,
        IMPORTING,
        IMPORT_CANCELED;

    }

    private static final class ExportedFile {
        public final String name;
        public final ByteArrayOutputStream data = new ByteArrayOutputStream();

        private ExportedFile(String name) {
            this.name = name;
        }
    }

    public record ImportedFileInfo(String name, int size) {
    }
}

