/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.rpc.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.oc2r.api.bus.device.object.Callback;
import li.cil.oc2r.api.bus.device.object.Parameter;
import li.cil.oc2r.api.capabilities.Robot;
import li.cil.oc2r.api.util.RobotOperationSide;
import li.cil.oc2r.common.bus.device.rpc.item.AbstractItemRPCDevice;
import li.cil.oc2r.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public final class InventoryOperationsModuleDevice
extends AbstractItemRPCDevice {
    private final Entity entity;
    private final Robot robot;

    public InventoryOperationsModuleDevice(ItemStack identity, Entity entity, Robot robot) {
        super(identity, "inventory_operations");
        this.entity = entity;
        this.robot = robot;
    }

    @Callback
    public void move(@Parameter(value="fromSlot") int fromSlot, @Parameter(value="intoSlot") int intoSlot, @Parameter(value="count") int count) {
        if (count <= 0) {
            return;
        }
        ItemStackHandler inventory = this.robot.getInventory();
        ItemStack extracted = inventory.extractItem(fromSlot, count, true);
        ItemStack remaining = inventory.insertItem(intoSlot, extracted, true);
        extracted = inventory.extractItem(fromSlot, extracted.m_41613_() - remaining.m_41613_(), false);
        remaining = inventory.insertItem(intoSlot, extracted, false);
        if (!(remaining = inventory.insertItem(fromSlot, remaining, false)).m_41619_()) {
            this.entity.m_19983_(remaining);
        }
    }

    @Callback
    public int drop(@Parameter(value="count") int count) {
        return this.drop(count, null);
    }

    @Callback
    public int drop(@Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        IItemHandler handler;
        if (count <= 0) {
            return 0;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStack stack = this.robot.getInventory().extractItem(selectedSlot, count, false);
        if (stack.m_41619_()) {
            return 0;
        }
        int originalStackSize = stack.m_41613_();
        Direction direction = RobotOperationSide.toGlobal(this.entity, side);
        List<IItemHandler> itemHandlers = this.getItemStackHandlersInDirection(direction).toList();
        Iterator<IItemHandler> iterator = itemHandlers.iterator();
        while (iterator.hasNext() && !(stack = ItemHandlerHelper.insertItemStacked((IItemHandler)(handler = iterator.next()), (ItemStack)stack, (boolean)false)).m_41619_()) {
        }
        int dropped = originalStackSize - stack.m_41613_();
        if (!stack.m_41619_() && !itemHandlers.isEmpty()) {
            stack = this.robot.getInventory().insertItem(selectedSlot, stack, false);
        }
        if (!stack.m_41619_()) {
            dropped += stack.m_41613_();
            this.entity.m_19983_(stack);
        }
        return dropped;
    }

    @Callback
    public int dropInto(@Parameter(value="intoSlot") int intoSlot, @Parameter(value="count") int count) {
        return this.dropInto(intoSlot, count, null);
    }

    @Callback
    public int dropInto(@Parameter(value="intoSlot") int intoSlot, @Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        if (count <= 0) {
            return 0;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStack stack = this.robot.getInventory().extractItem(selectedSlot, count, false);
        if (stack.m_41619_()) {
            return 0;
        }
        int originalStackSize = stack.m_41613_();
        Direction direction = RobotOperationSide.toGlobal(this.entity, side);
        Optional<IItemHandler> optional = this.getItemStackHandlersInDirection(direction).findFirst();
        if (optional.isPresent()) {
            stack = optional.get().insertItem(intoSlot, stack, false);
        }
        int dropped = originalStackSize - stack.m_41613_();
        if (!stack.m_41619_()) {
            stack = this.robot.getInventory().insertItem(selectedSlot, stack, false);
        }
        if (!stack.m_41619_()) {
            dropped += stack.m_41613_();
            this.entity.m_19983_(stack);
        }
        return dropped;
    }

    @Callback
    public int take(@Parameter(value="count") int count) {
        return this.take(count, null);
    }

    @Callback
    public int take(@Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        if (count <= 0) {
            return 0;
        }
        Direction direction = RobotOperationSide.toGlobal(this.entity, side);
        List<IItemHandler> handlers = this.getItemStackHandlersInDirection(direction).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return this.takeFromWorld(count);
        }
        return this.takeFromInventories(count, handlers);
    }

    @Callback
    public int takeFrom(@Parameter(value="fromSlot") int fromSlot, @Parameter(value="count") int count) {
        return this.takeFrom(fromSlot, count, null);
    }

    @Callback
    public int takeFrom(@Parameter(value="fromSlot") int fromSlot, @Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        if (count <= 0) {
            return 0;
        }
        Direction direction = RobotOperationSide.toGlobal(this.entity, side);
        return this.getItemStackHandlersInDirection(direction).findFirst().map(handler -> this.takeFromInventory(count, (IItemHandler)handler, fromSlot)).orElse(0);
    }

    private ItemStack insertStartingAt(IItemHandler handler, ItemStack stack, int startSlot, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            int slot = (startSlot + i) % handler.getSlots();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    private Stream<IItemHandler> getItemStackHandlersInDirection(Direction direction) {
        return this.getItemStackHandlersAt(Vec3.m_82512_((Vec3i)this.entity.m_20183_().m_121945_(direction)), direction.m_122424_());
    }

    private Stream<IItemHandler> getItemStackHandlersAt(Vec3 position, Direction side) {
        return Stream.concat(this.getEntityItemHandlersAt(position, side), this.getBlockItemHandlersAt(position, side));
    }

    private Stream<IItemHandler> getEntityItemHandlersAt(Vec3 position, Direction side) {
        AABB bounds = AABB.m_82333_((Vec3)position.m_82492_(0.5, 0.5, 0.5));
        return this.entity.m_9236_().m_45933_(this.entity, bounds).stream().map(e -> e.getCapability(Capabilities.itemHandler(), side)).filter(LazyOptional::isPresent).map(c -> (IItemHandler)c.orElseThrow(AssertionError::new));
    }

    private Stream<IItemHandler> getBlockItemHandlersAt(Vec3 position, Direction side) {
        Vec3i posi = new Vec3i((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
        BlockPos pos = new BlockPos(posi);
        BlockEntity blockEntity = this.entity.m_9236_().m_7702_(pos);
        if (blockEntity == null) {
            return Stream.empty();
        }
        LazyOptional capability = blockEntity.getCapability(Capabilities.itemHandler(), side);
        if (capability.isPresent()) {
            return Stream.of((IItemHandler)capability.orElseThrow(AssertionError::new));
        }
        return Stream.empty();
    }

    private List<ItemEntity> getItemsInRange() {
        return this.entity.m_9236_().m_45976_(ItemEntity.class, this.entity.m_20191_().m_82400_(1.0));
    }

    private int takeFromWorld(int count) {
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        int remaining = count;
        for (ItemEntity itemEntity : this.getItemsInRange()) {
            ItemStack original = itemEntity.m_32055_().m_41777_();
            ItemStack stackToInsert = original.m_41777_();
            if (stackToInsert.m_41613_() > remaining) {
                stackToInsert.m_41764_(remaining);
            }
            ItemStack overflow = this.insertStartingAt((IItemHandler)inventory, stackToInsert, selectedSlot, false);
            int taken = stackToInsert.m_41613_() - overflow.m_41613_();
            remaining -= taken;
            original.m_41774_(taken);
            itemEntity.m_32045_(original);
        }
        return count - remaining;
    }

    private int takeFromInventories(int count, List<IItemHandler> handlers) {
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        int remaining = count;
        for (IItemHandler handler : handlers) {
            for (int fromSlot = 0; fromSlot < handler.getSlots(); ++fromSlot) {
                ItemStack extracted = handler.extractItem(fromSlot, remaining, true);
                ItemStack overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, true);
                int delta = extracted.m_41613_() - overflow.m_41613_();
                if (delta == 0) continue;
                remaining -= delta;
                extracted = handler.extractItem(fromSlot, delta, false);
                overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, false);
                remaining += overflow.m_41613_();
                if ((overflow = handler.insertItem(fromSlot, overflow, false)).m_41619_()) continue;
                remaining -= overflow.m_41613_();
                this.entity.m_19983_(overflow);
            }
            if (remaining > 0) continue;
            break;
        }
        return count - remaining;
    }

    private int takeFromInventory(int count, IItemHandler handler, int slot) {
        ItemStackHandler inventory = this.robot.getInventory();
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStack extracted = handler.extractItem(slot, count, true);
        ItemStack overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, true);
        int taken = extracted.m_41613_() - overflow.m_41613_();
        extracted = handler.extractItem(slot, taken, false);
        overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, false);
        taken -= overflow.m_41613_();
        if (!(overflow = handler.insertItem(slot, overflow, false)).m_41619_()) {
            this.entity.m_19983_(overflow);
        }
        return taken;
    }
}

