/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.vm.block;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import li.cil.oc2r.common.bus.device.vm.block.FlashMemoryFlasherContainer;
import li.cil.oc2r.common.bus.device.vm.item.AbstractBlockStorageDevice;
import li.cil.oc2r.common.item.FlashMemoryItem;
import li.cil.oc2r.common.serialization.BlobStorage;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class FlashMemoryFlasherDevice<T extends BlockEntity>
extends AbstractBlockStorageDevice<BlockDevice, T> {
    private static final ByteBufferBlockDevice EMPTY_BLOCK_DEVICE = ByteBufferBlockDevice.create((int)0, (boolean)false);

    public FlashMemoryFlasherDevice(T container) {
        super(container, false);
    }

    public void updateBlockDevice(CompoundTag tag) {
        this.joinOpenJob();
        if (this.device == null) {
            return;
        }
        try {
            this.device.setBlock((BlockDevice)EMPTY_BLOCK_DEVICE);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        if (this.blobHandle != null) {
            BlobStorage.close(this.blobHandle);
            this.blobHandle = null;
        }
        this.importFromItemStack(tag);
        this.setOpenJob((CompletableFuture<Void>)this.createBlockDevice().thenAcceptAsync(blockDevice -> {
            try {
                this.device.setBlock(blockDevice);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (Executor)WORKERS));
    }

    public void removeBlockDevice() {
        this.joinOpenJob();
        if (this.device == null) {
            return;
        }
        try {
            this.device.setBlock((BlockDevice)EMPTY_BLOCK_DEVICE);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        if (this.blobHandle != null) {
            BlobStorage.close(this.blobHandle);
            this.blobHandle = null;
        }
    }

    @Override
    protected CompletableFuture<BlockDevice> createBlockDevice() {
        Item item;
        ItemStack stack = ((FlashMemoryFlasherContainer)((BlockEntity)this.identity)).getDiskItemStack();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof FlashMemoryItem)) {
            return CompletableFuture.completedFuture(EMPTY_BLOCK_DEVICE);
        }
        FlashMemoryItem floppy = (FlashMemoryItem)item;
        int capacity = floppy.getCapacity(stack);
        if (capacity <= 0) {
            return CompletableFuture.completedFuture(EMPTY_BLOCK_DEVICE);
        }
        this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
        return CompletableFuture.supplyAsync(() -> {
            try {
                FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, capacity);
                return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, WORKERS);
    }

    @Override
    protected void handleDataAccess() {
        ((FlashMemoryFlasherContainer)((BlockEntity)this.identity)).handleDataAccess();
    }
}

