/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.vm.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.vm.VMDevice;
import li.cil.oc2r.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2r.api.bus.device.vm.context.VMContext;
import li.cil.oc2r.api.capabilities.NetworkInterface;
import li.cil.oc2r.common.bus.device.util.IdentityProxy;
import li.cil.oc2r.common.bus.device.util.OptionalAddress;
import li.cil.oc2r.common.bus.device.util.OptionalInterrupt;
import li.cil.oc2r.common.capabilities.Capabilities;
import li.cil.oc2r.common.serialization.NBTSerialization;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.device.virtio.VirtIONetworkDevice;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractNetworkInterfaceDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice,
ICapabilityProvider {
    private static final String DEVICE_TAG_NAME = "device";
    private static final String ADDRESS_TAG_NAME = "address";
    private static final String INTERRUPT_TAG_NAME = "interrupt";
    private VirtIONetworkDevice device;
    private final NetworkInterface networkInterface = new NetworkInterfaceImpl();
    private boolean isRunning;
    private final OptionalAddress address = new OptionalAddress();
    private final OptionalInterrupt interrupt = new OptionalInterrupt();
    private CompoundTag deviceTag;

    protected AbstractNetworkInterfaceDevice(ItemStack identity) {
        super(identity);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.networkInterface()) {
            return LazyOptional.of(() -> this.networkInterface).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        this.device = new VirtIONetworkDevice(context.getMemoryMap());
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.interrupt.claim(context)) {
            return VMDeviceLoadResult.fail();
        }
        this.device.getInterrupt().set(this.interrupt.getAsInt(), context.getInterruptController());
        if (this.deviceTag != null) {
            NBTSerialization.deserialize(this.deviceTag, this.device);
        }
        context.getEventBus().register(this);
        this.isRunning = true;
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.device = null;
        this.isRunning = false;
    }

    @Override
    public void dispose() {
        this.address.clear();
        this.interrupt.clear();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.device != null) {
            this.deviceTag = NBTSerialization.serialize(this.device);
        }
        if (this.deviceTag != null) {
            tag.m_128365_(DEVICE_TAG_NAME, (Tag)this.deviceTag);
        }
        if (this.address.isPresent()) {
            tag.m_128356_(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        if (this.interrupt.isPresent()) {
            tag.m_128405_(INTERRUPT_TAG_NAME, this.interrupt.getAsInt());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(DEVICE_TAG_NAME, 10)) {
            this.deviceTag = tag.m_128469_(DEVICE_TAG_NAME);
        }
        if (tag.m_128425_(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.m_128454_(ADDRESS_TAG_NAME));
        }
        if (tag.m_128425_(INTERRUPT_TAG_NAME, 3)) {
            this.interrupt.set(tag.m_128451_(INTERRUPT_TAG_NAME));
        }
    }

    protected NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    private final class NetworkInterfaceImpl
    implements NetworkInterface {
        private NetworkInterfaceImpl() {
        }

        @Override
        public byte[] readEthernetFrame() {
            if (AbstractNetworkInterfaceDevice.this.device != null && AbstractNetworkInterfaceDevice.this.isRunning) {
                return AbstractNetworkInterfaceDevice.this.device.readEthernetFrame();
            }
            return null;
        }

        @Override
        public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
            if (AbstractNetworkInterfaceDevice.this.device != null && AbstractNetworkInterfaceDevice.this.isRunning) {
                AbstractNetworkInterfaceDevice.this.device.writeEthernetFrame(frame);
            }
        }
    }
}

