/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.vm.item;

import com.google.common.eventbus.Subscribe;
import java.nio.ByteBuffer;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.vm.FirmwareLoader;
import li.cil.oc2r.api.bus.device.vm.VMDevice;
import li.cil.oc2r.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2r.api.bus.device.vm.context.VMContext;
import li.cil.oc2r.api.bus.device.vm.event.VMInitializationException;
import li.cil.oc2r.api.bus.device.vm.event.VMInitializingEvent;
import li.cil.oc2r.common.Constants;
import li.cil.oc2r.common.bus.device.util.IdentityProxy;
import li.cil.oc2r.common.bus.device.util.OptionalAddress;
import li.cil.oc2r.common.serialization.BlobStorage;
import li.cil.oc2r.common.util.ItemStackUtils;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.flash.FlashMemoryDevice;
import li.cil.sedna.memory.MemoryMaps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class ByteBufferFlashStorageDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice,
FirmwareLoader {
    public static final String DATA_TAG_NAME = "data";
    private final int size;
    private MemoryMap memoryMap;
    private ByteBuffer data;
    private FlashMemoryDevice device;
    private CompoundTag deviceTag;
    private final OptionalAddress address = new OptionalAddress();

    public ByteBufferFlashStorageDevice(ItemStack identity, int size) {
        super(identity);
        this.size = size;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        this.loadPersistedState();
        this.memoryMap = context.getMemoryMap();
        context.getEventBus().register(this);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.memoryMap = null;
        this.data = null;
        this.device = null;
    }

    @Override
    public void dispose() {
        this.deviceTag = null;
        this.address.clear();
    }

    @Subscribe
    public void handleInitializingEvent(VMInitializingEvent event) {
        this.copyDataToMemory(event.programStartAddress());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.device != null) {
            tag.m_128382_(DATA_TAG_NAME, this.device.getData().array());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        byte[] data = tag.m_128463_(DATA_TAG_NAME);
        ByteBuffer bufferData = ByteBuffer.allocate(this.size);
        bufferData.clear();
        bufferData.put(data, 0, Math.min(bufferData.limit(), data.length));
        this.data = bufferData;
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(0xC00000)) {
            return false;
        }
        if (this.data == null) {
            try {
                this.data = ByteBuffer.allocate(0xC00000);
                this.data.clear();
                CompoundTag tag = ItemStackUtils.getModDataTag((ItemStack)this.identity).m_128469_(DATA_TAG_NAME);
                if (tag.m_128403_("blob")) {
                    BlobStorage.getOrOpen(tag.m_128342_("blob")).read(this.data, 0L);
                }
            }
            catch (Exception e) {
                System.out.println("Error message: " + e.getMessage());
            }
        }
        this.device = new FlashMemoryDevice(this.data);
        return true;
    }

    private void loadPersistedState() {
        if (this.deviceTag != null) {
            this.data.clear();
            byte[] persistedData = this.deviceTag.m_128463_(DATA_TAG_NAME);
            this.data.put(persistedData, 0, Math.min(persistedData.length, this.data.capacity()));
        }
    }

    private void copyDataToMemory(long startAddress) {
        ByteBuffer data = this.device.getData();
        data.clear();
        try {
            MemoryMaps.store((MemoryMap)this.memoryMap, (long)startAddress, (ByteBuffer)data);
        }
        catch (MemoryAccessException e) {
            throw new VMInitializationException((Component)Component.m_237115_((String)Constants.COMPUTER_ERROR_INSUFFICIENT_MEMORY));
        }
    }
}

