/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.vm.item;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import li.cil.oc2r.common.bus.device.vm.item.AbstractBlockStorageDevice;
import li.cil.oc2r.common.serialization.BlobStorage;
import li.cil.oc2r.common.util.BlockLocation;
import li.cil.oc2r.common.util.SoundEvents;
import li.cil.oc2r.common.util.ThrottledSoundEmitter;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class HardDriveDevice
extends AbstractBlockStorageDevice<ByteBufferBlockDevice, ItemStack> {
    private final int size;
    private final ThrottledSoundEmitter soundEmitter;

    public HardDriveDevice(ItemStack identity, int size, boolean readonly, Supplier<Optional<BlockLocation>> location) {
        super(identity, readonly);
        this.size = size;
        this.soundEmitter = new ThrottledSoundEmitter(location, (SoundEvent)SoundEvents.HDD_ACCESS.get()).withMinInterval(Duration.ofSeconds(1L));
    }

    @Override
    protected CompletableFuture<ByteBufferBlockDevice> createBlockDevice() {
        this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
        return CompletableFuture.supplyAsync(() -> {
            try {
                FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
                return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)this.readonly);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, WORKERS);
    }

    @Override
    protected void handleDataAccess() {
        this.soundEmitter.play();
    }
}

