/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.bus.device.vm.item;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import li.cil.oc2r.api.bus.device.ItemDevice;
import li.cil.oc2r.api.bus.device.vm.VMDevice;
import li.cil.oc2r.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2r.api.bus.device.vm.context.VMContext;
import li.cil.oc2r.common.bus.device.util.IdentityProxy;
import li.cil.oc2r.common.bus.device.util.OptionalAddress;
import li.cil.oc2r.common.serialization.BlobStorage;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.device.memory.ByteBufferMemory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MemoryDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BLOB_HANDLE_TAG_NAME = "blob";
    private static final String ADDRESS_TAG_NAME = "address";
    private final int size;
    private PhysicalMemory device;
    private final OptionalAddress address = new OptionalAddress();
    private UUID blobHandle;

    public MemoryDevice(ItemStack identity, int capacity) {
        super(identity);
        this.size = capacity;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.closeDevice();
        if (this.blobHandle != null) {
            BlobStorage.close(this.blobHandle);
        }
    }

    @Override
    public void dispose() {
        if (this.blobHandle != null) {
            BlobStorage.delete(this.blobHandle);
            this.blobHandle = null;
        }
        this.address.clear();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.blobHandle != null) {
            tag.m_128362_(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
        if (this.address.isPresent()) {
            tag.m_128356_(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128403_(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = tag.m_128342_(BLOB_HANDLE_TAG_NAME);
        }
        if (tag.m_128425_(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.m_128454_(ADDRESS_TAG_NAME));
        }
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(4096)) {
            return false;
        }
        try {
            this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
            FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
            this.device = new ByteBufferMemory(this.size, (ByteBuffer)buffer);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return false;
        }
        return true;
    }

    private void closeDevice() {
        if (this.device == null) {
            return;
        }
        try {
            this.device.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        this.device = null;
    }
}

