/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.container;

import javax.annotation.Nullable;
import li.cil.oc2r.common.container.LockedSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractContainer
extends AbstractContainerMenu {
    protected static final int HOTBAR_SIZE = 9;
    protected static final int SLOT_SIZE = 18;
    protected static final int PLAYER_INVENTORY_ROWS = 3;
    protected static final int PLAYER_INVENTORY_COLUMNS = 9;
    protected static final int PLAYER_INVENTORY_HOTBAR_SPACING = 4;

    public AbstractContainer(@Nullable MenuType<?> type, int id) {
        super(type, id);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot into;
        int i;
        int step;
        Slot from = (Slot)this.f_38839_.get(index);
        ItemStack stack = from.m_7993_().m_41777_();
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        boolean intoPlayerInventory = from.f_40218_ != player.m_150109_();
        ItemStack fromStack = from.m_7993_();
        if (intoPlayerInventory) {
            step = -1;
            begin = this.f_38839_.size() - 1;
        } else {
            step = 1;
            begin = 0;
        }
        if (fromStack.m_41741_() > 1) {
            for (i = begin; i >= 0 && i < this.f_38839_.size(); i += step) {
                int itemsMoved;
                int maxSizeInSlot;
                int spaceInSlot;
                ItemStack intoStack;
                boolean itemsAreEqual;
                into = (Slot)this.f_38839_.get(i);
                if (into.f_40218_ == from.f_40218_ || !into.m_5857_(fromStack) || !into.m_6657_() || !(itemsAreEqual = fromStack.equals(intoStack = into.m_7993_(), false)) || (spaceInSlot = (maxSizeInSlot = Math.min(fromStack.m_41741_(), into.m_5866_(stack))) - intoStack.m_41613_()) <= 0 || (itemsMoved = Math.min(spaceInSlot, fromStack.m_41613_())) <= 0) continue;
                intoStack.m_41769_(from.m_6201_(itemsMoved).m_41613_());
                into.m_6654_();
                if (from.m_7993_().m_41619_()) break;
            }
        }
        for (i = begin; i >= 0 && i < this.f_38839_.size() && !from.m_7993_().m_41619_(); i += step) {
            into = (Slot)this.f_38839_.get(i);
            if (into.f_40218_ == from.f_40218_ || !into.m_5857_(fromStack) || into.m_6657_()) continue;
            int maxSizeInSlot = Math.min(fromStack.m_41741_(), into.m_5866_(fromStack));
            int itemsMoved = Math.min(maxSizeInSlot, fromStack.m_41613_());
            into.m_5852_(from.m_6201_(itemsMoved));
        }
        return from.m_7993_().m_41613_() < stack.m_41613_() ? from.m_7993_() : ItemStack.f_41583_;
    }

    protected int createPlayerInventoryAndHotbarSlots(Inventory inventory, int startX, int startY) {
        int nextIndex = this.createHotbarSlots(inventory, 0, startX, startY + 54 + 4);
        return this.createPlayerInventorySlots(inventory, nextIndex, startX, startY);
    }

    protected int createPlayerInventorySlots(Inventory inventory, int startIndex, int startX, int startY) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = startIndex + row * 9 + column;
                int x = startX + column * 18;
                int y = startY + row * 18;
                LockedSlot slot = this.isSlotLocked(inventory, index) ? new LockedSlot((Container)inventory, index, x, y) : new Slot((Container)inventory, index, x, y);
                this.m_38897_(slot);
            }
        }
        return startIndex + 27;
    }

    protected int createHotbarSlots(Inventory inventory, int startIndex, int startX, int startY) {
        for (int i = 0; i < 9; ++i) {
            int index = startIndex + i;
            int x = startX + i * 18;
            LockedSlot slot = this.isSlotLocked(inventory, index) ? new LockedSlot((Container)inventory, index, x, startY) : new Slot((Container)inventory, index, x, startY);
            this.m_38897_(slot);
        }
        return startIndex + 9;
    }

    protected boolean isSlotLocked(Inventory inventory, int slot) {
        return false;
    }
}

