/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.container;

import java.nio.ByteBuffer;
import li.cil.oc2r.common.bus.CommonDeviceBusController;
import li.cil.oc2r.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2r.common.container.IntPrecisionContainerData;
import li.cil.oc2r.common.energy.FixedEnergyStorage;
import li.cil.oc2r.common.entity.Robot;
import li.cil.oc2r.common.network.Network;
import li.cil.oc2r.common.network.message.OpenRobotInventoryMessage;
import li.cil.oc2r.common.network.message.OpenRobotTerminalMessage;
import li.cil.oc2r.common.network.message.RobotPowerMessage;
import li.cil.oc2r.common.network.message.RobotTerminalInputMessage;
import li.cil.oc2r.common.vm.Terminal;
import li.cil.oc2r.common.vm.VirtualMachine;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public abstract class AbstractRobotContainer
extends AbstractMachineTerminalContainer {
    private final Robot robot;

    public AbstractRobotContainer(MenuType<?> type, int id, Player player, Robot robot, IntPrecisionContainerData energyInfo) {
        super(type, id, energyInfo);
        this.robot = robot;
        this.robot.addTerminalUser(player);
    }

    @Override
    public void switchToInventory() {
        Network.sendToServer(new OpenRobotInventoryMessage(this.robot));
    }

    @Override
    public void switchToTerminal() {
        Network.sendToServer(new OpenRobotTerminalMessage(this.robot));
    }

    public Robot getRobot() {
        return this.robot;
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.robot.getVirtualMachine();
    }

    @Override
    public void sendPowerStateToServer(boolean value) {
        Network.sendToServer(new RobotPowerMessage(this.robot, value));
    }

    @Override
    public Terminal getTerminal() {
        return this.robot.getTerminal();
    }

    @Override
    public void sendTerminalInputToServer(ByteBuffer input) {
        Network.sendToServer(new RobotTerminalInputMessage(this.robot, input));
    }

    public boolean m_6875_(Player player) {
        return this.robot.m_6084_() && this.robot.m_19950_((Entity)player, 8.0);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.robot.removeTerminalUser(player);
    }

    protected static IntPrecisionContainerData createEnergyInfo(final FixedEnergyStorage energy, final CommonDeviceBusController busController) {
        return new IntPrecisionContainerData.Server(){

            @Override
            public int getInt(int index) {
                return switch (index) {
                    case 0 -> energy.getEnergyStored();
                    case 1 -> energy.getMaxEnergyStored();
                    case 2 -> busController.getEnergyConsumption();
                    default -> 0;
                };
            }

            @Override
            public int getIntCount() {
                return 3;
            }
        };
    }
}

