/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.integration.jei;

import java.util.HashSet;
import java.util.List;
import li.cil.oc2r.client.gui.AbstractMachineInventoryScreen;
import li.cil.oc2r.client.gui.AbstractMachineTerminalScreen;
import li.cil.oc2r.common.block.ComputerBlock;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class ExtraGuiAreasJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("oc2r", "extra_gui_areas");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        HashSet<ItemStack> removals = new HashSet<ItemStack>();
        removals.add(ComputerBlock.getPreconfiguredComputer());
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, removals);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractMachineInventoryScreen.class, (IGuiContainerHandler)new AbstractMachineInventoryScreenGuiContainerHandler());
        registration.addGenericGuiContainerHandler(AbstractMachineTerminalScreen.class, (IGuiContainerHandler)new AbstractMachineTerminalScreenGuiContainerHandler());
    }

    private static final class AbstractMachineInventoryScreenGuiContainerHandler
    implements IGuiContainerHandler<AbstractMachineInventoryScreen<?>> {
        private AbstractMachineInventoryScreenGuiContainerHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(AbstractMachineInventoryScreen<?> screen) {
            return screen.getExtraAreas();
        }
    }

    private static final class AbstractMachineTerminalScreenGuiContainerHandler
    implements IGuiContainerHandler<AbstractMachineTerminalScreen<?>> {
        private AbstractMachineTerminalScreenGuiContainerHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(AbstractMachineTerminalScreen<?> screen) {
            return screen.getExtraAreas();
        }
    }
}

