/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.integration.jei;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import li.cil.oc2r.common.item.Items;
import li.cil.oc2r.common.util.ItemStackUtils;
import li.cil.oc2r.common.util.NBTUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class ExtraItemsJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("oc2r", "extra_items");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Items.COMPUTER.get()), (IIngredientSubtypeInterpreter)new ComputerSubtypeInterpreter());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Items.ROBOT.get()), (IIngredientSubtypeInterpreter)new RobotSubtypeInterpreter());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Items.HARD_DRIVE_CUSTOM.get()), (IIngredientSubtypeInterpreter)new BlockDeviceSubtypeInterpreter());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Items.FLASH_MEMORY_CUSTOM.get()), (IIngredientSubtypeInterpreter)new BlockDeviceSubtypeInterpreter());
    }

    private static String stableTagToString(@Nullable Tag tag) {
        StringBuilder stringBuilder = new StringBuilder();
        ExtraItemsJEIPlugin.stableTagToString(tag, stringBuilder);
        return stringBuilder.toString();
    }

    private static void stableTagToString(@Nullable Tag tag, StringBuilder stringBuilder) {
        if (tag == null) {
            stringBuilder.append("null");
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            stringBuilder.append("{");
            compoundTag.m_128431_().stream().sorted().forEach(key -> {
                stringBuilder.append((String)key).append(":");
                ExtraItemsJEIPlugin.stableTagToString(compoundTag.m_128423_(key), stringBuilder);
                stringBuilder.append(",");
            });
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("}");
        } else if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            stringBuilder.append("[");
            for (Tag childTag : listTag) {
                ExtraItemsJEIPlugin.stableTagToString(childTag, stringBuilder);
                stringBuilder.append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("]");
        } else if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            stringBuilder.append(numericTag.m_8103_());
        } else {
            stringBuilder.append(tag);
        }
    }

    private static final class ComputerSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private ComputerSubtypeInterpreter() {
        }

        public String apply(ItemStack ingredient, UidContext context) {
            CompoundTag itemsTag = NBTUtils.getChildTag(ingredient.m_41783_(), "BlockEntityTag", "items");
            return itemsTag.m_128456_() ? "" : ExtraItemsJEIPlugin.stableTagToString((Tag)itemsTag);
        }
    }

    private static final class RobotSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private RobotSubtypeInterpreter() {
        }

        public String apply(ItemStack ingredient, UidContext context) {
            CompoundTag itemsTag = NBTUtils.getChildTag(ingredient.m_41783_(), "oc2r", "items");
            return itemsTag.m_128456_() ? "" : ExtraItemsJEIPlugin.stableTagToString((Tag)itemsTag);
        }
    }

    private static final class BlockDeviceSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private BlockDeviceSubtypeInterpreter() {
        }

        public String apply(ItemStack ingredient, UidContext context) {
            String registryName = ItemStackUtils.getModDataTag(ingredient).m_128461_("data");
            return Strings.isNullOrEmpty((String)registryName) ? "" : registryName;
        }
    }
}

