/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.integration.projectred;

import li.cil.oc2r.common.blockentity.RedstoneInterfaceBlockEntity;
import li.cil.oc2r.common.integration.util.BundledRedstone;
import mrtjp.projectred.api.IBundledTileInteraction;
import mrtjp.projectred.api.ITransmissionAPI;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class BundledCableHandler
implements IBundledTileInteraction {
    private final ITransmissionAPI transmissionAPI;

    public static void initialize() {
        if (ProjectRedAPI.transmissionAPI != null) {
            BundledCableHandler handler = new BundledCableHandler(ProjectRedAPI.transmissionAPI);
            ProjectRedAPI.transmissionAPI.registerBundledTileInteraction((IBundledTileInteraction)handler);
            BundledRedstone.getInstance().register(handler);
        }
    }

    private BundledCableHandler(ITransmissionAPI transmissionAPI) {
        this.transmissionAPI = transmissionAPI;
    }

    public boolean isValidInteractionFor(Level level, BlockPos blockPos, Direction direction) {
        BlockEntity entity = level.m_7702_(blockPos);
        return entity instanceof RedstoneInterfaceBlockEntity;
    }

    public boolean canConnectBundled(Level level, BlockPos blockPos, Direction direction) {
        BlockEntity entity = level.m_7702_(blockPos);
        return entity instanceof RedstoneInterfaceBlockEntity;
    }

    @Nullable
    public byte[] getBundledSignal(Level level, BlockPos blockPos, Direction direction) {
        BlockEntity entity = level.m_7702_(blockPos);
        if (entity instanceof RedstoneInterfaceBlockEntity) {
            RedstoneInterfaceBlockEntity rs = (RedstoneInterfaceBlockEntity)entity;
            return rs.getBundledSignal(direction);
        }
        return null;
    }

    public byte[] getBundledInput(Level level, BlockPos blockPos, Direction direction) {
        return this.transmissionAPI.getBundledInput(level, blockPos, direction);
    }
}

