/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2r.client.gui.NetworkInterfaceCardScreen;
import li.cil.oc2r.common.Constants;
import li.cil.oc2r.common.item.Items;
import li.cil.oc2r.common.item.ModItem;
import li.cil.oc2r.common.util.ItemStackUtils;
import li.cil.oc2r.common.util.TextFormatUtils;
import li.cil.oc2r.common.util.TranslationUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class NetworkInterfaceCardItem
extends ModItem {
    private static final String SIDE_CONFIGURATION_TAG_NAME = "sides";
    private static final Component IS_CONFIGURED_TEXT = TextFormatUtils.withFormat(TranslationUtils.text("item.{mod}.network_interface_card.is_configured"), ChatFormatting.GREEN);

    public static void setSideConfiguration(ItemStack stack, Direction side, boolean enabled) {
        byte[] values;
        int index = side.m_122411_();
        CompoundTag tag = ItemStackUtils.getOrCreateModDataTag(stack);
        if (tag.m_128425_(SIDE_CONFIGURATION_TAG_NAME, 7) && tag.m_128463_(SIDE_CONFIGURATION_TAG_NAME).length == Constants.BLOCK_FACE_COUNT) {
            values = tag.m_128463_(SIDE_CONFIGURATION_TAG_NAME);
        } else {
            values = new byte[Constants.BLOCK_FACE_COUNT];
            Arrays.fill(values, (byte)1);
        }
        values[index] = (byte)(enabled ? 1 : 0);
        tag.m_128382_(SIDE_CONFIGURATION_TAG_NAME, values);
    }

    public static boolean getSideConfiguration(ItemStack stack, @Nullable Direction side) {
        byte[] values;
        if (side == null) {
            return false;
        }
        int index = side.m_122411_();
        CompoundTag tag = ItemStackUtils.getModDataTag(stack);
        if (tag.m_128425_(SIDE_CONFIGURATION_TAG_NAME, 7) && index < (values = tag.m_128463_(SIDE_CONFIGURATION_TAG_NAME)).length) {
            return values[index] != 0;
        }
        return true;
    }

    public static boolean hasConfiguration(ItemStack stack) {
        byte[] values;
        for (byte value : values = ItemStackUtils.getModDataTag(stack).m_128463_(SIDE_CONFIGURATION_TAG_NAME)) {
            if (value != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (NetworkInterfaceCardItem.hasConfiguration(stack)) {
            tooltip.add(IS_CONFIGURED_TEXT);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_9236_().m_5776_() && itemStack.m_150930_((Item)Items.NETWORK_INTERFACE_CARD.get())) {
            this.openConfigurationScreen(player, hand);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)player.m_9236_().m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openConfigurationScreen(Player player, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new NetworkInterfaceCardScreen(player, hand));
    }
}

