/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.mixin;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import li.cil.oc2r.client.renderer.ProjectorDepthRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    private Frustum f_172938_;
    @Shadow
    @Nullable
    private RenderTarget f_109414_;
    @Nullable
    private RenderTarget itemEntityTargetBak;
    @Shadow
    @Nullable
    private RenderTarget f_109416_;
    @Nullable
    private RenderTarget weatherTargetBak;

    @Shadow
    protected abstract void m_109703_(LightTexture var1, float var2, double var3, double var5, double var7);

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void prepareDepthRendering(CallbackInfo ci) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            this.itemEntityTargetBak = this.f_109414_;
            this.f_109414_ = null;
            this.weatherTargetBak = this.f_109416_;
            this.f_109416_ = null;
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void cleanupDepthRendering(CallbackInfo ci) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            this.cleanupDepthRendering();
        }
    }

    private void cleanupDepthRendering() {
        this.f_109416_ = this.weatherTargetBak;
        this.f_109414_ = this.itemEntityTargetBak;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=destroyProgress"})}, cancellable=true)
    private void captureDepthAndEarlyExit(PoseStack stack, float partialTicks, long startNanos, boolean shouldRenderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            this.cleanupDepthRendering();
            MultiBufferSource.BufferSource bufferSource = this.f_109464_.m_110104_();
            this.f_109461_.f_91061_.render(stack, bufferSource, lightTexture, camera, partialTicks, this.f_172938_);
            bufferSource.m_109911_();
            Vec3 cameraPosition = camera.m_90583_();
            this.m_109703_(lightTexture, partialTicks, cameraPosition.m_7096_(), cameraPosition.m_7098_(), cameraPosition.m_7094_());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.applyModelViewMatrix();
            FogRenderer.m_109017_();
            ci.cancel();
        } else if (ProjectorDepthRenderer.willRenderProjectorDepth()) {
            MultiBufferSource.BufferSource bufferSource = this.f_109464_.m_110104_();
            bufferSource.m_109912_(Sheets.m_110792_());
            bufferSource.m_109912_(Sheets.m_110762_());
            bufferSource.m_109912_(Sheets.m_110782_());
            ProjectorDepthRenderer.captureMainCameraDepth();
        }
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;depthMask(Z)V", shift=At.Shift.AFTER)})
    private void enableDepthForWeatherInDepthBuffer(CallbackInfo ci) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            RenderSystem.depthMask((boolean)true);
        }
    }

    @Inject(method={"shouldShowEntityOutlines"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipOutlines(CallbackInfoReturnable<Boolean> cir) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipSky(CallbackInfo ci) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            ci.cancel();
        }
    }

    @Inject(method={"entityTarget", "getItemEntityTarget", "getWeatherTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectToMainTarget(CallbackInfoReturnable<RenderTarget> cir) {
        if (ProjectorDepthRenderer.isIsRenderingProjectorDepth()) {
            cir.setReturnValue((Object)Minecraft.m_91087_().m_91385_());
        }
    }
}

