/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import li.cil.oc2r.common.util.LevelUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public final class MessageUtils {
    public static <T extends BlockEntity> void withNearbyServerBlockEntityForInteraction(NetworkEvent.Context context, BlockPos pos, Class<T> type, BiConsumer<ServerPlayer, T> callback) {
        ServerPlayer player = context.getSender();
        if (player == null || !pos.m_203195_((Position)player.m_20182_(), 8.0)) {
            return;
        }
        MessageUtils.withNearbyServerBlockEntity(context, pos, type, callback);
    }

    public static <T extends BlockEntity> void withNearbyServerBlockEntity(NetworkEvent.Context context, BlockPos pos, Class<T> type, BiConsumer<ServerPlayer, T> callback) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        ServerLevel level = player.m_20194_().m_129880_(player.m_9236_().m_46472_());
        BlockEntity blockEntity = LevelUtils.getBlockEntityIfChunkExists((LevelAccessor)level, pos);
        if (type.isInstance(blockEntity)) {
            callback.accept(player, (ServerPlayer)blockEntity);
        }
    }

    public static <T extends Entity> void withServerEntity(NetworkEvent.Context context, int id, Class<T> type, Consumer<T> callback) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        ServerLevel level = player.m_20194_().m_129880_(player.m_9236_().m_46472_());
        Entity entity = level.m_6815_(id);
        if (type.isInstance(entity)) {
            callback.accept(entity);
        }
    }

    public static <T extends Entity> void withNearbyServerEntity(NetworkEvent.Context context, int id, Class<T> type, Consumer<T> callback) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        ServerLevel level = player.m_20194_().m_129880_(player.m_9236_().m_46472_());
        Entity entity = level.m_6815_(id);
        if (type.isInstance(entity) && entity.m_19950_((Entity)player, 8.0)) {
            callback.accept(entity);
        }
    }

    public static <T extends BlockEntity> void withClientBlockEntityAt(BlockPos pos, Class<T> type, Consumer<T> callback) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (type.isInstance(blockEntity)) {
            callback.accept(blockEntity);
        }
    }

    public static <T extends Entity> void withClientEntity(int id, Class<T> type, Consumer<T> callback) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(id);
        if (type.isInstance(entity)) {
            callback.accept(entity);
        }
    }
}

