/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.network.message;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import li.cil.oc2r.client.gui.FileChooserScreen;
import li.cil.oc2r.common.network.message.AbstractMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExportedFileMessage
extends AbstractMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private String name;
    private byte[] data;

    public ExportedFileMessage(String name, byte[] data) {
        this.name = name;
        this.data = data;
    }

    public ExportedFileMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.name = buffer.m_130277_();
        this.data = buffer.m_130052_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.m_130087_(this.data);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        FileChooserScreen.openFileChooserForSave(this.name, path -> {
            try {
                Files.write(path, this.data, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        });
    }
}

