/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.network.message;

import li.cil.oc2r.common.blockentity.MonitorBlockEntity;
import li.cil.oc2r.common.network.MessageUtils;
import li.cil.oc2r.common.network.Network;
import li.cil.oc2r.common.network.message.AbstractMessage;
import li.cil.oc2r.common.network.message.MonitorPowerMessageForwarded;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public final class MonitorPowerMessage
extends AbstractMessage {
    private BlockPos pos;
    private boolean power;

    public MonitorPowerMessage(MonitorBlockEntity monitor, boolean power) {
        this.pos = monitor.m_58899_();
        this.power = power;
    }

    public MonitorPowerMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.power = buffer.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.power);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        MessageUtils.withNearbyServerBlockEntityForInteraction(context, this.pos, MonitorBlockEntity.class, (player, monitor) -> {
            if (this.power) {
                monitor.start();
            } else {
                monitor.stop();
            }
            Network.sendToClientsTrackingBlockEntity(new MonitorPowerMessageForwarded((MonitorBlockEntity)monitor, this.power), monitor);
        });
    }
}

