/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2r.common.network.message;

import li.cil.oc2r.common.item.Items;
import li.cil.oc2r.common.item.NetworkInterfaceCardItem;
import li.cil.oc2r.common.network.message.AbstractMessage;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public final class NetworkInterfaceCardConfigurationMessage
extends AbstractMessage {
    private InteractionHand hand;
    private Direction side;
    private boolean value;

    public NetworkInterfaceCardConfigurationMessage(InteractionHand hand, Direction side, boolean value) {
        this.hand = hand;
        this.side = side;
        this.value = value;
    }

    public NetworkInterfaceCardConfigurationMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        this.hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        this.side = (Direction)buffer.m_130066_(Direction.class);
        this.value = buffer.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
        buffer.m_130068_((Enum)this.side);
        buffer.writeBoolean(this.value);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.m_21120_(this.hand);
        if (!itemStack.m_150930_((Item)Items.NETWORK_INTERFACE_CARD.get())) {
            return;
        }
        NetworkInterfaceCardItem.setSideConfiguration(itemStack, this.side, this.value);
    }
}

